/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.generator;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.generator.Generator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;

public class ServerGenerator
extends Generator {
    private static final byte[] STATUS = new byte[]{83, 116, 97, 116, 117, 115};
    private static final byte[] COLON = new byte[]{58, 32};
    private static final byte[] EOL = new byte[]{13, 10};
    private final boolean sendStatus200;

    public ServerGenerator(ByteBufferPool byteBufferPool) {
        this(byteBufferPool, true);
    }

    public ServerGenerator(ByteBufferPool byteBufferPool, boolean sendStatus200) {
        super(byteBufferPool);
        this.sendStatus200 = sendStatus200;
    }

    public Generator.Result generateResponseHeaders(int request, int code, String reason, HttpFields fields, Callback callback) {
        request &= 0xFFFF;
        Charset utf8 = StandardCharsets.UTF_8;
        ArrayList<Object> bytes = new ArrayList<Object>(fields.size() * 2);
        int length = 0;
        if (code != 200 || this.sendStatus200) {
            bytes.add(STATUS);
            length += STATUS.length + COLON.length;
            if (reason == null) {
                reason = HttpStatus.getMessage((int)code);
            }
            Object responseBytes = (code + " " + reason).getBytes(utf8);
            bytes.add(responseBytes);
            length += ((Object)responseBytes).length + EOL.length;
        }
        for (HttpField field : fields) {
            String name = field.getName();
            byte[] nameBytes = name.getBytes(utf8);
            bytes.add(nameBytes);
            String value = field.getValue();
            byte[] valueBytes = value.getBytes(utf8);
            bytes.add(valueBytes);
            length += nameBytes.length + COLON.length;
            length += valueBytes.length + EOL.length;
        }
        ByteBuffer buffer = this.byteBufferPool.acquire(length += EOL.length, true);
        BufferUtil.clearToFill((ByteBuffer)buffer);
        for (int i = 0; i < bytes.size(); i += 2) {
            buffer.put((byte[])bytes.get(i)).put(COLON).put((byte[])bytes.get(i + 1)).put(EOL);
        }
        buffer.put(EOL);
        buffer.flip();
        return this.generateContent(request, buffer, true, false, callback, FCGI.FrameType.STDOUT);
    }

    public Generator.Result generateResponseContent(int request, ByteBuffer content, boolean lastContent, boolean aborted, Callback callback) {
        if (aborted) {
            Generator.Result result = new Generator.Result(this.byteBufferPool, callback);
            if (lastContent) {
                result.append(this.generateEndRequest(request, true), true);
            } else {
                result.append(BufferUtil.EMPTY_BUFFER, false);
            }
            return result;
        }
        Generator.Result result = this.generateContent(request, content, false, lastContent, callback, FCGI.FrameType.STDOUT);
        if (lastContent) {
            result.append(this.generateEndRequest(request, false), true);
        }
        return result;
    }

    private ByteBuffer generateEndRequest(int request, boolean aborted) {
        ByteBuffer endRequestBuffer = this.byteBufferPool.acquire(8, false);
        BufferUtil.clearToFill((ByteBuffer)endRequestBuffer);
        endRequestBuffer.putInt(0x1030000 + (request &= 0xFFFF));
        endRequestBuffer.putInt(524288);
        endRequestBuffer.putInt(aborted ? 1 : 0);
        endRequestBuffer.putInt(0);
        endRequestBuffer.flip();
        return endRequestBuffer;
    }
}

