/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.generator;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.generator.Generator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;

public class ClientGenerator
extends Generator {
    public static final int MAX_PARAM_LENGTH = 32763;

    public ClientGenerator(ByteBufferPool byteBufferPool) {
        super(byteBufferPool);
    }

    public Generator.Result generateRequestHeaders(int request, HttpFields fields, Callback callback) {
        request &= 0xFFFF;
        Charset utf8 = StandardCharsets.UTF_8;
        ArrayList<byte[]> bytes = new ArrayList<byte[]>(fields.size() * 2);
        int fieldsLength = 0;
        for (HttpField field : fields) {
            String name = field.getName();
            byte[] nameBytes = name.getBytes(utf8);
            if (nameBytes.length > 32763) {
                throw new IllegalArgumentException("Field name " + name + " exceeds max length " + 32763);
            }
            bytes.add(nameBytes);
            String value = field.getValue();
            byte[] valueBytes = value.getBytes(utf8);
            if (valueBytes.length > 32763) {
                throw new IllegalArgumentException("Field value " + value + " exceeds max length " + 32763);
            }
            bytes.add(valueBytes);
            int nameLength = nameBytes.length;
            fieldsLength += this.bytesForLength(nameLength);
            int valueLength = valueBytes.length;
            fieldsLength += this.bytesForLength(valueLength);
            fieldsLength += nameLength;
            fieldsLength += valueLength;
        }
        int maxCapacity = 65534;
        ByteBuffer beginRequestBuffer = this.byteBufferPool.acquire(16, false);
        BufferUtil.clearToFill((ByteBuffer)beginRequestBuffer);
        Generator.Result result = new Generator.Result(this.byteBufferPool, callback);
        result = result.append(beginRequestBuffer, true);
        beginRequestBuffer.putInt(0x1010000 + request);
        beginRequestBuffer.putInt(524288);
        beginRequestBuffer.putLong(0x1010000000000L);
        beginRequestBuffer.flip();
        int index = 0;
        while (fieldsLength > 0) {
            int capacity = 8 + Math.min(maxCapacity, fieldsLength);
            ByteBuffer buffer = this.byteBufferPool.acquire(capacity, true);
            BufferUtil.clearToFill((ByteBuffer)buffer);
            result = result.append(buffer, true);
            buffer.putInt(0x1040000 + request);
            buffer.putShort((short)0);
            buffer.putShort((short)0);
            capacity -= 8;
            int length = 0;
            while (index < bytes.size()) {
                byte[] nameBytes = (byte[])bytes.get(index);
                int nameLength = nameBytes.length;
                byte[] valueBytes = (byte[])bytes.get(index + 1);
                int valueLength = valueBytes.length;
                int required = this.bytesForLength(nameLength) + this.bytesForLength(valueLength) + nameLength + valueLength;
                if (required > capacity) break;
                this.putParamLength(buffer, nameLength);
                this.putParamLength(buffer, valueLength);
                buffer.put(nameBytes);
                buffer.put(valueBytes);
                length += required;
                fieldsLength -= required;
                capacity -= required;
                index += 2;
            }
            buffer.putShort(4, (short)length);
            buffer.flip();
        }
        ByteBuffer lastParamsBuffer = this.byteBufferPool.acquire(8, false);
        BufferUtil.clearToFill((ByteBuffer)lastParamsBuffer);
        result = result.append(lastParamsBuffer, true);
        lastParamsBuffer.putInt(0x1040000 + request);
        lastParamsBuffer.putInt(0);
        lastParamsBuffer.flip();
        return result;
    }

    private int putParamLength(ByteBuffer buffer, int length) {
        int result = this.bytesForLength(length);
        if (result == 4) {
            buffer.putInt(length | Integer.MIN_VALUE);
        } else {
            buffer.put((byte)length);
        }
        return result;
    }

    private int bytesForLength(int length) {
        return length > 127 ? 4 : 1;
    }

    public Generator.Result generateRequestContent(int request, ByteBuffer content, boolean lastContent, Callback callback) {
        return this.generateContent(request, content, false, lastContent, callback, FCGI.FrameType.STDIN);
    }
}

