/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.parser;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.parser.ClientParser;
import org.eclipse.jetty.fcgi.parser.HeaderParser;
import org.eclipse.jetty.fcgi.parser.StreamContentParser;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ResponseContentParser
extends StreamContentParser {
    private static final Logger LOG = Log.getLogger(ResponseContentParser.class);
    private final Map<Integer, ResponseParser> parsers = new ConcurrentHashMap<Integer, ResponseParser>();
    private final ClientParser.Listener listener;

    public ResponseContentParser(HeaderParser headerParser, ClientParser.Listener listener) {
        super(headerParser, FCGI.StreamType.STD_OUT, listener);
        this.listener = listener;
    }

    @Override
    public void noContent() {
    }

    @Override
    protected boolean onContent(ByteBuffer buffer) {
        int request = this.getRequest();
        ResponseParser parser = this.parsers.get(request);
        if (parser == null) {
            parser = new ResponseParser(this.listener, request);
            this.parsers.put(request, parser);
        }
        return parser.parse(buffer);
    }

    @Override
    protected void end(int request) {
        super.end(request);
        this.parsers.remove(request);
    }

    private static enum State {
        HEADERS,
        CONTENT_MODE,
        RAW_CONTENT,
        HTTP_CONTENT;

    }

    private static class FCGIHttpParser
    extends HttpParser {
        private FCGIHttpParser(HttpParser.ResponseHandler<ByteBuffer> handler) {
            super(handler, 66560, true);
            this.reset();
        }

        public void reset() {
            super.reset();
            this.setState(HttpParser.State.HEADER);
        }

        protected boolean parseHeaders(ByteBuffer buffer) {
            return super.parseHeaders(buffer);
        }

        protected boolean parseContent(ByteBuffer buffer) {
            return super.parseContent(buffer);
        }

        protected void setResponseStatus(int status) {
            super.setResponseStatus(status);
        }
    }

    private class ResponseParser
    implements HttpParser.ResponseHandler<ByteBuffer> {
        private final HttpFields fields = new HttpFields();
        private ClientParser.Listener listener;
        private final int request;
        private final FCGIHttpParser httpParser;
        private State state = State.HEADERS;
        private boolean seenResponseCode;

        private ResponseParser(ClientParser.Listener listener, int request) {
            this.listener = listener;
            this.request = request;
            this.httpParser = new FCGIHttpParser(this);
        }

        public boolean parse(ByteBuffer buffer) {
            LOG.debug("Response {} {} content {} {}", new Object[]{this.request, FCGI.StreamType.STD_OUT, this.state, buffer});
            int remaining = buffer.remaining();
            block6: while (remaining > 0) {
                switch (this.state) {
                    case HEADERS: {
                        if (this.httpParser.parseHeaders(buffer)) {
                            this.state = State.CONTENT_MODE;
                        }
                        remaining = buffer.remaining();
                        continue block6;
                    }
                    case CONTENT_MODE: {
                        boolean rawContent = this.fields.size() == 0 || this.fields.get(HttpHeader.CONTENT_LENGTH) == null && this.fields.get(HttpHeader.TRANSFER_ENCODING) == null;
                        this.state = rawContent ? State.RAW_CONTENT : State.HTTP_CONTENT;
                        continue block6;
                    }
                    case RAW_CONTENT: {
                        if (this.notifyContent(buffer)) {
                            return true;
                        }
                        remaining = 0;
                        continue block6;
                    }
                    case HTTP_CONTENT: {
                        this.httpParser.parseContent(buffer);
                        remaining = buffer.remaining();
                        continue block6;
                    }
                }
                throw new IllegalStateException();
            }
            return false;
        }

        public int getHeaderCacheSize() {
            return 0;
        }

        public boolean startResponse(HttpVersion version, int status, String reason) {
            throw new IllegalStateException();
        }

        public boolean parsedHeader(HttpField httpField) {
            try {
                String name = httpField.getName();
                if ("Status".equalsIgnoreCase(name)) {
                    if (!this.seenResponseCode) {
                        this.seenResponseCode = true;
                        String[] parts = httpField.getValue().split(" ");
                        int code = Integer.parseInt(parts[0]);
                        this.httpParser.setResponseStatus(code);
                        String reason = parts.length > 1 ? parts[1] : HttpStatus.getMessage((int)code);
                        this.notifyBegin(code, reason);
                        this.notifyHeaders(this.fields);
                    }
                } else if (this.seenResponseCode) {
                    this.notifyHeader(httpField);
                } else {
                    this.fields.add(httpField);
                }
            }
            catch (Throwable x) {
                StreamContentParser.logger.debug("Exception while invoking listener " + this.listener, x);
            }
            return false;
        }

        private void notifyBegin(int code, String reason) {
            try {
                this.listener.onBegin(this.request, code, reason);
            }
            catch (Throwable x) {
                StreamContentParser.logger.debug("Exception while invoking listener " + this.listener, x);
            }
        }

        private void notifyHeader(HttpField httpField) {
            try {
                this.listener.onHeader(this.request, httpField);
            }
            catch (Throwable x) {
                StreamContentParser.logger.debug("Exception while invoking listener " + this.listener, x);
            }
        }

        private void notifyHeaders(HttpFields fields) {
            if (fields != null) {
                for (HttpField field : fields) {
                    this.notifyHeader(field);
                }
            }
        }

        private void notifyHeaders() {
            try {
                this.listener.onHeaders(this.request);
            }
            catch (Throwable x) {
                StreamContentParser.logger.debug("Exception while invoking listener " + this.listener, x);
            }
        }

        public boolean headerComplete() {
            if (!this.seenResponseCode) {
                this.notifyBegin(200, "OK");
                this.notifyHeaders(this.fields);
            }
            this.notifyHeaders();
            return true;
        }

        public boolean content(ByteBuffer buffer) {
            this.notifyContent(buffer);
            return false;
        }

        private boolean notifyContent(ByteBuffer buffer) {
            try {
                return this.listener.onContent(this.request, FCGI.StreamType.STD_OUT, buffer);
            }
            catch (Throwable x) {
                StreamContentParser.logger.debug("Exception while invoking listener " + this.listener, x);
                return false;
            }
        }

        public boolean messageComplete() {
            return true;
        }

        public void earlyEOF() {
        }

        public void badMessage(int status, String reason) {
        }
    }
}

