/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.embedded;

import com.acme.MockDataSource;
import com.acme.MockUserTransaction;
import javax.transaction.UserTransaction;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.Resource;
import org.eclipse.jetty.plus.jndi.Transaction;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;

public class ServerWithAnnotations {
    public static final void main(String[] args) throws Exception {
        Server server = new Server(8080);
        Configuration.ClassList classlist = Configuration.ClassList.setServerDefault((Server)server);
        classlist.addAfter("org.eclipse.jetty.webapp.FragmentConfiguration", new String[]{"org.eclipse.jetty.plus.webapp.EnvConfiguration", "org.eclipse.jetty.plus.webapp.PlusConfiguration"});
        classlist.addBefore("org.eclipse.jetty.webapp.JettyWebXmlConfiguration", new String[]{"org.eclipse.jetty.annotations.AnnotationConfiguration"});
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        webapp.setWar("../../jetty-distribution/target/distribution/demo-base/webapps/test-spec.war");
        webapp.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/javax.servlet-[^/]*\\.jar$|.*/servlet-api-[^/]*\\.jar$");
        server.setHandler((Handler)webapp);
        Transaction transactionMgr = new Transaction((UserTransaction)new MockUserTransaction());
        EnvEntry maxAmount = new EnvEntry((Object)webapp, "maxAmount", (Object)new Double(100.0), true);
        Resource mydatasource = new Resource((Object)webapp, "jdbc/mydatasource", (Object)new MockDataSource());
        HashLoginService loginService = new HashLoginService();
        loginService.setName("Test Realm");
        loginService.setConfig("src/test/resources/realm.properties");
        server.addBean((Object)loginService);
        server.start();
        server.join();
    }
}

