/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.embedded;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AsyncEchoServlet
extends HttpServlet {
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout(0L);
        Echoer echoer = new Echoer(asyncContext);
        request.getInputStream().setReadListener((ReadListener)echoer);
        response.getOutputStream().setWriteListener((WriteListener)echoer);
    }

    private class Echoer
    implements ReadListener,
    WriteListener {
        private final byte[] buffer = new byte[4096];
        private final AsyncContext asyncContext;
        private final ServletInputStream input;
        private final ServletOutputStream output;
        private final AtomicBoolean complete = new AtomicBoolean(false);

        private Echoer(AsyncContext asyncContext) throws IOException {
            this.asyncContext = asyncContext;
            this.input = asyncContext.getRequest().getInputStream();
            this.output = asyncContext.getResponse().getOutputStream();
        }

        public void onDataAvailable() throws IOException {
            this.onWritePossible();
        }

        public void onAllDataRead() throws IOException {
            this.onWritePossible();
        }

        public void onWritePossible() throws IOException {
            while (this.output.isReady() && this.input.isReady()) {
                int read = this.input.read(this.buffer);
                if (read < 0) {
                    if (!this.complete.compareAndSet(false, true)) break;
                    this.asyncContext.complete();
                    break;
                }
                if (read <= 0) continue;
                this.output.write(this.buffer, 0, read);
            }
        }

        public void onError(Throwable failure) {
            failure.printStackTrace();
            this.asyncContext.complete();
        }
    }
}

