/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.embedded;

import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.WebSocketConfiguration;

public class WebSocketJsrServer {
    public static void main(String[] args) throws Exception {
        Server server = new Server(8080);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        server.setHandler((Handler)context);
        ServerContainer wsContainer = WebSocketConfiguration.configureContext((ServletContextHandler)context);
        wsContainer.addEndpoint(EchoJsrSocket.class);
        server.start();
        context.dumpStdErr();
        server.join();
    }

    @ServerEndpoint(value="/echo")
    public static class EchoJsrSocket {
        @OnMessage
        public void onMessage(Session session, String message) {
            session.getAsyncRemote().sendText(message);
        }
    }
}

