/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.server;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.compression.Compression;
import org.eclipse.jetty.compression.EncoderSink;
import org.eclipse.jetty.compression.server.CompressionConfig;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionResponse
extends Response.Wrapper
implements Callback,
Invocable {
    private static final Logger LOG = LoggerFactory.getLogger(CompressionResponse.class);
    private final Callback callback;
    private final CompressionConfig config;
    private final Compression compression;
    private EncoderSink encoderSink;
    private AtomicReference<State> state = new AtomicReference<State>(State.MIGHT_COMPRESS);
    private boolean last;

    public CompressionResponse(Compression compression, Request request, Response wrapped, Callback callback, CompressionConfig config) {
        super(request, wrapped);
        this.callback = callback;
        this.config = config;
        this.compression = compression;
    }

    public void failed(Throwable x) {
        this.callback.failed(x);
    }

    public Invocable.InvocationType getInvocationType() {
        return this.callback.getInvocationType();
    }

    public void succeeded() {
        if (this.last) {
            this.callback.succeeded();
        } else {
            this.write(true, null, this.callback);
        }
    }

    public void write(boolean last, ByteBuffer content, Callback callback) {
        switch (this.state.get().ordinal()) {
            case 0: {
                boolean compressing = false;
                HttpField contentTypeField = this.getHeaders().getField(HttpHeader.CONTENT_TYPE);
                if (contentTypeField == null) {
                    compressing = this.state.compareAndSet(State.MIGHT_COMPRESS, State.COMPRESSING);
                } else {
                    String mimeType = MimeTypes.getContentTypeWithoutCharset((String)contentTypeField.getValue());
                    if (this.config.isCompressMimeTypeSupported(mimeType)) {
                        compressing = this.state.compareAndSet(State.MIGHT_COMPRESS, State.COMPRESSING);
                    } else {
                        this.state.compareAndSet(State.MIGHT_COMPRESS, State.NOT_COMPRESSING);
                    }
                }
                if (compressing) {
                    this.encoderSink = this.compression.newEncoderSink((Content.Sink)this.getWrapped());
                    this.getHeaders().put(this.compression.getContentEncodingField());
                }
                this.write(last, content, callback);
                break;
            }
            case 2: {
                this.encoderSink.write(last, content, callback);
                if (!last) break;
                this.last = true;
                break;
            }
            case 1: {
                super.write(last, content, callback);
            }
        }
    }

    static enum State {
        MIGHT_COMPRESS,
        NOT_COMPRESSING,
        COMPRESSING;

    }
}

