/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.jetty.compression.Compression;
import org.eclipse.jetty.compression.server.CompressionConfig;
import org.eclipse.jetty.compression.server.CompressionResponse;
import org.eclipse.jetty.compression.server.DecompressionRequest;
import org.eclipse.jetty.http.EtagUtils;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.Container;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionHandler
extends Handler.Wrapper {
    public static final String HANDLER_ETAGS = CompressionHandler.class.getPackageName() + ".ETag";
    private static final Logger LOG = LoggerFactory.getLogger(CompressionHandler.class);
    private final Map<String, Compression> supportedEncodings = new HashMap<String, Compression>();
    private final PathMappings<CompressionConfig> pathConfigs = new PathMappings();

    public CompressionHandler() {
        this.addBean(this.pathConfigs);
    }

    public void addCompression(Compression compression) {
        if (this.isRunning()) {
            throw new IllegalStateException("Unable to add Compression on running DynamicCompressionHandler");
        }
        this.supportedEncodings.put(compression.getEncodingName(), compression);
        compression.setContainer((Container)this);
        this.addBean(compression);
    }

    public CompressionConfig ensureConfiguration(PathSpec pathSpec) {
        return (CompressionConfig)((Object)this.pathConfigs.computeIfAbsent((Object)pathSpec, spec -> CompressionConfig.builder().build()));
    }

    public CompressionConfig ensureConfiguration(String pathSpecString) {
        PathSpec pathSpec = PathSpec.from((String)pathSpecString);
        return this.ensureConfiguration(pathSpec);
    }

    public CompressionConfig getConfiguration(PathSpec pathSpec) {
        return (CompressionConfig)((Object)this.pathConfigs.get(pathSpec));
    }

    public CompressionConfig getConfiguration(String pathSpecString) {
        PathSpec pathSpec = PathSpec.from((String)pathSpecString);
        return this.getConfiguration(pathSpec);
    }

    public CompressionConfig putConfiguration(PathSpec pathSpec, CompressionConfig config) {
        return (CompressionConfig)((Object)this.pathConfigs.put(pathSpec, (Object)config));
    }

    public CompressionConfig putConfiguration(String pathSpecString, CompressionConfig config) {
        PathSpec pathSpec = PathSpec.from((String)pathSpecString);
        return this.putConfiguration(pathSpec, config);
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        Handler next;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} handle {}", (Object)this, (Object)request);
        }
        if ((next = this.getHandler()) == null) {
            return false;
        }
        if (Request.as((Request)request, DecompressionRequest.class) != null) {
            return next.handle(request, response, callback);
        }
        String pathInContext = Request.getPathInContext((Request)request);
        MatchedResource matchedConfig = this.pathConfigs.getMatched(pathInContext);
        if (matchedConfig == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping Compression: Path {} has no matching compression config", (Object)pathInContext);
            }
            return next.handle(request, response, callback);
        }
        CompressionConfig config = (CompressionConfig)((Object)matchedConfig.getResource());
        String requestContentEncoding = null;
        ArrayList<String> requestAcceptEncoding = null;
        boolean etagMatches = false;
        HttpFields fields = request.getHeaders();
        ListIterator i = fields.listIterator(fields.size());
        block5: while (i.hasPrevious()) {
            HttpField field = (HttpField)i.previous();
            HttpHeader header = field.getHeader();
            if (header == null) continue;
            switch (header) {
                case CONTENT_ENCODING: {
                    String contentEncoding = field.getValue();
                    if (!this.supportedEncodings.containsKey(contentEncoding)) continue block5;
                    requestContentEncoding = contentEncoding;
                    break;
                }
                case ACCEPT_ENCODING: {
                    List values = field.getValueList();
                    if (values == null) continue block5;
                    for (String value : values) {
                        String lvalue = StringUtil.asciiToLowerCase((String)value);
                        if (!this.supportedEncodings.containsKey(lvalue)) continue;
                        if (requestAcceptEncoding == null) {
                            requestAcceptEncoding = new ArrayList<String>();
                        }
                        requestAcceptEncoding.add(lvalue);
                    }
                    continue block5;
                }
                case IF_MATCH: 
                case IF_NONE_MATCH: {
                    etagMatches |= field.getValue().contains(EtagUtils.ETAG_SEPARATOR);
                }
            }
        }
        String decompressEncoding = config.getDecompressionEncoding(requestContentEncoding, request, pathInContext);
        String compressEncoding = config.getCompressionEncoding(requestAcceptEncoding, request, pathInContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request[{}] Content-Encoding={}, Accept-Encoding={}, decompressEncoding={}, compressEncoding={}", new Object[]{request, requestContentEncoding, requestAcceptEncoding, decompressEncoding, compressEncoding});
        }
        if (decompressEncoding == null && compressEncoding == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping Compression and Decompression: no request encoding matches");
            }
            return next.handle(request, response, callback);
        }
        Request decompressionRequest = request;
        Response compressionResponse = response;
        Callback compressionCallback = callback;
        if (decompressEncoding != null || etagMatches) {
            decompressionRequest = this.newDecompressionRequest(request, decompressEncoding, config);
        }
        if (compressEncoding != null) {
            Response compression;
            if (config.getVary() != null) {
                response.getHeaders().ensureField(config.getVary());
            }
            compressionResponse = compression = this.newCompressionResponse(this, request, response, callback, compressEncoding, config);
            if (compression instanceof Callback) {
                Callback dynamicCallback;
                compressionCallback = dynamicCallback = (Callback)compression;
            }
        }
        if (next.handle(decompressionRequest, compressionResponse, compressionCallback)) {
            return true;
        }
        if (request instanceof DecompressionRequest) {
            DecompressionRequest decompressRequest = (DecompressionRequest)request;
            decompressRequest.destroy();
        }
        return false;
    }

    public String toString() {
        return String.format("%s@%x{%s,supported=%s}", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.getState(), String.join((CharSequence)",", this.supportedEncodings.keySet()));
    }

    protected void doStart() throws Exception {
        if (this.pathConfigs.isEmpty()) {
            this.pathConfigs.put("/", (Object)CompressionConfig.builder().from(MimeTypes.DEFAULTS).build());
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.supportedEncodings.values().forEach(codec -> this.removeBean(codec));
    }

    private Compression getCompression(String encoding) {
        Compression compression = this.supportedEncodings.get(encoding);
        if (compression == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No Compression found for encoding type {}", (Object)encoding);
            }
            return null;
        }
        return compression;
    }

    private Response newCompressionResponse(CompressionHandler compressionHandler, Request request, Response response, Callback callback, String compressEncoding, CompressionConfig config) {
        Compression compression = this.getCompression(compressEncoding);
        if (compression == null) {
            return response;
        }
        return new CompressionResponse(compression, request, response, callback, config);
    }

    private Request newDecompressionRequest(Request request, String decompressEncoding, CompressionConfig config) {
        Compression compression = this.getCompression(decompressEncoding);
        if (compression == null) {
            return request;
        }
        return new DecompressionRequest(compression, request, config);
    }
}

