/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.lang.reflect.Method;
import org.eclipse.jetty.util.log.Logger;

public class LoggerLog
implements Logger {
    boolean _debug;
    Object _logger;
    Method _debugMT;
    Method _debugMAA;
    Method _infoMAA;
    Method _warnMT;
    Method _warnMAA;
    Method _isDebugEnabled;
    Method _setDebugEnabledE;
    Method _getLoggerN;

    public LoggerLog(Object logger) {
        try {
            this._logger = logger;
            Class<?> lc = logger.getClass();
            this._debugMT = lc.getMethod("debug", String.class, Throwable.class);
            this._debugMAA = lc.getMethod("debug", String.class, Object.class, Object.class);
            this._infoMAA = lc.getMethod("info", String.class, Object.class, Object.class);
            this._warnMT = lc.getMethod("warn", String.class, Throwable.class);
            this._warnMAA = lc.getMethod("warn", String.class, Object.class, Object.class);
            this._isDebugEnabled = lc.getMethod("isDebugEnabled", new Class[0]);
            this._setDebugEnabledE = lc.getMethod("setDebugEnabled", Boolean.TYPE);
            this._getLoggerN = lc.getMethod("getLogger", String.class);
            this._debug = (Boolean)this._isDebugEnabled.invoke(this._logger, (Object[])null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public void debug(String msg, Throwable th) {
        if (this._debug) {
            try {
                this._debugMT.invoke(this._logger, msg, th);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void debug(String msg) {
        if (this._debug) {
            try {
                this._debugMAA.invoke(this._logger, msg, null, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void debug(String msg, Object arg0, Object arg1) {
        if (this._debug) {
            try {
                this._debugMAA.invoke(this._logger, msg, arg0, arg1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Logger getLogger(String name) {
        try {
            Object logger = this._getLoggerN.invoke(this._logger, name);
            return new LoggerLog(logger);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this;
        }
    }

    public void info(String msg) {
        try {
            this._infoMAA.invoke(this._logger, msg, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void info(String msg, Object arg0, Object arg1) {
        try {
            this._infoMAA.invoke(this._logger, msg, arg0, arg1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isDebugEnabled() {
        return this._debug;
    }

    public void setDebugEnabled(boolean enabled) {
        try {
            this._setDebugEnabledE.invoke(this._logger, enabled);
            this._debug = enabled;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void warn(String msg) {
        try {
            this._warnMAA.invoke(this._logger, msg, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void warn(String msg, Object arg0, Object arg1) {
        try {
            this._warnMAA.invoke(this._logger, msg, arg0, arg1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void warn(String msg, Throwable th) {
        try {
            this._warnMT.invoke(this._logger, msg, th);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

