/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.cert.X509Certificate;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.security.Password;
import org.eclipse.jetty.http.ssl.SslSelectChannelEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ThreadLocalBuffers;
import org.eclipse.jetty.io.nio.DirectNIOBuffer;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.ServletSSL;
import org.eclipse.jetty.server.ssl.SslConnector;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;

public class SslSelectChannelConnector
extends SelectChannelConnector
implements SslConnector {
    static final String CACHED_INFO_ATTR = CachedInfo.class.getName();
    private String[] _excludeCipherSuites = null;
    private String _keystorePath = DEFAULT_KEYSTORE;
    private String _keystoreType = "JKS";
    private boolean _needClientAuth = false;
    private boolean _wantClientAuth = false;
    private transient Password _password;
    private transient Password _keyPassword;
    private transient Password _trustPassword;
    private String _protocol = "TLS";
    private String _provider;
    private String _secureRandomAlgorithm;
    private String _sslKeyManagerFactoryAlgorithm = "SunX509";
    private String _sslTrustManagerFactoryAlgorithm = "SunX509";
    private String _truststorePath;
    private String _truststoreType = "JKS";
    private SSLContext _context;
    Buffers _sslBuffers;

    private static java.security.cert.X509Certificate[] getCertChain(SSLSession sslSession) {
        try {
            X509Certificate[] javaxCerts = sslSession.getPeerCertificateChain();
            if (javaxCerts == null || javaxCerts.length == 0) {
                return null;
            }
            int length = javaxCerts.length;
            java.security.cert.X509Certificate[] javaCerts = new java.security.cert.X509Certificate[length];
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < length; ++i) {
                byte[] bytes = javaxCerts[i].getEncoded();
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                javaCerts[i] = (java.security.cert.X509Certificate)cf.generateCertificate(stream);
            }
            return javaCerts;
        }
        catch (SSLPeerUnverifiedException pue) {
            return null;
        }
        catch (Exception e) {
            Log.warn("EXCEPTION ", e);
            return null;
        }
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        request.setScheme("https");
        SslSelectChannelEndPoint sslHttpChannelEndpoint = (SslSelectChannelEndPoint)endpoint;
        SSLEngine sslEngine = sslHttpChannelEndpoint.getSSLEngine();
        try {
            String idStr;
            java.security.cert.X509Certificate[] certs;
            Integer keySize;
            SSLSession sslSession = sslEngine.getSession();
            String cipherSuite = sslSession.getCipherSuite();
            CachedInfo cachedInfo = (CachedInfo)sslSession.getValue(CACHED_INFO_ATTR);
            if (cachedInfo != null) {
                keySize = cachedInfo.getKeySize();
                certs = cachedInfo.getCerts();
                idStr = cachedInfo.getIdStr();
            } else {
                keySize = new Integer(ServletSSL.deduceKeyLength(cipherSuite));
                certs = SslSelectChannelConnector.getCertChain(sslSession);
                byte[] bytes = sslSession.getId();
                idStr = TypeUtil.toHexString(bytes);
                cachedInfo = new CachedInfo(keySize, certs, idStr);
                sslSession.putValue(CACHED_INFO_ATTR, cachedInfo);
            }
            if (certs != null) {
                request.setAttribute("javax.servlet.request.X509Certificate", certs);
            }
            request.setAttribute("javax.servlet.request.cipher_suite", cipherSuite);
            request.setAttribute("javax.servlet.request.key_size", keySize);
            request.setAttribute("javax.servlet.request.ssl_session_id", idStr);
        }
        catch (Exception e) {
            Log.warn("EXCEPTION ", e);
        }
    }

    public String[] getExcludeCipherSuites() {
        return this._excludeCipherSuites;
    }

    public void setExcludeCipherSuites(String[] cipherSuites) {
        this._excludeCipherSuites = cipherSuites;
    }

    public void setPassword(String password) {
        this._password = Password.getPassword("org.eclipse.jetty.jetty.ssl.password", password, null);
    }

    public void setTrustPassword(String password) {
        this._trustPassword = Password.getPassword("org.eclipse.jetty.jetty.ssl.password", password, null);
    }

    public void setKeyPassword(String password) {
        this._keyPassword = Password.getPassword("org.eclipse.jetty.ssl.keypassword", password, null);
    }

    public String getAlgorithm() {
        return this.getSslKeyManagerFactoryAlgorithm();
    }

    public void setAlgorithm(String algorithm) {
        this.setSslKeyManagerFactoryAlgorithm(algorithm);
        this.setSslTrustManagerFactoryAlgorithm(algorithm);
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setKeystore(String keystore) {
        this._keystorePath = keystore;
    }

    public String getKeystore() {
        return this._keystorePath;
    }

    public String getKeystoreType() {
        return this._keystoreType;
    }

    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this._needClientAuth = needClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this._wantClientAuth = wantClientAuth;
    }

    public void setKeystoreType(String keystoreType) {
        this._keystoreType = keystoreType;
    }

    public String getProvider() {
        return this._provider;
    }

    public String getSecureRandomAlgorithm() {
        return this._secureRandomAlgorithm;
    }

    public String getSslKeyManagerFactoryAlgorithm() {
        return this._sslKeyManagerFactoryAlgorithm;
    }

    public String getSslTrustManagerFactoryAlgorithm() {
        return this._sslTrustManagerFactoryAlgorithm;
    }

    public String getTruststore() {
        return this._truststorePath;
    }

    public String getTruststoreType() {
        return this._truststoreType;
    }

    public void setProvider(String provider) {
        this._provider = provider;
    }

    public void setSecureRandomAlgorithm(String algorithm) {
        this._secureRandomAlgorithm = algorithm;
    }

    public void setSslKeyManagerFactoryAlgorithm(String algorithm) {
        this._sslKeyManagerFactoryAlgorithm = algorithm;
    }

    public void setSslTrustManagerFactoryAlgorithm(String algorithm) {
        this._sslTrustManagerFactoryAlgorithm = algorithm;
    }

    public void setTruststore(String truststore) {
        this._truststorePath = truststore;
    }

    public void setTruststoreType(String truststoreType) {
        this._truststoreType = truststoreType;
    }

    public void setSslContext(SSLContext sslContext) {
        this._context = sslContext;
    }

    public SSLContext getSslContext() {
        try {
            if (this._context == null) {
                this._context = this.createSSLContext();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this._context;
    }

    public boolean isConfidential(Request request) {
        int confidentialPort = this.getConfidentialPort();
        return confidentialPort == 0 || confidentialPort == request.getServerPort();
    }

    public boolean isIntegral(Request request) {
        int integralPort = this.getIntegralPort();
        return integralPort == 0 || integralPort == request.getServerPort();
    }

    protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
        return new SslSelectChannelEndPoint(this._sslBuffers, channel, selectSet, key, this.createSSLEngine());
    }

    protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
        HttpConnection connection = (HttpConnection)super.newConnection(channel, endpoint);
        ((HttpParser)connection.getParser()).setForceContentBuffer(true);
        return connection;
    }

    protected SSLEngine createSSLEngine() throws IOException {
        SSLEngine engine = null;
        try {
            engine = this._context.createSSLEngine();
            engine.setUseClientMode(false);
            if (this._wantClientAuth) {
                engine.setWantClientAuth(this._wantClientAuth);
            }
            if (this._needClientAuth) {
                engine.setNeedClientAuth(this._needClientAuth);
            }
            if (this._excludeCipherSuites != null && this._excludeCipherSuites.length > 0) {
                List<String> excludedCSList = Arrays.asList(this._excludeCipherSuites);
                String[] enabledCipherSuites = engine.getEnabledCipherSuites();
                ArrayList<String> enabledCSList = new ArrayList<String>(Arrays.asList(enabledCipherSuites));
                for (String cipherName : excludedCSList) {
                    if (!enabledCSList.contains(cipherName)) continue;
                    enabledCSList.remove(cipherName);
                }
                enabledCipherSuites = enabledCSList.toArray(new String[enabledCSList.size()]);
                engine.setEnabledCipherSuites(enabledCipherSuites);
            }
        }
        catch (Exception e) {
            Log.warn("Error creating sslEngine -- closing this connector", e);
            this.close();
            throw new IllegalStateException(e);
        }
        return engine;
    }

    protected void doStart() throws Exception {
        if (this._context == null) {
            this._context = this.createSSLContext();
        }
        SSLEngine engine = this.createSSLEngine();
        SSLSession ssl_session = engine.getSession();
        ThreadLocalBuffers buffers = new ThreadLocalBuffers(){

            protected Buffer newBuffer(int size) {
                return new DirectNIOBuffer(size);
            }

            protected Buffer newHeader(int size) {
                return new DirectNIOBuffer(size);
            }

            protected boolean isHeader(Buffer buffer) {
                return true;
            }
        };
        buffers.setBufferSize(ssl_session.getApplicationBufferSize());
        buffers.setHeaderSize(ssl_session.getPacketBufferSize());
        this._sslBuffers = buffers;
        if (this.getRequestHeaderSize() < ssl_session.getApplicationBufferSize()) {
            this.setRequestHeaderSize(ssl_session.getApplicationBufferSize());
        }
        if (this.getRequestBufferSize() < ssl_session.getApplicationBufferSize()) {
            this.setRequestBufferSize(ssl_session.getApplicationBufferSize());
        }
        super.doStart();
    }

    protected SSLContext createSSLContext() throws Exception {
        KeyManager[] keyManagers = this.getKeyManagers();
        TrustManager[] trustManagers = this.getTrustManagers();
        SecureRandom secureRandom = this._secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this._secureRandomAlgorithm);
        SSLContext context = this._provider == null ? SSLContext.getInstance(this._protocol) : SSLContext.getInstance(this._protocol, this._provider);
        context.init(keyManagers, trustManagers, secureRandom);
        return context;
    }

    protected KeyManager[] getKeyManagers() throws Exception {
        KeyStore keyStore = this.getKeyStore(this._keystorePath, this._keystoreType, this._password.toString());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this._sslKeyManagerFactoryAlgorithm);
        keyManagerFactory.init(keyStore, this._keyPassword == null ? (this._password == null ? null : this._password.toString().toCharArray()) : this._keyPassword.toString().toCharArray());
        return keyManagerFactory.getKeyManagers();
    }

    protected TrustManager[] getTrustManagers() throws Exception {
        if (this._truststorePath == null) {
            this._truststorePath = this._keystorePath;
            this._truststoreType = this._keystoreType;
            this._trustPassword = this._password;
            this._sslTrustManagerFactoryAlgorithm = this._sslKeyManagerFactoryAlgorithm;
        }
        KeyStore trustStore = this.getKeyStore(this._truststorePath, this._truststoreType, this._trustPassword.toString());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._sslTrustManagerFactoryAlgorithm);
        trustManagerFactory.init(trustStore);
        return trustManagerFactory.getTrustManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore getKeyStore(String keystorePath, String keystoreType, String keystorePassword) throws Exception {
        KeyStore keyStore;
        block3: {
            InputStream keystoreInputStream = null;
            try {
                if (keystorePath != null) {
                    keystoreInputStream = Resource.newResource(keystorePath).getInputStream();
                }
                KeyStore keystore = KeyStore.getInstance(keystoreType);
                keystore.load(keystoreInputStream, keystorePassword == null ? null : keystorePassword.toString().toCharArray());
                keyStore = keystore;
                Object var8_7 = null;
                if (keystoreInputStream == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var8_8 = null;
                    if (keystoreInputStream == null) break block4;
                    keystoreInputStream.close();
                }
                throw throwable;
            }
            keystoreInputStream.close();
        }
        return keyStore;
    }

    private class CachedInfo {
        private final java.security.cert.X509Certificate[] _certs;
        private final Integer _keySize;
        private final String _idStr;

        CachedInfo(Integer keySize, java.security.cert.X509Certificate[] certs, String idStr) {
            this._keySize = keySize;
            this._certs = certs;
            this._idStr = idStr;
        }

        java.security.cert.X509Certificate[] getCerts() {
            return this._certs;
        }

        Integer getKeySize() {
            return this._keySize;
        }

        String getIdStr() {
            return this._idStr;
        }
    }
}

