/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.example;

import io.vertx.core.Future;
import io.vertx.proton.ProtonClientOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.eclipse.hono.client.MessageSender;
import org.eclipse.hono.example.AbstractExampleClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"sender"})
public class ExampleSender
extends AbstractExampleClient {
    @Value(value="${device.id}")
    private String deviceId;

    @PostConstruct
    private void start() {
        this.LOG.info("starting sender");
        this.ctx = this.vertx.getOrCreateContext();
        Future startupTracker = Future.future();
        startupTracker.setHandler(done -> {
            if (done.succeeded()) {
                this.vertx.executeBlocking(f -> this.readMessagesFromStdin((MessageSender)done.result(), f), false, exit -> this.vertx.close());
            } else {
                this.LOG.error("Error occurred during initialization: {}", (Object)done.cause().getMessage());
                this.vertx.close();
            }
        });
        this.ctx.runOnContext(go -> {
            ProtonClientOptions clientOptions = new ProtonClientOptions();
            clientOptions.setConnectTimeout(1000);
            Future connectionTracker = Future.future();
            this.client.connect(clientOptions, connectionTracker.completer());
            connectionTracker.compose(v -> {
                Future regClientTracker = Future.future();
                this.client.createRegistrationClient(this.tenantId, regClientTracker.completer());
                return regClientTracker;
            }).compose(regClient -> {
                Future regResultTracker = Future.future();
                regClient.register(this.deviceId, null, regResultTracker.completer());
                return regResultTracker;
            }).compose(regResult -> {
                Future resultCodeTracker = Future.future();
                if (regResult.getStatus() == 201) {
                    this.LOG.info("Device registered successfully.");
                    resultCodeTracker.complete();
                } else if (regResult.getStatus() == 409) {
                    this.LOG.info("Device already registered.");
                    resultCodeTracker.complete();
                } else {
                    resultCodeTracker.fail(String.format("Failed to register device [%s]: %s", this.deviceId, regResult));
                }
                return resultCodeTracker;
            }).compose(v -> {
                if (this.activeProfiles.contains("event")) {
                    this.client.getOrCreateEventSender(this.tenantId, startupTracker.completer());
                } else {
                    this.client.getOrCreateTelemetrySender(this.tenantId, startupTracker.completer());
                }
            }, startupTracker);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMessagesFromStdin(MessageSender messageSender, Future<Object> f) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String input;
            do {
                this.LOG.info("Enter some message to send (empty message to quit): ");
                input = reader.readLine();
                if (input.isEmpty()) continue;
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("my_prop_string", "I'm a string");
                properties.put("my_prop_int", 10);
                messageSender.send(this.deviceId, properties, input, "text/plain");
            } while (!input.isEmpty());
            f.complete();
        }
        catch (IOException e) {
            this.LOG.error("problem reading message from STDIN", (Throwable)e);
            f.fail((Throwable)e);
        }
        finally {
            this.client.shutdown();
        }
    }
}

