/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.Objects;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.command.Command;
import org.eclipse.hono.client.impl.CommandConsumer;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.ExecutionContext;

public interface CommandContext
extends ExecutionContext {
    public static final String KEY_COMMAND_CONTEXT = "command-context";
    public static final String KEY_TENANT_CONFIG = "tenant-config";

    public void logCommandToSpan(Span var1);

    public Command getCommand();

    public void accept();

    default public void release() {
        this.release((Throwable)new ServerErrorException(503));
    }

    public void release(Throwable var1);

    public void modify(boolean var1, boolean var2);

    default public void reject(String error) {
        this.reject((Throwable)new ClientErrorException(400, error));
    }

    public void reject(Throwable var1);

    public static Span createSpan(Tracer tracer, Command command, SpanContext parentSpanContext, SpanContext followsFromSpanContext) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(command);
        Tracer.SpanBuilder spanBuilder = TracingHelper.buildChildSpan((Tracer)tracer, (SpanContext)parentSpanContext, (String)"handle command", (String)CommandConsumer.class.getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "consumer").withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)command.getTenant()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)command.getDeviceId());
        if (command.getGatewayId() != null) {
            spanBuilder.withTag("gateway_id", command.getGatewayId());
        }
        spanBuilder.addReference("follows_from", followsFromSpanContext);
        Span currentSpan = spanBuilder.start();
        command.logToSpan(currentSpan);
        return currentSpan;
    }
}

