/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli.app;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.buffer.Buffer;
import java.time.Duration;
import java.util.Optional;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.eclipse.hono.application.client.DownstreamMessage;
import org.eclipse.hono.application.client.amqp.AmqpApplicationClient;
import org.eclipse.hono.cli.app.AbstractApplicationClient;
import org.eclipse.hono.client.ServiceInvocationException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"command"})
public class Commander
extends AbstractApplicationClient {
    private final Scanner scanner = new Scanner(System.in);
    @Value(value="${command.timeoutInSeconds}")
    private int commandTimeOutInSeconds;
    @Value(value="${device.id}")
    private String deviceId;
    private WorkerExecutor workerExecutor;

    @PostConstruct
    void start() {
        this.workerExecutor = this.vertx.createSharedWorkerExecutor("user-input-pool", 3, TimeUnit.HOURS.toNanos(1L));
        this.client.start().onSuccess(v -> {
            if (this.client instanceof AmqpApplicationClient) {
                ((AmqpApplicationClient)this.client).addReconnectListener(c -> this.startCommandClient());
            }
        }).compose(v -> this.startCommandClient()).onFailure(this::close);
    }

    private Future<Void> startCommandClient() {
        return this.getCommandFromUser().compose(this::processCommand).onComplete(sendAttempt -> this.startCommandClient());
    }

    private Future<Void> processCommand(Command command) {
        Future sendResult;
        if (command.isOneWay()) {
            System.out.println("Command sent to device.");
            sendResult = this.client.sendOneWayCommand(this.tenantId, this.deviceId, command.getName(), command.getContentType(), Buffer.buffer((String)command.getPayload()), null, null);
        } else {
            System.out.printf("Command sent to device... [waiting for response for max. %d seconds]", this.commandTimeOutInSeconds);
            System.out.println();
            sendResult = this.client.sendCommand(this.tenantId, this.deviceId, command.getName(), command.getContentType(), Buffer.buffer((String)command.getPayload()), UUID.randomUUID().toString(), null, Duration.ofSeconds(this.commandTimeOutInSeconds), null).map(this::printResponse);
        }
        return sendResult.otherwise(error -> {
            if (ServiceInvocationException.extractStatusCode((Throwable)error) == 503) {
                System.out.printf("Error sending command (error code 503). Is the device really waiting for a command? (device [%s] in tenant [%s])", this.deviceId, this.tenantId);
            } else {
                System.out.printf("Error sending command: %s", error.getMessage());
            }
            System.out.println();
            return null;
        });
    }

    private Void printResponse(DownstreamMessage<?> result) {
        System.out.printf("Received Command response: %s", Optional.ofNullable(result.getPayload()).orElseGet(Buffer::buffer));
        System.out.println();
        return null;
    }

    private Future<Command> getCommandFromUser() {
        Promise result = Promise.promise();
        this.workerExecutor.executeBlocking(userInputFuture -> {
            System.out.println();
            System.out.println();
            System.out.printf(">>>>>>>>> Enter name of command for device [%s] in tenant [%s] (prefix with 'ow:' to send one-way command):", this.deviceId, this.tenantId);
            System.out.println();
            String honoCmd = this.scanner.nextLine();
            System.out.println(">>>>>>>>> Enter command payload:");
            String honoPayload = this.scanner.nextLine();
            String suggestedContentType = honoPayload.trim().startsWith("{") && honoPayload.trim().endsWith("}") ? "application/json" : "text/plain";
            System.out.println(">>>>>>>>> Enter content type (leave empty for '" + suggestedContentType + "' default):");
            String honoContentType = this.scanner.nextLine();
            System.out.println();
            String contentTypeToUse = honoContentType.isBlank() ? suggestedContentType : honoContentType;
            userInputFuture.complete((Object)new Command(honoCmd, honoPayload, contentTypeToUse));
        }, (Handler)result);
        return result.future();
    }

    private void close(Throwable t) {
        this.workerExecutor.close();
        this.vertx.close();
        this.client.stop();
        this.log.error("Error: {}", (Object)t.getMessage());
    }

    private static class Command {
        private final String name;
        private final String payload;
        private final String contentType;
        private final boolean oneWay;

        Command(String command, String payload, String contentType) {
            this.oneWay = command.startsWith("ow:");
            this.name = this.oneWay ? command.substring(3) : command;
            this.payload = payload;
            this.contentType = contentType;
        }

        private boolean isOneWay() {
            return this.oneWay;
        }

        private String getName() {
            return this.name;
        }

        private String getPayload() {
            return this.payload;
        }

        private String getContentType() {
            return this.contentType;
        }
    }
}

