/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.buffer.Buffer;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.eclipse.hono.cli.AbstractClient;
import org.eclipse.hono.client.CommandClient;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.util.BufferResult;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"command"})
public class Commander
extends AbstractClient {
    private final Scanner scanner = new Scanner(System.in);
    @Value(value="${command.timeoutInSeconds}")
    private int requestTimeoutInSecs;
    private WorkerExecutor workerExecutor;

    @PostConstruct
    void start() {
        this.workerExecutor = this.vertx.createSharedWorkerExecutor("user-input-pool", 3, TimeUnit.HOURS.toNanos(1L));
        this.startCommandClient((Future<HonoClient>)this.client.connect(x -> this.onDisconnect()));
    }

    private void startCommandClient(Future<HonoClient> clientFuture) {
        clientFuture.setHandler(this::handleClientConnectionStatus).compose(x -> this.getCommandFromUser()).compose(this::processCommand).setHandler(x -> this.startCommandClient(clientFuture));
    }

    private Future<Void> processCommand(Command command) {
        this.LOG.info("Command sent to device... [request will timeout in {} seconds]", (Object)this.requestTimeoutInSecs);
        Future commandClient = this.client.getOrCreateCommandClient(this.tenantId, this.deviceId);
        return commandClient.map(this::setRequestTimeOut).compose(c -> {
            if (command.isOneWay()) {
                return c.sendOneWayCommand(command.getName(), command.getContentType(), Buffer.buffer((String)command.getPayload()), null).map(ok -> c);
            }
            return c.sendCommand(command.getName(), command.getContentType(), Buffer.buffer((String)command.getPayload()), null).map(this::printResponse).map(ok -> c);
        }).map(this::closeCommandClient).otherwise(error -> {
            this.LOG.error("Error sending command: {}", (Object)error.getMessage());
            if (commandClient.succeeded()) {
                return this.closeCommandClient((CommandClient)commandClient.result());
            }
            return null;
        });
    }

    private CommandClient setRequestTimeOut(CommandClient commandClient) {
        commandClient.setRequestTimeout(TimeUnit.SECONDS.toMillis(this.requestTimeoutInSecs));
        return commandClient;
    }

    private Void closeCommandClient(CommandClient commandClient) {
        this.LOG.trace("Close command client to device [{}:{}]", (Object)this.tenantId, (Object)this.deviceId);
        commandClient.close(closeHandler -> {});
        return null;
    }

    private Void printResponse(BufferResult result) {
        this.LOG.info("Received Command response : {}", (Object)Optional.ofNullable((Buffer)result.getPayload()).orElse(Buffer.buffer()).toString());
        return null;
    }

    private Future<Command> getCommandFromUser() {
        Future commandFuture = Future.future();
        this.workerExecutor.executeBlocking(userInputFuture -> {
            System.out.println();
            System.out.println();
            System.out.printf(">>>>>>>>> Enter name of command for device [%s:%s] (prefix with 'ow:' to send one-way command):", this.tenantId, this.deviceId);
            System.out.println();
            String honoCmd = this.scanner.nextLine();
            System.out.println(">>>>>>>>> Enter command payload:");
            String honoPayload = this.scanner.nextLine();
            System.out.println(">>>>>>>>> Enter content type:");
            String honoContentType = this.scanner.nextLine();
            System.out.println();
            userInputFuture.complete((Object)new Command(honoCmd, honoPayload, honoContentType));
        }, (Handler)commandFuture);
        return commandFuture;
    }

    private void onDisconnect() {
        this.LOG.info("Connecting client...");
        this.vertx.setTimer((long)this.connectionRetryInterval, reconnect -> {
            this.LOG.info("attempting to re-connect to Hono ...");
            this.client.connect(con -> this.onDisconnect());
        });
    }

    private void handleClientConnectionStatus(AsyncResult<HonoClient> result) {
        if (result.failed()) {
            this.workerExecutor.close();
            this.vertx.close();
            this.LOG.error("Error: {}", (Object)result.cause().getMessage());
            throw new RuntimeException("Error connecting hono client", result.cause());
        }
    }

    private static class Command {
        private final String name;
        private final String payload;
        private final String contentType;
        private final boolean oneWay;

        Command(String command, String payload, String contentType) {
            this.oneWay = command.startsWith("ow:");
            this.name = this.oneWay ? command.substring(3) : command;
            this.payload = payload;
            this.contentType = contentType;
        }

        private boolean isOneWay() {
            return this.oneWay;
        }

        private String getName() {
            return this.name;
        }

        private String getPayload() {
            return this.payload;
        }

        private String getContentType() {
            return this.contentType;
        }
    }
}

