/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableFloatBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableFloatEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableFloatHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableFloatSingletonBag;

public enum ImmutableFloatBagFactoryImpl implements ImmutableFloatBagFactory
{
    INSTANCE;


    public ImmutableFloatBag empty() {
        return ImmutableFloatEmptyBag.INSTANCE;
    }

    public ImmutableFloatBag of() {
        return this.empty();
    }

    public ImmutableFloatBag with() {
        return this.empty();
    }

    public ImmutableFloatBag of(float one) {
        return this.with(one);
    }

    public ImmutableFloatBag with(float one) {
        return new ImmutableFloatSingletonBag(one);
    }

    public ImmutableFloatBag of(float ... items) {
        return this.with(items);
    }

    public ImmutableFloatBag with(float ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableFloatHashBag.newBagWith(items);
    }

    public ImmutableFloatBag ofAll(FloatIterable items) {
        return this.withAll(items);
    }

    public ImmutableFloatBag withAll(FloatIterable items) {
        if (items instanceof ImmutableFloatBag) {
            return (ImmutableFloatBag)items;
        }
        return this.with(items.toArray());
    }
}

