/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectBytePredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectByteProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectByteMap;
import org.eclipse.collections.api.map.primitive.ObjectByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.tuple.primitive.ObjectBytePair;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.factory.primitive.ObjectByteMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.map.immutable.primitive.AbstractImmutableObjectByteMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectByteEmptyMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectByteHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableObjectByteSingletonMap<K>
extends AbstractImmutableObjectByteMap<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_VALUE = 0;
    private final K key1;
    private final byte value1;

    ImmutableObjectByteSingletonMap(K key1, byte value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator((ByteIterator)ObjectByteHashMap.newWithKeysValues(this.key1, this.value1).byteIterator());
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(BytePredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableByteCollection select(BytePredicate predicate) {
        return predicate.accept(this.value1) ? ByteLists.immutable.with(this.value1) : ByteLists.immutable.with();
    }

    public ImmutableByteCollection reject(BytePredicate predicate) {
        return predicate.accept(this.value1) ? ByteLists.immutable.with() : ByteLists.immutable.with(this.value1);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public long sum() {
        return this.value1;
    }

    public byte min() {
        return this.value1;
    }

    public byte max() {
        return this.value1;
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.value1;
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public byte[] toSortedArray() {
        return new byte[]{this.value1};
    }

    public MutableByteList toSortedList() {
        return ByteArrayList.newListWith(this.value1);
    }

    public byte[] toArray() {
        return new byte[]{this.value1};
    }

    public boolean contains(byte value) {
        return this.value1 == value;
    }

    public boolean containsAll(byte ... source) {
        for (byte value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableByteList toList() {
        return ByteArrayList.newListWith(this.value1);
    }

    public MutableByteSet toSet() {
        return ByteHashSet.newSetWith(this.value1);
    }

    public MutableByteBag toBag() {
        return ByteHashBag.newBagWith(this.value1);
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public ImmutableObjectByteMap<K> newWithKeyValue(K key, byte value) {
        return ObjectByteMaps.immutable.withAll(ObjectByteHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableObjectByteMap<K> newWithoutKey(K key) {
        return ImmutableObjectByteSingletonMap.nullSafeEquals(this.key1, key) ? ImmutableObjectByteEmptyMap.INSTANCE : this;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    public ImmutableObjectByteMap<K> newWithoutAllKeys(Iterable<? extends K> keys) {
        ObjectByteHashMap<K> map = new ObjectByteHashMap<K>(this);
        for (K key : keys) {
            map.removeKey(key);
        }
        return map.toImmutable();
    }

    public byte get(Object key) {
        return this.getIfAbsent(key, (byte)0);
    }

    public byte getOrThrow(Object key) {
        if (ImmutableObjectByteSingletonMap.nullSafeEquals(this.key1, key)) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public byte getIfAbsent(Object key, byte ifAbsent) {
        return ImmutableObjectByteSingletonMap.nullSafeEquals(this.key1, key) ? this.value1 : ifAbsent;
    }

    public boolean containsKey(Object key) {
        return ImmutableObjectByteSingletonMap.nullSafeEquals(this.key1, key);
    }

    public boolean containsValue(byte value) {
        return this.value1 == value;
    }

    public void forEachValue(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ObjectByteProcedure<? super K> objectByteProcedure) {
        objectByteProcedure.value(this.key1, this.value1);
    }

    public ImmutableObjectByteMap<K> select(ObjectBytePredicate<? super K> objectBytePredicate) {
        return objectBytePredicate.accept(this.key1, this.value1) ? ObjectByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : ImmutableObjectByteEmptyMap.INSTANCE;
    }

    public ImmutableObjectByteMap<K> reject(ObjectBytePredicate<? super K> objectBytePredicate) {
        return objectBytePredicate.accept(this.key1, this.value1) ? ImmutableObjectByteEmptyMap.INSTANCE : ObjectByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableObjectByteMap<K> toImmutable() {
        return this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public Set<K> keySet() {
        return Sets.immutable.of(this.key1).castToSet();
    }

    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of((MutableByteCollection)ByteArrayList.newListWith(this.value1));
    }

    public LazyIterable<K> keysView() {
        return Lists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<ObjectBytePair<K>> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectByteMap)) {
            return false;
        }
        ObjectByteMap map = (ObjectByteMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return (this.key1 == null ? 0 : this.key1.hashCode()) ^ this.value1;
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object writeReplace() {
        return new AbstractImmutableObjectByteMap.ImmutableObjectByteMapSerializationProxy(this);
    }
}

