/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.io.Serializable;
import java.util.Iterator;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyBooleanIterable;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.BooleanHashSet;

@Immutable
public class CollectBooleanIterable<T>
extends AbstractLazyBooleanIterable {
    private final LazyIterable<T> iterable;
    private final BooleanFunction<? super T> function;
    private final BooleanFunctionToProcedure<T> booleanFunctionToProcedure;

    public CollectBooleanIterable(LazyIterable<T> adapted, BooleanFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.booleanFunctionToProcedure = new BooleanFunctionToProcedure(function);
    }

    public BooleanIterator booleanIterator() {
        return new BooleanIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectBooleanIterable.this.iterable.iterator();
            }

            public boolean next() {
                return CollectBooleanIterable.this.function.booleanValueOf(this.iterator.next());
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    public void each(BooleanProcedure procedure) {
        this.iterable.forEachWith(this.booleanFunctionToProcedure, (Object)procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(BooleanPredicate predicate) {
        return this.iterable.count((Predicate & Serializable)each -> predicate.accept(this.function.booleanValueOf(each)));
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.iterable.anySatisfy((Predicate & Serializable)each -> predicate.accept(this.function.booleanValueOf(each)));
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.iterable.allSatisfy((Predicate & Serializable)each -> predicate.accept(this.function.booleanValueOf(each)));
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.iterable.allSatisfy((Predicate & Serializable)each -> !predicate.accept(this.function.booleanValueOf(each)));
    }

    @Override
    public boolean[] toArray() {
        boolean[] array = new boolean[this.size()];
        this.iterable.forEachWithIndex((ObjectIntProcedure & Serializable)(each, index) -> {
            array[index] = this.function.booleanValueOf(each);
        });
        return array;
    }

    @Override
    public MutableBooleanList toList() {
        return BooleanArrayList.newList((BooleanIterable)this);
    }

    @Override
    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSet((BooleanIterable)this);
    }

    @Override
    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBag((BooleanIterable)this);
    }

    @Override
    public boolean containsAll(boolean ... source) {
        for (boolean value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator = source.booleanIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private static final class BooleanFunctionToProcedure<T>
    implements Procedure2<T, BooleanProcedure> {
        private static final long serialVersionUID = 1L;
        private final BooleanFunction<? super T> function;

        private BooleanFunctionToProcedure(BooleanFunction<? super T> function) {
            this.function = function;
        }

        public void value(T each, BooleanProcedure procedure) {
            procedure.value(this.function.booleanValueOf(each));
        }
    }
}

