/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ByteBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.tuple.primitive.ByteIntPair;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableByteSingletonBag;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ByteBags;
import org.eclipse.collections.impl.iterator.ImmutableEmptyByteIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;

@Immutable
final class ImmutableByteEmptyBag
implements ImmutableByteBag,
Serializable {
    static final ImmutableByteBag INSTANCE = new ImmutableByteEmptyBag();
    private static final long serialVersionUID = 1L;

    ImmutableByteEmptyBag() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public ImmutableByteBag newWith(byte element) {
        return new ImmutableByteSingletonBag(element);
    }

    public ImmutableByteBag newWithout(byte element) {
        return this;
    }

    public ImmutableByteBag newWithAll(ByteIterable elements) {
        return ByteBags.immutable.withAll(elements);
    }

    public ImmutableByteBag newWithoutAll(ByteIterable elements) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public boolean contains(byte value) {
        return false;
    }

    public boolean containsAll(ByteIterable source) {
        return source.isEmpty();
    }

    public boolean containsAll(byte ... elements) {
        return elements.length == 0;
    }

    public void forEach(ByteProcedure procedure) {
    }

    public void each(ByteProcedure procedure) {
    }

    public ImmutableByteBag select(BytePredicate predicate) {
        return this;
    }

    public ImmutableByteBag reject(BytePredicate predicate) {
        return this;
    }

    public <V> ImmutableBag<V> collect(ByteToObjectFunction<? extends V> function) {
        return Bags.immutable.of();
    }

    public MutableByteList toList() {
        return new ByteArrayList();
    }

    public int sizeDistinct() {
        return 0;
    }

    public int occurrencesOf(byte item) {
        return 0;
    }

    public void forEachWithOccurrences(ByteIntProcedure byteIntProcedure) {
    }

    public ImmutableByteBag selectByOccurrences(IntPredicate predicate) {
        return this;
    }

    public ImmutableList<ByteIntPair> topOccurrences(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Cannot use a value of count < 0");
        }
        return Lists.immutable.empty();
    }

    public ImmutableList<ByteIntPair> bottomOccurrences(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Cannot use a value of count < 0");
        }
        return Lists.immutable.empty();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return ifNone;
    }

    public int count(BytePredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return false;
    }

    public long sum() {
        return 0L;
    }

    public byte min() {
        throw new NoSuchElementException();
    }

    public byte max() {
        throw new NoSuchElementException();
    }

    public byte maxIfEmpty(byte defaultValue) {
        return defaultValue;
    }

    public byte minIfEmpty(byte defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public byte[] toSortedArray() {
        return new byte[0];
    }

    public MutableByteList toSortedList() {
        return new ByteArrayList();
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return true;
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ByteBag)) {
            return false;
        }
        ByteBag bag = (ByteBag)obj;
        return bag.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public MutableByteSet toSet() {
        return new ByteHashSet();
    }

    public MutableByteBag toBag() {
        return new ByteHashBag();
    }

    public ImmutableByteBag toImmutable() {
        return this;
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public byte[] toArray() {
        return new byte[0];
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteIterator byteIterator() {
        return ImmutableEmptyByteIterator.INSTANCE;
    }
}

