/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.strategy.immutable;

import java.util.Map;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.tuple.AbstractImmutableEntry;

public final class ImmutableEntryWithHashingStrategy<K, V>
extends AbstractImmutableEntry<K, V> {
    private static final long serialVersionUID = 1L;
    private final HashingStrategy<? super K> hashingStrategy;

    public ImmutableEntryWithHashingStrategy(K key, V value, HashingStrategy<? super K> hashingStrategy) {
        super(key, value);
        this.hashingStrategy = hashingStrategy;
    }

    public static <T1, T2> ImmutableEntryWithHashingStrategy<T1, T2> of(T1 key, T2 value, HashingStrategy<? super T1> hashingStrategy) {
        return new ImmutableEntryWithHashingStrategy<T1, T2>(key, value, hashingStrategy);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry that = (Map.Entry)object;
            return this.hashingStrategy.equals(this.key, that.getKey()) && Comparators.nullSafeEquals(this.value, that.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        Object key = this.key;
        Object value = this.value;
        return this.hashingStrategy.computeHashCode(key) ^ (value == null ? 0 : value.hashCode());
    }
}

