/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction0;
import org.eclipse.collections.api.block.function.primitive.DoubleToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectDoublePredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectDoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.iterator.MutableDoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.tuple.primitive.ObjectDoublePair;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedDoubleCollection;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import org.eclipse.collections.impl.factory.primitive.DoubleLists;
import org.eclipse.collections.impl.factory.primitive.ObjectDoubleMaps;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedObjectDoubleMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableObjectDoubleMap;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class ObjectDoubleHashMapWithHashingStrategy<K>
implements MutableObjectDoubleMap<K>,
Externalizable {
    public static final double EMPTY_VALUE = 0.0;
    private static final long serialVersionUID = 1L;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final Object NULL_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectDoubleHashMapWithHashingStrategy.NULL_KEY";
        }
    };
    private static final Object REMOVED_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectDoubleHashMapWithHashingStrategy.REMOVED_KEY";
        }
    };
    private Object[] keys;
    private double[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private HashingStrategy<? super K> hashingStrategy;

    @Deprecated
    public ObjectDoubleHashMapWithHashingStrategy() {
    }

    public ObjectDoubleHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy) {
        this.hashingStrategy = hashingStrategy;
        this.allocateTable(16);
    }

    public ObjectDoubleHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy, int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        this.hashingStrategy = hashingStrategy;
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    public ObjectDoubleHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy, ObjectDoubleMap<? extends K> map) {
        this(hashingStrategy, Math.max(map.size(), 8));
        this.putAll(map);
    }

    public static <K> ObjectDoubleHashMapWithHashingStrategy<K> newMap(HashingStrategy<? super K> hashingStrategy) {
        return new ObjectDoubleHashMapWithHashingStrategy<K>(hashingStrategy);
    }

    public static <K> ObjectDoubleHashMapWithHashingStrategy<K> newMap(HashingStrategy<? super K> hashingStrategy, ObjectDoubleMap<K> map) {
        return new ObjectDoubleHashMapWithHashingStrategy<K>(hashingStrategy, map);
    }

    public static <K> ObjectDoubleHashMapWithHashingStrategy<K> newMap(ObjectDoubleHashMapWithHashingStrategy<K> map) {
        return new ObjectDoubleHashMapWithHashingStrategy<K>(map.hashingStrategy, map);
    }

    public static <K> ObjectDoubleHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, double value1) {
        return new ObjectDoubleHashMapWithHashingStrategy<K>(hashingStrategy, 1).withKeyValue((Object)key1, value1);
    }

    public static <K> ObjectDoubleHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, double value1, K key2, double value2) {
        return new ObjectDoubleHashMapWithHashingStrategy<K>(hashingStrategy, 2).withKeysValues(key1, value1, key2, value2);
    }

    public static <K> ObjectDoubleHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, double value1, K key2, double value2, K key3, double value3) {
        return new ObjectDoubleHashMapWithHashingStrategy<K>(hashingStrategy, 3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static <K> ObjectDoubleHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, double value1, K key2, double value2, K key3, double value3, K key4, double value4) {
        return new ObjectDoubleHashMapWithHashingStrategy<K>(hashingStrategy, 4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectDoubleMap)) {
            return false;
        }
        ObjectDoubleMap other = (ObjectDoubleMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || other.containsKey(this.toNonSentinel(this.keys[i])) && Double.compare(this.values[i], other.getOrThrow(this.toNonSentinel(this.keys[i]))) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result += this.hashingStrategy.computeHashCode(this.toNonSentinel(this.keys[i])) ^ (int)(Double.doubleToLongBits(this.values[i]) ^ Double.doubleToLongBits(this.values[i]) >>> 32);
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        for (int i = 0; i < this.keys.length; ++i) {
            Object key = this.keys[i];
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(this.toNonSentinel(key)).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public int size() {
        return this.occupiedWithData;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            for (int i = 0; i < this.keys.length; ++i) {
                Object key = this.keys[i];
                if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(String.valueOf(this.values[i])));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableDoubleIterator doubleIterator() {
        return new InternalDoubleIterator();
    }

    public double[] toArray() {
        double[] result = new double[this.size()];
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result[index] = this.values[i];
            ++index;
        }
        return result;
    }

    public boolean contains(double value) {
        return this.containsValue(value);
    }

    public boolean containsAll(double ... source) {
        for (double item : source) {
            if (this.containsValue(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(DoubleIterable source) {
        return this.containsAll(source.toArray());
    }

    public void clear() {
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, 0.0);
    }

    public void put(K key, double value) {
        int index = this.probe(key);
        if (ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(ObjectDoubleMap<? extends K> map) {
        map.forEachKeyValue(new ObjectDoubleProcedure<K>(){

            public void value(K key, double value) {
                ObjectDoubleHashMapWithHashingStrategy.this.put(key, value);
            }
        });
    }

    public void removeKey(K key) {
        int index = this.probe(key);
        this.removeKeyAtIndex(key, index);
    }

    public void removeKeyAtIndex(K key, int index) {
        if (ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            this.values[index] = 0.0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
        }
    }

    public void remove(Object key) {
        this.removeKey(key);
    }

    public double removeKeyIfAbsent(K key, double value) {
        int index = this.probe(key);
        if (ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            double oldValue = this.values[index];
            this.values[index] = 0.0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            return oldValue;
        }
        return value;
    }

    public double getIfAbsentPut(K key, double value) {
        int index = this.probe(key);
        if (ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public double getIfAbsentPut(K key, DoubleFunction0 function) {
        int index = this.probe(key);
        if (ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        double value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> double getIfAbsentPutWith(K key, DoubleFunction<? super P> function, P parameter) {
        int index = this.probe(key);
        if (ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        double value = function.doubleValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public double getIfAbsentPutWithKey(K key, DoubleFunction<? super K> function) {
        int index = this.probe(key);
        if (ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        double value = function.doubleValueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public double updateValue(K key, double initialValueIfAbsent, DoubleToDoubleFunction function) {
        int index = this.probe(key);
        if (ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        double value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    private void addKeyValueAtIndex(K key, double value, int index) {
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectDoubleHashMapWithHashingStrategy.toSentinelIfNull(key);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public double addToValue(K key, double toBeAdded) {
        int index = this.probe(key);
        if (ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    public ObjectDoubleHashMapWithHashingStrategy<K> withKeyValue(K key1, double value1) {
        this.put(key1, value1);
        return this;
    }

    public ObjectDoubleHashMapWithHashingStrategy<K> withKeysValues(K key1, double value1, K key2, double value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ObjectDoubleHashMapWithHashingStrategy<K> withKeysValues(K key1, double value1, K key2, double value2, K key3, double value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ObjectDoubleHashMapWithHashingStrategy<K> withKeysValues(K key1, double value1, K key2, double value2, K key3, double value3, K key4, double value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ObjectDoubleHashMapWithHashingStrategy<K> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    public ObjectDoubleHashMapWithHashingStrategy<K> withoutAllKeys(Iterable<? extends K> keys) {
        for (K key : keys) {
            this.removeKey(key);
        }
        return this;
    }

    public MutableObjectDoubleMap<K> asUnmodifiable() {
        return new UnmodifiableObjectDoubleMap(this);
    }

    public MutableObjectDoubleMap<K> asSynchronized() {
        return new SynchronizedObjectDoubleMap(this);
    }

    public ImmutableObjectDoubleMap<K> toImmutable() {
        return ObjectDoubleMaps.immutable.withAll((ObjectDoubleMap)this);
    }

    public double get(Object key) {
        return this.getIfAbsent(key, 0.0);
    }

    public double getOrThrow(Object key) {
        int index = this.probe(key);
        if (ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public double getIfAbsent(Object key, double ifAbsent) {
        int index = this.probe(key);
        if (ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public boolean containsKey(Object key) {
        int index = this.probe(key);
        return ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key);
    }

    public boolean containsValue(double value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || Double.compare(this.values[i], value) != 0) continue;
            return true;
        }
        return false;
    }

    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    public void each(DoubleProcedure procedure) {
        this.forEachValue(procedure);
    }

    public void forEachValue(DoubleProcedure procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(Procedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]));
        }
    }

    public void forEachKeyValue(ObjectDoubleProcedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    public ObjectDoubleHashMapWithHashingStrategy<K> select(ObjectDoublePredicate<? super K> predicate) {
        ObjectDoubleHashMapWithHashingStrategy<K> result = ObjectDoubleHashMapWithHashingStrategy.newMap(this.hashingStrategy);
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    public ObjectDoubleHashMapWithHashingStrategy<K> reject(ObjectDoublePredicate<? super K> predicate) {
        ObjectDoubleHashMapWithHashingStrategy<K> result = ObjectDoubleHashMapWithHashingStrategy.newMap(this.hashingStrategy);
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    public MutableDoubleCollection select(DoublePredicate predicate) {
        DoubleArrayList result = new DoubleArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableDoubleCollection reject(DoublePredicate predicate) {
        DoubleArrayList result = new DoubleArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return ifNone;
    }

    public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
        FastList result = FastList.newList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(function.valueOf(this.values[i]));
        }
        return result;
    }

    public int count(DoublePredicate predicate) {
        int count = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectDoubleToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public double sum() {
        double result = 0.0;
        double compensation = 0.0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            double adjustedValue = this.values[i] - compensation;
            double nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        return result;
    }

    public double max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        double max = 0.0;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMaxSet && Double.compare(max, this.values[i]) >= 0) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    public double min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        double min = 0.0;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMinSet && Double.compare(this.values[i], min) >= 0) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return min;
    }

    public double maxIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        double max = 0.0;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMaxSet && Double.compare(max, this.values[i]) >= 0) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    public double minIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        double min = 0.0;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMinSet && Double.compare(this.values[i], min) >= 0) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return min;
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        double[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            double first = sortedArray[middleIndex];
            double second = sortedArray[middleIndex - 1];
            return (first + second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public MutableDoubleList toList() {
        DoubleArrayList result = new DoubleArrayList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableDoubleSet toSet() {
        DoubleHashSet result = new DoubleHashSet(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableDoubleBag toBag() {
        DoubleHashBag result = new DoubleHashBag(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public double[] toSortedArray() {
        double[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableDoubleList toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.hashingStrategy);
        out.writeInt(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            out.writeObject(this.toNonSentinel(this.keys[i]));
            out.writeDouble(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.hashingStrategy = (HashingStrategy)in.readObject();
        int size = in.readInt();
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(size * 2));
        this.allocateTable(capacity);
        for (int i = 0; i < size; ++i) {
            this.put(in.readObject(), in.readDouble());
        }
    }

    public LazyIterable<K> keysView() {
        return new KeysView();
    }

    public RichIterable<ObjectDoublePair<K>> keyValuesView() {
        return new KeyValuesView();
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        Object[] old = this.keys;
        double[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(old[i])) continue;
            this.put(this.toNonSentinel(old[i]), oldValues[i]);
        }
    }

    int probe(Object element) {
        int index = this.spread(element);
        int removedIndex = -1;
        if (ObjectDoubleHashMapWithHashingStrategy.isRemovedKey(this.keys[index])) {
            removedIndex = index;
        } else if (this.keys[index] == null || this.nullSafeEquals(this.toNonSentinel(this.keys[index]), element)) {
            return index;
        }
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (ObjectDoubleHashMapWithHashingStrategy.isRemovedKey(this.keys[nextIndex &= this.keys.length - 1])) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.nullSafeEquals(this.toNonSentinel(this.keys[nextIndex]), element)) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == null) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(Object element) {
        K nonSentinelKey = this.toNonSentinel(element);
        int h = nonSentinelKey == null ? 0 : this.hashingStrategy.computeHashCode(nonSentinelKey);
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & this.keys.length - 1;
    }

    private boolean nullSafeEquals(K value, Object other) {
        return value == null ? other == null : value != NULL_KEY && other != null && this.hashingStrategy.equals(value, this.toNonSentinel(other));
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new Object[sizeToAllocate];
        this.values = new double[sizeToAllocate];
    }

    private static boolean isRemovedKey(Object key) {
        return key == REMOVED_KEY;
    }

    private static <K> boolean isNonSentinel(K key) {
        return key != null && !ObjectDoubleHashMapWithHashingStrategy.isRemovedKey(key);
    }

    private K toNonSentinel(Object key) {
        return (K)(key == NULL_KEY ? null : key);
    }

    private static Object toSentinelIfNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public Set<K> keySet() {
        return new KeySet();
    }

    public MutableDoubleCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ Object[] access$302(ObjectDoubleHashMapWithHashingStrategy x0, Object[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ double[] access$502(ObjectDoubleHashMapWithHashingStrategy x0, double[] x1) {
        x0.values = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<ObjectDoublePair<K>> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super ObjectDoublePair<K>> procedure) {
            for (int i = 0; i < ObjectDoubleHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(ObjectDoubleHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectDoubleHashMapWithHashingStrategy.this.toNonSentinel(ObjectDoubleHashMapWithHashingStrategy.this.keys[i]), ObjectDoubleHashMapWithHashingStrategy.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ObjectDoublePair<K>> objectIntProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectDoubleHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(ObjectDoubleHashMapWithHashingStrategy.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(ObjectDoubleHashMapWithHashingStrategy.this.toNonSentinel(ObjectDoubleHashMapWithHashingStrategy.this.keys[i]), ObjectDoubleHashMapWithHashingStrategy.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ObjectDoublePair<K>, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectDoubleHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(ObjectDoubleHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectDoubleHashMapWithHashingStrategy.this.toNonSentinel(ObjectDoubleHashMapWithHashingStrategy.this.keys[i]), ObjectDoubleHashMapWithHashingStrategy.this.values[i]), parameter);
            }
        }

        public Iterator<ObjectDoublePair<K>> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<ObjectDoublePair<K>> {
            private int count;
            private int position;

            @Override
            public ObjectDoublePair<K> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectDoubleHashMapWithHashingStrategy.this.keys;
                while (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ObjectDoublePair<Object> result = PrimitiveTuples.pair(ObjectDoubleHashMapWithHashingStrategy.this.toNonSentinel(ObjectDoubleHashMapWithHashingStrategy.this.keys[this.position]), ObjectDoubleHashMapWithHashingStrategy.this.values[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectDoubleHashMapWithHashingStrategy.this.size();
            }
        }
    }

    private class KeysView
    extends AbstractLazyIterable<K> {
        private KeysView() {
        }

        public void each(Procedure<? super K> procedure) {
            ObjectDoubleHashMapWithHashingStrategy.this.forEachKey(procedure);
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super K> objectDoubleProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectDoubleHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(ObjectDoubleHashMapWithHashingStrategy.this.keys[i])) continue;
                objectDoubleProcedure.value(ObjectDoubleHashMapWithHashingStrategy.this.toNonSentinel(ObjectDoubleHashMapWithHashingStrategy.this.keys[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super K, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectDoubleHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(ObjectDoubleHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(ObjectDoubleHashMapWithHashingStrategy.this.toNonSentinel(ObjectDoubleHashMapWithHashingStrategy.this.keys[i]), parameter);
            }
        }

        public Iterator<K> iterator() {
            return new InternalKeysViewIterator();
        }

        public class InternalKeysViewIterator
        implements Iterator<K> {
            private int count;
            private int position;

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectDoubleHashMapWithHashingStrategy.this.keys;
                while (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                Object result = ObjectDoubleHashMapWithHashingStrategy.this.toNonSentinel(ObjectDoubleHashMapWithHashingStrategy.this.keys[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectDoubleHashMapWithHashingStrategy.this.size();
            }
        }
    }

    private class ValuesCollection
    implements MutableDoubleCollection {
        private ValuesCollection() {
        }

        public int size() {
            return ObjectDoubleHashMapWithHashingStrategy.this.size();
        }

        public boolean isEmpty() {
            return ObjectDoubleHashMapWithHashingStrategy.this.isEmpty();
        }

        public boolean notEmpty() {
            return ObjectDoubleHashMapWithHashingStrategy.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                for (int i = 0; i < ObjectDoubleHashMapWithHashingStrategy.this.keys.length; ++i) {
                    Object key = ObjectDoubleHashMapWithHashingStrategy.this.keys[i];
                    if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ObjectDoubleHashMapWithHashingStrategy.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean add(double element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(double ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(DoubleIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(double item) {
            int oldSize = ObjectDoubleHashMapWithHashingStrategy.this.size();
            for (int i = 0; i < ObjectDoubleHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(ObjectDoubleHashMapWithHashingStrategy.this.keys[i]) || Double.compare(item, ObjectDoubleHashMapWithHashingStrategy.this.values[i]) != 0) continue;
                ObjectDoubleHashMapWithHashingStrategy.this.removeKey(ObjectDoubleHashMapWithHashingStrategy.this.keys[i]);
            }
            return oldSize != ObjectDoubleHashMapWithHashingStrategy.this.size();
        }

        public boolean removeAll(DoubleIterable source) {
            int oldSize = ObjectDoubleHashMapWithHashingStrategy.this.size();
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != ObjectDoubleHashMapWithHashingStrategy.this.size();
        }

        public boolean removeAll(double ... source) {
            int oldSize = ObjectDoubleHashMapWithHashingStrategy.this.size();
            for (double item : source) {
                this.remove(item);
            }
            return oldSize != ObjectDoubleHashMapWithHashingStrategy.this.size();
        }

        public boolean retainAll(DoubleIterable source) {
            int oldSize = ObjectDoubleHashMapWithHashingStrategy.this.size();
            Object sourceSet = source instanceof DoubleSet ? (DoubleSet)source : source.toSet();
            MutableObjectDoubleMap retained = ObjectDoubleHashMapWithHashingStrategy.this.select(new ObjectDoublePredicate<K>((DoubleSet)sourceSet){
                final /* synthetic */ DoubleSet val$sourceSet;
                {
                    this.val$sourceSet = doubleSet;
                }

                public boolean accept(K object, double value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                ObjectDoubleHashMapWithHashingStrategy.access$302(ObjectDoubleHashMapWithHashingStrategy.this, ((ObjectDoubleHashMapWithHashingStrategy)retained).keys);
                ObjectDoubleHashMapWithHashingStrategy.access$502(ObjectDoubleHashMapWithHashingStrategy.this, ((ObjectDoubleHashMapWithHashingStrategy)retained).values);
                ObjectDoubleHashMapWithHashingStrategy.this.occupiedWithData = ((ObjectDoubleHashMapWithHashingStrategy)retained).occupiedWithData;
                ObjectDoubleHashMapWithHashingStrategy.this.occupiedWithSentinels = ((ObjectDoubleHashMapWithHashingStrategy)retained).occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(double ... source) {
            return this.retainAll(DoubleHashSet.newSetWith(source));
        }

        public void clear() {
            ObjectDoubleHashMapWithHashingStrategy.this.clear();
        }

        public MutableDoubleCollection with(double element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableDoubleCollection without(double element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableDoubleCollection withAll(DoubleIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableDoubleCollection withoutAll(DoubleIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableDoubleCollection asUnmodifiable() {
            return UnmodifiableDoubleCollection.of(this);
        }

        public MutableDoubleCollection asSynchronized() {
            return SynchronizedDoubleCollection.of(this);
        }

        public ImmutableDoubleCollection toImmutable() {
            return DoubleLists.immutable.withAll((DoubleIterable)this);
        }

        public MutableDoubleIterator doubleIterator() {
            return ObjectDoubleHashMapWithHashingStrategy.this.doubleIterator();
        }

        public double[] toArray() {
            return ObjectDoubleHashMapWithHashingStrategy.this.toArray();
        }

        public boolean contains(double value) {
            return ObjectDoubleHashMapWithHashingStrategy.this.containsValue(value);
        }

        public boolean containsAll(double ... source) {
            return ObjectDoubleHashMapWithHashingStrategy.this.containsAll(source);
        }

        public boolean containsAll(DoubleIterable source) {
            return ObjectDoubleHashMapWithHashingStrategy.this.containsAll(source);
        }

        public void forEach(DoubleProcedure procedure) {
            ObjectDoubleHashMapWithHashingStrategy.this.forEach(procedure);
        }

        public void each(DoubleProcedure procedure) {
            this.forEach(procedure);
        }

        public MutableDoubleCollection select(DoublePredicate predicate) {
            return ObjectDoubleHashMapWithHashingStrategy.this.select(predicate);
        }

        public MutableDoubleCollection reject(DoublePredicate predicate) {
            return ObjectDoubleHashMapWithHashingStrategy.this.reject(predicate);
        }

        public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
            return ObjectDoubleHashMapWithHashingStrategy.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
            return ObjectDoubleHashMapWithHashingStrategy.this.injectInto(injectedValue, function);
        }

        public double detectIfNone(DoublePredicate predicate, double ifNone) {
            return ObjectDoubleHashMapWithHashingStrategy.this.detectIfNone(predicate, ifNone);
        }

        public int count(DoublePredicate predicate) {
            return ObjectDoubleHashMapWithHashingStrategy.this.count(predicate);
        }

        public boolean anySatisfy(DoublePredicate predicate) {
            return ObjectDoubleHashMapWithHashingStrategy.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(DoublePredicate predicate) {
            return ObjectDoubleHashMapWithHashingStrategy.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(DoublePredicate predicate) {
            return ObjectDoubleHashMapWithHashingStrategy.this.noneSatisfy(predicate);
        }

        public MutableDoubleList toList() {
            return ObjectDoubleHashMapWithHashingStrategy.this.toList();
        }

        public MutableDoubleSet toSet() {
            return ObjectDoubleHashMapWithHashingStrategy.this.toSet();
        }

        public MutableDoubleBag toBag() {
            return ObjectDoubleHashMapWithHashingStrategy.this.toBag();
        }

        public LazyDoubleIterable asLazy() {
            return new LazyDoubleIterableAdapter((DoubleIterable)this);
        }

        public double[] toSortedArray() {
            return ObjectDoubleHashMapWithHashingStrategy.this.toSortedArray();
        }

        public MutableDoubleList toSortedList() {
            return ObjectDoubleHashMapWithHashingStrategy.this.toSortedList();
        }

        public double sum() {
            return ObjectDoubleHashMapWithHashingStrategy.this.sum();
        }

        public double max() {
            return ObjectDoubleHashMapWithHashingStrategy.this.max();
        }

        public double maxIfEmpty(double defaultValue) {
            return ObjectDoubleHashMapWithHashingStrategy.this.maxIfEmpty(defaultValue);
        }

        public double min() {
            return ObjectDoubleHashMapWithHashingStrategy.this.min();
        }

        public double minIfEmpty(double defaultValue) {
            return ObjectDoubleHashMapWithHashingStrategy.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return ObjectDoubleHashMapWithHashingStrategy.this.average();
        }

        public double median() {
            return ObjectDoubleHashMapWithHashingStrategy.this.median();
        }
    }

    private class KeySetIterator
    implements Iterator<K> {
        private int count;
        private int position;
        private K currentKey;
        private boolean isCurrentKeySet;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ObjectDoubleHashMapWithHashingStrategy.this.size();
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Object[] keys = ObjectDoubleHashMapWithHashingStrategy.this.keys;
            while (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.currentKey = ObjectDoubleHashMapWithHashingStrategy.this.keys[this.position];
            this.isCurrentKeySet = true;
            ++this.position;
            return ObjectDoubleHashMapWithHashingStrategy.this.toNonSentinel(this.currentKey);
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                ObjectDoubleHashMapWithHashingStrategy.this.removeKeyAtIndex(ObjectDoubleHashMapWithHashingStrategy.this.toNonSentinel(this.currentKey), index);
            } else {
                ObjectDoubleHashMapWithHashingStrategy.this.removeKey(this.currentKey);
            }
        }
    }

    private class KeySet
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public boolean equals(Object obj) {
            Set other;
            if (obj instanceof Set && (other = (Set)obj).size() == this.size()) {
                return this.containsAll(other);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            Object[] table = ObjectDoubleHashMapWithHashingStrategy.this.keys;
            for (int i = 0; i < table.length; ++i) {
                Object key = table[i];
                if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                Object nonSentinelKey = ObjectDoubleHashMapWithHashingStrategy.this.toNonSentinel(key);
                hashCode += nonSentinelKey == null ? 0 : ObjectDoubleHashMapWithHashingStrategy.this.hashingStrategy.computeHashCode(nonSentinelKey);
            }
            return hashCode;
        }

        @Override
        public int size() {
            return ObjectDoubleHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectDoubleHashMapWithHashingStrategy.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ObjectDoubleHashMapWithHashingStrategy.this.containsKey(o);
        }

        @Override
        public Object[] toArray() {
            int size = ObjectDoubleHashMapWithHashingStrategy.this.size();
            Object[] result = new Object[size];
            this.copyKeys(result);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] result) {
            int size = ObjectDoubleHashMapWithHashingStrategy.this.size();
            if (result.length < size) {
                result = (Object[])Array.newInstance(result.getClass().getComponentType(), size);
            }
            this.copyKeys(result);
            if (size < result.length) {
                result[size] = null;
            }
            return result;
        }

        @Override
        public boolean add(K key) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(Object key) {
            int oldSize = ObjectDoubleHashMapWithHashingStrategy.this.size();
            ObjectDoubleHashMapWithHashingStrategy.this.removeKey(key);
            return oldSize != ObjectDoubleHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object aCollection : collection) {
                if (ObjectDoubleHashMapWithHashingStrategy.this.containsKey(aCollection)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int oldSize = ObjectDoubleHashMapWithHashingStrategy.this.size();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (collection.contains(next)) continue;
                iterator.remove();
            }
            return oldSize != ObjectDoubleHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int oldSize = ObjectDoubleHashMapWithHashingStrategy.this.size();
            for (Object object : collection) {
                ObjectDoubleHashMapWithHashingStrategy.this.removeKey(object);
            }
            return oldSize != ObjectDoubleHashMapWithHashingStrategy.this.size();
        }

        @Override
        public void clear() {
            ObjectDoubleHashMapWithHashingStrategy.this.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        private void copyKeys(Object[] result) {
            int count = 0;
            for (int i = 0; i < ObjectDoubleHashMapWithHashingStrategy.this.keys.length; ++i) {
                Object key = ObjectDoubleHashMapWithHashingStrategy.this.keys[i];
                if (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                result[count++] = ObjectDoubleHashMapWithHashingStrategy.this.keys[i];
            }
        }
    }

    private class InternalDoubleIterator
    implements MutableDoubleIterator {
        private int count;
        private int position;

        private InternalDoubleIterator() {
        }

        public boolean hasNext() {
            return this.count != ObjectDoubleHashMapWithHashingStrategy.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] keys = ObjectDoubleHashMapWithHashingStrategy.this.keys;
            while (!ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            double result = ObjectDoubleHashMapWithHashingStrategy.this.values[this.position];
            ++this.count;
            ++this.position;
            return result;
        }

        public void remove() {
            if (this.position == 0 || !ObjectDoubleHashMapWithHashingStrategy.isNonSentinel(ObjectDoubleHashMapWithHashingStrategy.this.keys[this.position - 1])) {
                throw new IllegalStateException();
            }
            ObjectDoubleHashMapWithHashingStrategy.this.remove(ObjectDoubleHashMapWithHashingStrategy.this.keys[this.position - 1]);
            --this.count;
        }
    }
}

