/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharFloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharFloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.map.primitive.CharFloatMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharFloatMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.CharFloatPair;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.primitive.FloatBags;
import org.eclipse.collections.impl.iterator.ImmutableEmptyFloatIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharFloatSingletonMap;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyCharIterate;

final class ImmutableCharFloatEmptyMap
implements ImmutableCharFloatMap,
Serializable {
    static final ImmutableCharFloatMap INSTANCE = new ImmutableCharFloatEmptyMap();
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_VALUE = 0.0f;

    ImmutableCharFloatEmptyMap() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public float get(char key) {
        return 0.0f;
    }

    public float getIfAbsent(char key, float ifAbsent) {
        return ifAbsent;
    }

    public float getOrThrow(char key) {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(char key) {
        return false;
    }

    public boolean containsValue(float value) {
        return false;
    }

    public void forEachValue(FloatProcedure procedure) {
    }

    public void forEachKey(CharProcedure procedure) {
    }

    public void forEachKeyValue(CharFloatProcedure procedure) {
    }

    public LazyCharIterable keysView() {
        return LazyCharIterate.empty();
    }

    public RichIterable<CharFloatPair> keyValuesView() {
        return LazyIterate.empty();
    }

    public ImmutableCharFloatMap select(CharFloatPredicate predicate) {
        return this;
    }

    public ImmutableCharFloatMap reject(CharFloatPredicate predicate) {
        return this;
    }

    public ImmutableCharFloatMap toImmutable() {
        return this;
    }

    public FloatIterator floatIterator() {
        return ImmutableEmptyFloatIterator.INSTANCE;
    }

    public void forEach(FloatProcedure procedure) {
    }

    public void each(FloatProcedure procedure) {
    }

    public int count(FloatPredicate predicate) {
        return 0;
    }

    public double sum() {
        return 0.0;
    }

    public float min() {
        throw new NoSuchElementException();
    }

    public float max() {
        throw new NoSuchElementException();
    }

    public float maxIfEmpty(float defaultValue) {
        return defaultValue;
    }

    public float minIfEmpty(float defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public float[] toSortedArray() {
        return new float[0];
    }

    public MutableFloatList toSortedList() {
        return new FloatArrayList();
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return false;
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return true;
    }

    public ImmutableFloatBag select(FloatPredicate predicate) {
        return FloatBags.immutable.empty();
    }

    public ImmutableFloatBag reject(FloatPredicate predicate) {
        return FloatBags.immutable.empty();
    }

    public <V> ImmutableBag<V> collect(FloatToObjectFunction<? extends V> function) {
        return Bags.immutable.empty();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public float[] toArray() {
        return new float[0];
    }

    public boolean contains(float value) {
        return false;
    }

    public boolean containsAll(float ... source) {
        return source.length == 0;
    }

    public boolean containsAll(FloatIterable source) {
        return source.isEmpty();
    }

    public MutableFloatList toList() {
        return new FloatArrayList();
    }

    public MutableFloatSet toSet() {
        return new FloatHashSet();
    }

    public MutableFloatBag toBag() {
        return new FloatHashBag();
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public ImmutableCharFloatMap newWithKeyValue(char key, float value) {
        return new ImmutableCharFloatSingletonMap(key, value);
    }

    public ImmutableCharFloatMap newWithoutKey(char key) {
        return this;
    }

    public ImmutableCharFloatMap newWithoutAllKeys(CharIterable keys) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public MutableCharSet keySet() {
        return UnmodifiableCharSet.of(new CharHashSet());
    }

    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of((MutableFloatCollection)new FloatArrayList());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharFloatMap)) {
            return false;
        }
        CharFloatMap map = (CharFloatMap)obj;
        return map.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "{}";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

