/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel.set;

import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.multimap.bag.UnsortedBagMultimap;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterable;
import org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterableImpl;
import org.eclipse.collections.impl.lazy.parallel.Batch;

@Beta
public class ParallelCollectIterable<T, V>
extends AbstractParallelIterableImpl<V, Batch<V>> {
    private final AbstractParallelIterable<T, ? extends Batch<T>> delegate;
    private final Function<? super T, ? extends V> function;

    public ParallelCollectIterable(AbstractParallelIterable<T, ? extends Batch<T>> delegate, Function<? super T, ? extends V> function) {
        this.delegate = delegate;
        this.function = function;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.delegate.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.delegate.getBatchSize();
    }

    @Override
    public LazyIterable<Batch<V>> split() {
        return this.delegate.split().collect(new Function<Batch<T>, Batch<V>>(){

            public Batch<V> valueOf(Batch<T> eachBatch) {
                return eachBatch.collect(ParallelCollectIterable.this.function);
            }
        });
    }

    public void forEach(Procedure<? super V> procedure) {
        this.delegate.forEach(Functions.bind(procedure, this.function));
    }

    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.delegate.anySatisfy(Predicates.attributePredicate(this.function, predicate));
    }

    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.delegate.allSatisfy(Predicates.attributePredicate(this.function, predicate));
    }

    public V detect(Predicate<? super V> predicate) {
        Object resultItem = this.delegate.detect(Predicates.attributePredicate(this.function, predicate));
        return (V)(resultItem == null ? null : this.function.valueOf(resultItem));
    }

    public Object[] toArray() {
        return this.delegate.toList().collect(this.function).toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.delegate.toList().collect(this.function).toArray((Object[])array);
    }

    @Override
    public <V1> UnsortedBagMultimap<V1, V> groupBy(Function<? super V, ? extends V1> function) {
        return this.delegate.toBag().collect(this.function).groupBy(function);
    }

    @Override
    public <V1> UnsortedBagMultimap<V1, V> groupByEach(Function<? super V, ? extends Iterable<V1>> function) {
        return this.delegate.toBag().collect(this.function).groupByEach(function);
    }

    @Override
    public <V1> MapIterable<V1, V> groupByUniqueKey(Function<? super V, ? extends V1> function) {
        return this.delegate.toBag().collect(this.function).groupByUniqueKey(function);
    }
}

