/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.factory;

import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.impl.block.function.primitive.IntegerFunctionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringFunctions {
    private static final Function<String, String> TO_UPPER_CASE = new ToUpperCaseFunction();
    private static final Function<String, String> TO_LOWER_CASE = new ToLowerCaseFunction();
    private static final IntegerFunctionImpl<String> LENGTH = new LengthFunction();
    private static final Function<String, String> TRIM = new TrimFunction();
    private static final Function<String, Character> FIRST_LETTER = new FirstLetterFunction();
    private static final Function<String, Integer> TO_INTEGER = new ToIntegerFunction();
    private static final BooleanFunction<String> TO_PRIMITIVE_BOOLEAN = new ToPrimitiveBooleanFunction();
    private static final ByteFunction<String> TO_PRIMITIVE_BYTE = new ToPrimitiveByteFunction();
    private static final CharFunction<String> TO_PRIMITIVE_CHAR = new ToPrimitiveCharFunction();
    private static final CharFunction<String> TO_FIRST_CHAR = new ToFirstCharFunction();
    private static final DoubleFunction<String> TO_PRIMITIVE_DOUBLE = new ToPrimitiveDoubleFunction();
    private static final FloatFunction<String> TO_PRIMITIVE_FLOAT = new ToPrimitiveFloatFunction();
    private static final IntFunction<String> TO_PRIMITIVE_INT = new ToPrimitiveIntFunction();
    private static final LongFunction<String> TO_PRIMITIVE_LONG = new ToPrimitiveLongFunction();
    private static final ShortFunction<String> TO_PRIMITIVE_SHORT = new ToPrimitiveShortFunction();

    private StringFunctions() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static Function<String, String> toUpperCase() {
        return TO_UPPER_CASE;
    }

    public static Function<String, String> toLowerCase() {
        return TO_LOWER_CASE;
    }

    public static Function<String, Integer> toInteger() {
        return TO_INTEGER;
    }

    public static BooleanFunction<String> toPrimitiveBoolean() {
        return TO_PRIMITIVE_BOOLEAN;
    }

    public static ByteFunction<String> toPrimitiveByte() {
        return TO_PRIMITIVE_BYTE;
    }

    public static CharFunction<String> toPrimitiveChar() {
        return TO_PRIMITIVE_CHAR;
    }

    public static CharFunction<String> toFirstChar() {
        return TO_FIRST_CHAR;
    }

    public static DoubleFunction<String> toPrimitiveDouble() {
        return TO_PRIMITIVE_DOUBLE;
    }

    public static FloatFunction<String> toPrimitiveFloat() {
        return TO_PRIMITIVE_FLOAT;
    }

    public static IntFunction<String> toPrimitiveInt() {
        return TO_PRIMITIVE_INT;
    }

    public static LongFunction<String> toPrimitiveLong() {
        return TO_PRIMITIVE_LONG;
    }

    public static ShortFunction<String> toPrimitiveShort() {
        return TO_PRIMITIVE_SHORT;
    }

    public static IntegerFunctionImpl<String> length() {
        return LENGTH;
    }

    public static Function<String, Character> firstLetter() {
        return FIRST_LETTER;
    }

    public static Function<String, String> subString(int beginIndex, int endIndex) {
        return new SubStringFunction(beginIndex, endIndex);
    }

    public static Function<String, String> trim() {
        return TRIM;
    }

    public static Function<String, String> append(String valueToAppend) {
        return new AppendFunction(valueToAppend);
    }

    public static Function<String, String> prepend(String valueToPrepend) {
        return new PrependFunction(valueToPrepend);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PrependFunction
    implements Function<String, String> {
        private static final long serialVersionUID = 1L;
        private final String valueToPrepend;

        private PrependFunction(String valueToPrepend) {
            this.valueToPrepend = valueToPrepend;
        }

        public String valueOf(String string) {
            return this.valueToPrepend + string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AppendFunction
    implements Function<String, String> {
        private static final long serialVersionUID = 1L;
        private final String valueToAppend;

        private AppendFunction(String valueToAppend) {
            this.valueToAppend = valueToAppend;
        }

        public String valueOf(String string) {
            return string + this.valueToAppend;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SubStringFunction
    implements Function<String, String> {
        private static final long serialVersionUID = 1L;
        private final int beginIndex;
        private final int endIndex;

        private SubStringFunction(int beginIndex, int endIndex) {
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        public String valueOf(String string) {
            return string.substring(this.beginIndex, this.endIndex);
        }

        public String toString() {
            return "string.subString(" + this.beginIndex + ',' + this.endIndex + ')';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ToPrimitiveShortFunction
    implements ShortFunction<String> {
        private static final long serialVersionUID = 1L;

        private ToPrimitiveShortFunction() {
        }

        public short shortValueOf(String string) {
            return Short.parseShort(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ToPrimitiveLongFunction
    implements LongFunction<String> {
        private static final long serialVersionUID = 1L;

        private ToPrimitiveLongFunction() {
        }

        public long longValueOf(String string) {
            return Long.parseLong(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ToPrimitiveIntFunction
    implements IntFunction<String> {
        private static final long serialVersionUID = 1L;

        private ToPrimitiveIntFunction() {
        }

        public int intValueOf(String string) {
            return Integer.parseInt(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ToPrimitiveFloatFunction
    implements FloatFunction<String> {
        private static final long serialVersionUID = 1L;

        private ToPrimitiveFloatFunction() {
        }

        public float floatValueOf(String string) {
            return Float.parseFloat(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ToPrimitiveDoubleFunction
    implements DoubleFunction<String> {
        private static final long serialVersionUID = 1L;

        private ToPrimitiveDoubleFunction() {
        }

        public double doubleValueOf(String string) {
            return Double.parseDouble(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ToPrimitiveCharFunction
    implements CharFunction<String> {
        private static final long serialVersionUID = 1L;

        private ToPrimitiveCharFunction() {
        }

        public char charValueOf(String string) {
            return (char)Integer.parseInt(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ToFirstCharFunction
    implements CharFunction<String> {
        private static final long serialVersionUID = 1L;

        private ToFirstCharFunction() {
        }

        public char charValueOf(String string) {
            return string.charAt(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ToPrimitiveByteFunction
    implements ByteFunction<String> {
        private static final long serialVersionUID = 1L;

        private ToPrimitiveByteFunction() {
        }

        public byte byteValueOf(String string) {
            return Byte.parseByte(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ToPrimitiveBooleanFunction
    implements BooleanFunction<String> {
        private static final long serialVersionUID = 1L;

        private ToPrimitiveBooleanFunction() {
        }

        public boolean booleanValueOf(String string) {
            return Boolean.parseBoolean(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ToIntegerFunction
    implements Function<String, Integer> {
        private static final long serialVersionUID = 1L;

        private ToIntegerFunction() {
        }

        public Integer valueOf(String string) {
            return Integer.valueOf(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FirstLetterFunction
    implements Function<String, Character> {
        private static final long serialVersionUID = 1L;

        private FirstLetterFunction() {
        }

        public Character valueOf(String object) {
            return object == null || object.length() < 1 ? null : Character.valueOf(object.charAt(0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TrimFunction
    implements Function<String, String> {
        private static final long serialVersionUID = 1L;

        private TrimFunction() {
        }

        public String valueOf(String string) {
            return string.trim();
        }

        public String toString() {
            return "string.trim()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LengthFunction
    extends IntegerFunctionImpl<String> {
        private static final long serialVersionUID = 1L;

        private LengthFunction() {
        }

        public int intValueOf(String string) {
            return string.length();
        }

        public String toString() {
            return "string.length()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ToLowerCaseFunction
    implements Function<String, String> {
        private static final long serialVersionUID = 1L;

        private ToLowerCaseFunction() {
        }

        public String valueOf(String object) {
            return object.toLowerCase();
        }

        public String toString() {
            return "string.toLowerCase()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ToUpperCaseFunction
    implements Function<String, String> {
        private static final long serialVersionUID = 1L;

        private ToUpperCaseFunction() {
        }

        public String valueOf(String object) {
            return object.toUpperCase();
        }

        public String toString() {
            return "string.toUpperCase()";
        }
    }
}

