/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.DoubleFloatToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction0;
import org.eclipse.collections.api.block.function.primitive.FloatToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoubleFloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleFloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.iterator.MutableFloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.map.primitive.DoubleFloatMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleFloatMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleFloatMap;
import org.eclipse.collections.api.map.primitive.MutableFloatDoubleMap;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.DoubleFloatPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import org.eclipse.collections.impl.factory.primitive.DoubleFloatMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableFloatIterator;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedDoubleFloatMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;

public class UnmodifiableDoubleFloatMap
implements MutableDoubleFloatMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableDoubleFloatMap map;

    public UnmodifiableDoubleFloatMap(MutableDoubleFloatMap map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot create a UnmodifiableDoubleFloatMap on a null map");
        }
        this.map = map;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(double key, float value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putPair(DoubleFloatPair keyValuePair) {
        throw new UnsupportedOperationException("Cannot call putPair() on " + this.getClass().getSimpleName());
    }

    public void putAll(DoubleFloatMap map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void updateValues(DoubleFloatToFloatFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValues() on " + this.getClass().getSimpleName());
    }

    public void removeKey(double key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(double key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public float removeKeyIfAbsent(double key, float value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public float getIfAbsentPut(double key, float value) {
        return this.map.getIfAbsentPut(key, (FloatFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public float getIfAbsentPut(double key, FloatFunction0 function) {
        return this.map.getIfAbsentPut(key, (FloatFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public float getIfAbsentPutWithKey(double key, DoubleToFloatFunction function) {
        return this.map.getIfAbsentPut(key, (FloatFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public <P> float getIfAbsentPutWith(double key, FloatFunction<? super P> function, P parameter) {
        return this.map.getIfAbsentPut(key, (FloatFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public float updateValue(double key, float initialValueIfAbsent, FloatToFloatFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public float get(double key) {
        return this.map.get(key);
    }

    public float getIfAbsent(double key, float ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public float getOrThrow(double key) {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(double key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(float value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(FloatProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(DoubleProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(DoubleFloatProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public LazyDoubleIterable keysView() {
        return this.map.keysView();
    }

    public RichIterable<DoubleFloatPair> keyValuesView() {
        return this.map.keyValuesView();
    }

    public MutableFloatDoubleMap flipUniqueValues() {
        return this.map.flipUniqueValues().asUnmodifiable();
    }

    public MutableDoubleFloatMap select(DoubleFloatPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableDoubleFloatMap reject(DoubleFloatPredicate predicate) {
        return this.map.reject(predicate);
    }

    public MutableFloatIterator floatIterator() {
        return new UnmodifiableFloatIterator((FloatIterator)this.map.floatIterator());
    }

    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    public void each(FloatProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(FloatPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableFloatBag select(FloatPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableFloatBag reject(FloatPredicate predicate) {
        return this.map.reject(predicate);
    }

    public <V> MutableBag<V> collect(FloatToObjectFunction<? extends V> function) {
        return this.map.collect(function);
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public double sum() {
        return this.map.sum();
    }

    public float max() {
        return this.map.max();
    }

    public float maxIfEmpty(float defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public float min() {
        return this.map.min();
    }

    public float minIfEmpty(float defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public float addToValue(double key, float toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public float[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableFloatList toSortedList() {
        return this.map.toSortedList();
    }

    public float[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(float value) {
        return this.map.contains(value);
    }

    public boolean containsAll(float ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(FloatIterable source) {
        return this.map.containsAll(source);
    }

    public MutableFloatList toList() {
        return this.map.toList();
    }

    public MutableFloatSet toSet() {
        return this.map.toSet();
    }

    public MutableFloatBag toBag() {
        return this.map.toBag();
    }

    public LazyFloatIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableDoubleFloatMap withKeyValue(double key, float value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleFloatMap withoutKey(double key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleFloatMap withoutAllKeys(DoubleIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleFloatMap asUnmodifiable() {
        return this;
    }

    public MutableDoubleFloatMap asSynchronized() {
        return new SynchronizedDoubleFloatMap(this);
    }

    public ImmutableDoubleFloatMap toImmutable() {
        return DoubleFloatMaps.immutable.withAll((DoubleFloatMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public MutableDoubleSet keySet() {
        return UnmodifiableDoubleSet.of(this.map.keySet());
    }

    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of(this.map.values());
    }

    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return (T)this.map.injectInto(injectedValue, function);
    }

    public RichIterable<FloatIterable> chunk(int size) {
        return this.map.chunk(size);
    }
}

