/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction0;
import org.eclipse.collections.api.block.function.primitive.CharToCharFunction;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToCharFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectCharPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectCharMap;
import org.eclipse.collections.api.map.primitive.MutableCharObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectCharMap;
import org.eclipse.collections.api.map.primitive.ObjectCharMap;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.ObjectCharPair;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedCharCollection;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.CharBags;
import org.eclipse.collections.impl.factory.primitive.CharLists;
import org.eclipse.collections.impl.factory.primitive.CharObjectMaps;
import org.eclipse.collections.impl.factory.primitive.ObjectCharMaps;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedObjectCharMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableObjectCharMap;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class ObjectCharHashMap<K>
implements MutableObjectCharMap<K>,
Externalizable {
    public static final char EMPTY_VALUE = '\u0000';
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final Object NULL_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectCharHashMap.NULL_KEY";
        }
    };
    private static final Object REMOVED_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectCharHashMap.REMOVED_KEY";
        }
    };
    private Object[] keys;
    private char[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;

    public ObjectCharHashMap() {
        this.allocateTable(16);
    }

    public ObjectCharHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity << 1));
        this.allocateTable(capacity);
    }

    public ObjectCharHashMap(ObjectCharMap<? extends K> map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    public static <K> ObjectCharHashMap<K> newMap() {
        return new ObjectCharHashMap<K>();
    }

    public static <K> ObjectCharHashMap<K> newWithKeysValues(K key1, char value1) {
        return new ObjectCharHashMap<K>(1).withKeyValue((Object)key1, value1);
    }

    public static <K> ObjectCharHashMap<K> newWithKeysValues(K key1, char value1, K key2, char value2) {
        return new ObjectCharHashMap<K>(2).withKeysValues(key1, value1, key2, value2);
    }

    public static <K> ObjectCharHashMap<K> newWithKeysValues(K key1, char value1, K key2, char value2, K key3, char value3) {
        return new ObjectCharHashMap<K>(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static <K> ObjectCharHashMap<K> newWithKeysValues(K key1, char value1, K key2, char value2, K key3, char value3, K key4, char value4) {
        return new ObjectCharHashMap<K>(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectCharMap)) {
            return false;
        }
        ObjectCharMap other = (ObjectCharMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i]) || other.containsKey(this.toNonSentinel(this.keys[i])) && this.values[i] == other.getOrThrow(this.toNonSentinel(this.keys[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i])) continue;
            result += (this.toNonSentinel(this.keys[i]) == null ? 0 : this.keys[i].hashCode()) ^ this.values[i];
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        for (int i = 0; i < this.keys.length; ++i) {
            Object key = this.keys[i];
            if (!ObjectCharHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(this.toNonSentinel(key)).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public int size() {
        return this.occupiedWithData;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            for (int i = 0; i < this.keys.length; ++i) {
                Object key = this.keys[i];
                if (!ObjectCharHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(String.valueOf(this.values[i])));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableCharIterator charIterator() {
        return new InternalCharIterator();
    }

    public char[] toArray() {
        char[] result = new char[this.size()];
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i])) continue;
            result[index] = this.values[i];
            ++index;
        }
        return result;
    }

    public boolean contains(char value) {
        return this.containsValue(value);
    }

    public boolean containsAll(char ... source) {
        for (char item : source) {
            if (this.containsValue(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(CharIterable source) {
        return this.containsAll(source.toArray());
    }

    public void clear() {
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, '\u0000');
    }

    public void put(K key, char value) {
        int index = this.probe(key);
        if (ObjectCharHashMap.isNonSentinel(this.keys[index]) && ObjectCharHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(ObjectCharMap<? extends K> map) {
        map.forEachKeyValue(this::put);
    }

    public void updateValues(ObjectCharToCharFunction<? super K> function) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i])) continue;
            this.values[i] = function.valueOf(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    public void removeKey(K key) {
        int index = this.probe(key);
        this.removeKeyAtIndex(key, index);
    }

    private void removeKeyAtIndex(K key, int index) {
        if (ObjectCharHashMap.isNonSentinel(this.keys[index]) && ObjectCharHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            this.values[index] = '\u0000';
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
        }
    }

    public void remove(Object key) {
        this.removeKey(key);
    }

    public char removeKeyIfAbsent(K key, char value) {
        int index = this.probe(key);
        if (ObjectCharHashMap.isNonSentinel(this.keys[index]) && ObjectCharHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            char oldValue = this.values[index];
            this.values[index] = '\u0000';
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            return oldValue;
        }
        return value;
    }

    public char getIfAbsentPut(K key, char value) {
        int index = this.probe(key);
        if (ObjectCharHashMap.isNonSentinel(this.keys[index]) && ObjectCharHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public char getIfAbsentPut(K key, CharFunction0 function) {
        int index = this.probe(key);
        if (ObjectCharHashMap.isNonSentinel(this.keys[index]) && ObjectCharHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        char value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> char getIfAbsentPutWith(K key, CharFunction<? super P> function, P parameter) {
        int index = this.probe(key);
        if (ObjectCharHashMap.isNonSentinel(this.keys[index]) && ObjectCharHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        char value = function.charValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public char getIfAbsentPutWithKey(K key, CharFunction<? super K> function) {
        int index = this.probe(key);
        if (ObjectCharHashMap.isNonSentinel(this.keys[index]) && ObjectCharHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        char value = function.charValueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public char updateValue(K key, char initialValueIfAbsent, CharToCharFunction function) {
        int index = this.probe(key);
        if (ObjectCharHashMap.isNonSentinel(this.keys[index]) && ObjectCharHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        char value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    private void addKeyValueAtIndex(K key, char value, int index) {
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectCharHashMap.toSentinelIfNull(key);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public char addToValue(K key, char toBeAdded) {
        int index = this.probe(key);
        if (ObjectCharHashMap.isNonSentinel(this.keys[index]) && ObjectCharHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            int n = index;
            this.values[n] = (char)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    public ObjectCharHashMap<K> withKeyValue(K key1, char value1) {
        this.put(key1, value1);
        return this;
    }

    public ObjectCharHashMap<K> withKeysValues(K key1, char value1, K key2, char value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ObjectCharHashMap<K> withKeysValues(K key1, char value1, K key2, char value2, K key3, char value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ObjectCharHashMap<K> withKeysValues(K key1, char value1, K key2, char value2, K key3, char value3, K key4, char value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ObjectCharHashMap<K> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    public ObjectCharHashMap<K> withoutAllKeys(Iterable<? extends K> keys) {
        for (K key : keys) {
            this.removeKey(key);
        }
        return this;
    }

    public MutableObjectCharMap<K> asUnmodifiable() {
        return new UnmodifiableObjectCharMap(this);
    }

    public MutableObjectCharMap<K> asSynchronized() {
        return new SynchronizedObjectCharMap(this);
    }

    public ImmutableObjectCharMap<K> toImmutable() {
        return ObjectCharMaps.immutable.withAll((ObjectCharMap)this);
    }

    public char get(Object key) {
        return this.getIfAbsent(key, '\u0000');
    }

    public char getOrThrow(Object key) {
        int index = this.probe(key);
        if (ObjectCharHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public char getIfAbsent(Object key, char ifAbsent) {
        int index = this.probe(key);
        if (ObjectCharHashMap.isNonSentinel(this.keys[index]) && ObjectCharHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public boolean containsKey(Object key) {
        int index = this.probe(key);
        return ObjectCharHashMap.isNonSentinel(this.keys[index]) && ObjectCharHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key);
    }

    public boolean containsValue(char value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    public void each(CharProcedure procedure) {
        this.forEachValue(procedure);
    }

    public void forEachValue(CharProcedure procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(Procedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]));
        }
    }

    public void forEachKeyValue(ObjectCharProcedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    public ObjectCharHashMap<K> select(ObjectCharPredicate<? super K> predicate) {
        ObjectCharHashMap<K> result = ObjectCharHashMap.newMap();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    public ObjectCharHashMap<K> reject(ObjectCharPredicate<? super K> predicate) {
        ObjectCharHashMap<K> result = ObjectCharHashMap.newMap();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    public MutableCharCollection select(CharPredicate predicate) {
        CharArrayList result = new CharArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableCharCollection reject(CharPredicate predicate) {
        CharArrayList result = new CharArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return ifNone;
    }

    public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        FastList result = FastList.newList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(function.valueOf(this.values[i]));
        }
        return result;
    }

    public int count(CharPredicate predicate) {
        int count = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(CharPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(CharPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectCharToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public RichIterable<CharIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableCharIterator iterator = this.charIterator();
            while (iterator.hasNext()) {
                MutableCharBag batch = CharBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add((Object)batch);
            }
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    public char max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        char max = '\u0000';
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i]) || isMaxSet && max >= this.values[i]) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    public char min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        char min = '\u0000';
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return min;
    }

    public char maxIfEmpty(char defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        char max = '\u0000';
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i]) || isMaxSet && max >= this.values[i]) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    public char minIfEmpty(char defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        char min = '\u0000';
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return min;
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        char[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            char first = sortedArray[middleIndex];
            char second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public MutableCharList toList() {
        CharArrayList result = new CharArrayList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableCharSet toSet() {
        CharHashSet result = new CharHashSet(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableCharBag toBag() {
        CharHashBag result = new CharHashBag(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public char[] toSortedArray() {
        char[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableCharList toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeObject(this.toNonSentinel(this.keys[i]));
            out.writeChar(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(size << 1));
        this.allocateTable(capacity);
        for (int i = 0; i < size; ++i) {
            this.put(in.readObject(), in.readChar());
        }
    }

    public LazyIterable<K> keysView() {
        return new KeysView();
    }

    public RichIterable<ObjectCharPair<K>> keyValuesView() {
        return new KeyValuesView();
    }

    public MutableCharObjectMap<K> flipUniqueValues() {
        MutableCharObjectMap result = CharObjectMaps.mutable.empty();
        this.forEachKeyValue((ObjectCharProcedure & Serializable)(key, value) -> {
            Object oldKey = result.put(value, key);
            if (oldKey != null) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + oldKey + " and key: " + key);
            }
        });
        return result;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        Object[] old = this.keys;
        char[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ObjectCharHashMap.isNonSentinel(old[i])) continue;
            this.put(this.toNonSentinel(old[i]), oldValues[i]);
        }
    }

    int probe(Object element) {
        int index = this.spread(element);
        int removedIndex = -1;
        if (ObjectCharHashMap.isRemovedKey(this.keys[index])) {
            removedIndex = index;
        } else if (this.keys[index] == null || ObjectCharHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), element)) {
            return index;
        }
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (ObjectCharHashMap.isRemovedKey(this.keys[nextIndex &= this.keys.length - 1])) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (ObjectCharHashMap.nullSafeEquals(this.toNonSentinel(this.keys[nextIndex]), element)) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == null) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(Object element) {
        int h = element == null ? 0 : element.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & this.keys.length - 1;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new Object[sizeToAllocate];
        this.values = new char[sizeToAllocate];
    }

    private static boolean isRemovedKey(Object key) {
        return key == REMOVED_KEY;
    }

    private static <K> boolean isNonSentinel(K key) {
        return key != null && !ObjectCharHashMap.isRemovedKey(key);
    }

    private K toNonSentinel(Object key) {
        return (K)(key == NULL_KEY ? null : key);
    }

    private static Object toSentinelIfNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity >> 1);
    }

    public Set<K> keySet() {
        return new KeySet();
    }

    public MutableCharCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ Object[] access$302(ObjectCharHashMap x0, Object[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ char[] access$502(ObjectCharHashMap x0, char[] x1) {
        x0.values = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<ObjectCharPair<K>> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super ObjectCharPair<K>> procedure) {
            for (int i = 0; i < ObjectCharHashMap.this.keys.length; ++i) {
                if (!ObjectCharHashMap.isNonSentinel(ObjectCharHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectCharHashMap.this.toNonSentinel(ObjectCharHashMap.this.keys[i]), ObjectCharHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ObjectCharPair<K>> objectIntProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectCharHashMap.this.keys.length; ++i) {
                if (!ObjectCharHashMap.isNonSentinel(ObjectCharHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(ObjectCharHashMap.this.toNonSentinel(ObjectCharHashMap.this.keys[i]), ObjectCharHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ObjectCharPair<K>, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectCharHashMap.this.keys.length; ++i) {
                if (!ObjectCharHashMap.isNonSentinel(ObjectCharHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectCharHashMap.this.toNonSentinel(ObjectCharHashMap.this.keys[i]), ObjectCharHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<ObjectCharPair<K>> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<ObjectCharPair<K>> {
            private int count;
            private int position;

            @Override
            public ObjectCharPair<K> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectCharHashMap.this.keys;
                while (!ObjectCharHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ObjectCharPair<Object> result = PrimitiveTuples.pair(ObjectCharHashMap.this.toNonSentinel(ObjectCharHashMap.this.keys[this.position]), ObjectCharHashMap.this.values[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectCharHashMap.this.size();
            }
        }
    }

    private class KeysView
    extends AbstractLazyIterable<K> {
        private KeysView() {
        }

        public void each(Procedure<? super K> procedure) {
            ObjectCharHashMap.this.forEachKey(procedure);
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super K> objectCharProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectCharHashMap.this.keys.length; ++i) {
                if (!ObjectCharHashMap.isNonSentinel(ObjectCharHashMap.this.keys[i])) continue;
                objectCharProcedure.value(ObjectCharHashMap.this.toNonSentinel(ObjectCharHashMap.this.keys[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super K, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectCharHashMap.this.keys.length; ++i) {
                if (!ObjectCharHashMap.isNonSentinel(ObjectCharHashMap.this.keys[i])) continue;
                procedure.value(ObjectCharHashMap.this.toNonSentinel(ObjectCharHashMap.this.keys[i]), parameter);
            }
        }

        public Iterator<K> iterator() {
            return new InternalKeysViewIterator();
        }

        public class InternalKeysViewIterator
        implements Iterator<K> {
            private int count;
            private int position;

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectCharHashMap.this.keys;
                while (!ObjectCharHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                Object result = ObjectCharHashMap.this.toNonSentinel(ObjectCharHashMap.this.keys[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectCharHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    implements MutableCharCollection {
        private ValuesCollection() {
        }

        public int size() {
            return ObjectCharHashMap.this.size();
        }

        public boolean isEmpty() {
            return ObjectCharHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ObjectCharHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                for (int i = 0; i < ObjectCharHashMap.this.keys.length; ++i) {
                    Object key = ObjectCharHashMap.this.keys[i];
                    if (!ObjectCharHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ObjectCharHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean add(char element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(char ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(CharIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(char item) {
            int oldSize = ObjectCharHashMap.this.size();
            for (int i = 0; i < ObjectCharHashMap.this.keys.length; ++i) {
                if (!ObjectCharHashMap.isNonSentinel(ObjectCharHashMap.this.keys[i]) || item != ObjectCharHashMap.this.values[i]) continue;
                ObjectCharHashMap.this.removeKey(ObjectCharHashMap.this.keys[i]);
            }
            return oldSize != ObjectCharHashMap.this.size();
        }

        public boolean removeAll(CharIterable source) {
            int oldSize = ObjectCharHashMap.this.size();
            CharIterator iterator = source.charIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != ObjectCharHashMap.this.size();
        }

        public boolean removeAll(char ... source) {
            int oldSize = ObjectCharHashMap.this.size();
            for (char item : source) {
                this.remove(item);
            }
            return oldSize != ObjectCharHashMap.this.size();
        }

        public boolean retainAll(CharIterable source) {
            int oldSize = ObjectCharHashMap.this.size();
            Object sourceSet = source instanceof CharSet ? (CharSet)source : source.toSet();
            MutableObjectCharMap retained = ObjectCharHashMap.this.select((arg_0, arg_1) -> ValuesCollection.lambda$retainAll$b3a968f5$1((CharSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                ObjectCharHashMap.access$302(ObjectCharHashMap.this, ((ObjectCharHashMap)retained).keys);
                ObjectCharHashMap.access$502(ObjectCharHashMap.this, ((ObjectCharHashMap)retained).values);
                ObjectCharHashMap.this.occupiedWithData = ((ObjectCharHashMap)retained).occupiedWithData;
                ObjectCharHashMap.this.occupiedWithSentinels = ((ObjectCharHashMap)retained).occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(char ... source) {
            return this.retainAll(CharHashSet.newSetWith(source));
        }

        public void clear() {
            ObjectCharHashMap.this.clear();
        }

        public MutableCharCollection with(char element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableCharCollection without(char element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableCharCollection withAll(CharIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableCharCollection withoutAll(CharIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableCharCollection asUnmodifiable() {
            return UnmodifiableCharCollection.of(this);
        }

        public MutableCharCollection asSynchronized() {
            return SynchronizedCharCollection.of(this);
        }

        public ImmutableCharCollection toImmutable() {
            return CharLists.immutable.withAll((CharIterable)this);
        }

        public MutableCharIterator charIterator() {
            return ObjectCharHashMap.this.charIterator();
        }

        public char[] toArray() {
            return ObjectCharHashMap.this.toArray();
        }

        public boolean contains(char value) {
            return ObjectCharHashMap.this.containsValue(value);
        }

        public boolean containsAll(char ... source) {
            return ObjectCharHashMap.this.containsAll(source);
        }

        public boolean containsAll(CharIterable source) {
            return ObjectCharHashMap.this.containsAll(source);
        }

        public void forEach(CharProcedure procedure) {
            this.each(procedure);
        }

        public void each(CharProcedure procedure) {
            ObjectCharHashMap.this.forEach(procedure);
        }

        public MutableCharCollection select(CharPredicate predicate) {
            return ObjectCharHashMap.this.select(predicate);
        }

        public MutableCharCollection reject(CharPredicate predicate) {
            return ObjectCharHashMap.this.reject(predicate);
        }

        public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
            return ObjectCharHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
            return ObjectCharHashMap.this.injectInto(injectedValue, function);
        }

        public RichIterable<CharIterable> chunk(int size) {
            return ObjectCharHashMap.this.chunk(size);
        }

        public char detectIfNone(CharPredicate predicate, char ifNone) {
            return ObjectCharHashMap.this.detectIfNone(predicate, ifNone);
        }

        public int count(CharPredicate predicate) {
            return ObjectCharHashMap.this.count(predicate);
        }

        public boolean anySatisfy(CharPredicate predicate) {
            return ObjectCharHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(CharPredicate predicate) {
            return ObjectCharHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(CharPredicate predicate) {
            return ObjectCharHashMap.this.noneSatisfy(predicate);
        }

        public MutableCharList toList() {
            return ObjectCharHashMap.this.toList();
        }

        public MutableCharSet toSet() {
            return ObjectCharHashMap.this.toSet();
        }

        public MutableCharBag toBag() {
            return ObjectCharHashMap.this.toBag();
        }

        public LazyCharIterable asLazy() {
            return new LazyCharIterableAdapter((CharIterable)this);
        }

        public char[] toSortedArray() {
            return ObjectCharHashMap.this.toSortedArray();
        }

        public MutableCharList toSortedList() {
            return ObjectCharHashMap.this.toSortedList();
        }

        public long sum() {
            return ObjectCharHashMap.this.sum();
        }

        public char max() {
            return ObjectCharHashMap.this.max();
        }

        public char maxIfEmpty(char defaultValue) {
            return ObjectCharHashMap.this.maxIfEmpty(defaultValue);
        }

        public char min() {
            return ObjectCharHashMap.this.min();
        }

        public char minIfEmpty(char defaultValue) {
            return ObjectCharHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return ObjectCharHashMap.this.average();
        }

        public double median() {
            return ObjectCharHashMap.this.median();
        }

        public MutableCharCollection newEmpty() {
            return new CharHashBag();
        }

        private static /* synthetic */ boolean lambda$retainAll$b3a968f5$1(CharSet sourceSet, Object object, char value) {
            return sourceSet.contains(value);
        }
    }

    private class KeySetIterator
    implements Iterator<K> {
        private int count;
        private int position;
        private K currentKey;
        private boolean isCurrentKeySet;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ObjectCharHashMap.this.size();
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Object[] keys = ObjectCharHashMap.this.keys;
            while (!ObjectCharHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.currentKey = ObjectCharHashMap.this.keys[this.position];
            this.isCurrentKeySet = true;
            ++this.position;
            return ObjectCharHashMap.this.toNonSentinel(this.currentKey);
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (ObjectCharHashMap.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                ObjectCharHashMap.this.removeKeyAtIndex(ObjectCharHashMap.this.toNonSentinel(this.currentKey), index);
            } else {
                ObjectCharHashMap.this.removeKey(this.currentKey);
            }
        }
    }

    private class KeySet
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public boolean equals(Object obj) {
            Set other;
            if (obj instanceof Set && (other = (Set)obj).size() == this.size()) {
                return this.containsAll(other);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            Object[] table = ObjectCharHashMap.this.keys;
            for (int i = 0; i < table.length; ++i) {
                Object key = table[i];
                if (!ObjectCharHashMap.isNonSentinel(key)) continue;
                Object nonSentinelKey = ObjectCharHashMap.this.toNonSentinel(key);
                hashCode += nonSentinelKey == null ? 0 : nonSentinelKey.hashCode();
            }
            return hashCode;
        }

        @Override
        public int size() {
            return ObjectCharHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectCharHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ObjectCharHashMap.this.containsKey(o);
        }

        @Override
        public Object[] toArray() {
            int size = ObjectCharHashMap.this.size();
            Object[] result = new Object[size];
            this.copyKeys(result);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] result) {
            int size = ObjectCharHashMap.this.size();
            if (result.length < size) {
                result = (Object[])Array.newInstance(result.getClass().getComponentType(), size);
            }
            this.copyKeys(result);
            if (size < result.length) {
                result[size] = null;
            }
            return result;
        }

        @Override
        public boolean add(K key) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(Object key) {
            int oldSize = ObjectCharHashMap.this.size();
            ObjectCharHashMap.this.removeKey(key);
            return oldSize != ObjectCharHashMap.this.size();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object aCollection : collection) {
                if (ObjectCharHashMap.this.containsKey(aCollection)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int oldSize = ObjectCharHashMap.this.size();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (collection.contains(next)) continue;
                iterator.remove();
            }
            return oldSize != ObjectCharHashMap.this.size();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int oldSize = ObjectCharHashMap.this.size();
            for (Object object : collection) {
                ObjectCharHashMap.this.removeKey(object);
            }
            return oldSize != ObjectCharHashMap.this.size();
        }

        @Override
        public void clear() {
            ObjectCharHashMap.this.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        private void copyKeys(Object[] result) {
            int count = 0;
            for (int i = 0; i < ObjectCharHashMap.this.keys.length; ++i) {
                Object key = ObjectCharHashMap.this.keys[i];
                if (!ObjectCharHashMap.isNonSentinel(key)) continue;
                result[count++] = ObjectCharHashMap.this.keys[i];
            }
        }
    }

    private class InternalCharIterator
    implements MutableCharIterator {
        private int count;
        private int position;

        private InternalCharIterator() {
        }

        public boolean hasNext() {
            return this.count != ObjectCharHashMap.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] keys = ObjectCharHashMap.this.keys;
            while (!ObjectCharHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            char result = ObjectCharHashMap.this.values[this.position];
            ++this.count;
            ++this.position;
            return result;
        }

        public void remove() {
            if (this.position == 0 || !ObjectCharHashMap.isNonSentinel(ObjectCharHashMap.this.keys[this.position - 1])) {
                throw new IllegalStateException();
            }
            ObjectCharHashMap.this.remove(ObjectCharHashMap.this.keys[this.position - 1]);
            --this.count;
        }
    }
}

