/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.factory.list.primitive.MutableCharListFactory;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.impl.factory.primitive.CharLists;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableCharListFactoryImpl implements MutableCharListFactory
{
    INSTANCE;


    public MutableCharList empty() {
        return new CharArrayList();
    }

    public MutableCharList of() {
        return this.empty();
    }

    public MutableCharList with() {
        return this.empty();
    }

    public MutableCharList of(char ... items) {
        return this.with(items);
    }

    public MutableCharList with(char ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return CharArrayList.newListWith(items);
    }

    public MutableCharList ofAll(CharIterable items) {
        return this.withAll(items);
    }

    public MutableCharList withAll(CharIterable items) {
        return CharArrayList.newList(items);
    }

    public MutableCharList ofAll(Iterable<Character> iterable) {
        return this.withAll(iterable);
    }

    public MutableCharList withAll(Iterable<Character> iterable) {
        return Iterate.collectChar(iterable, Character::charValue, CharLists.mutable.empty());
    }
}

