/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.collections.impl.test.Verify;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerializeTestHelper {
    private SerializeTestHelper() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> T serializeDeserialize(T sourceObject) {
        byte[] pileOfBytes = SerializeTestHelper.serialize(sourceObject);
        return (T)SerializeTestHelper.deserialize(pileOfBytes);
    }

    public static <T> byte[] serialize(T sourceObject) {
        ByteArrayOutputStream baos = SerializeTestHelper.getByteArrayOutputStream(sourceObject);
        return baos.toByteArray();
    }

    public static <T> ByteArrayOutputStream getByteArrayOutputStream(T sourceObject) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            SerializeTestHelper.writeObjectToStream(sourceObject, baos);
        }
        catch (IOException e) {
            Verify.fail("Failed to marshal an object", e);
        }
        return baos;
    }

    private static <T> void writeObjectToStream(Object sourceObject, ByteArrayOutputStream baos) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(baos);
        try {
            objectOutputStream.writeObject(sourceObject);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        finally {
            objectOutputStream.close();
        }
    }

    private static Object readOneObject(ByteArrayInputStream bais) throws IOException, ClassNotFoundException {
        ObjectInputStream objectStream = new ObjectInputStream(bais);
        try {
            Object object = objectStream.readObject();
            return object;
        }
        finally {
            objectStream.close();
        }
    }

    public static Object deserialize(byte[] pileOfBytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(pileOfBytes);
        try {
            return SerializeTestHelper.readOneObject(bais);
        }
        catch (ClassNotFoundException e) {
            Verify.fail("Failed to unmarshal an object", e);
        }
        catch (IOException e) {
            Verify.fail("Failed to unmarshal an object", e);
        }
        return null;
    }
}

