/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.list.primitive;

import java.util.Comparator;
import java.util.Random;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.comparator.primitive.IntComparator;
import org.eclipse.collections.api.block.function.primitive.IntIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.tuple.primitive.IntIntPair;
import org.eclipse.collections.api.tuple.primitive.IntObjectPair;

public interface MutableIntList
extends MutableIntCollection,
IntList {
    public void addAtIndex(int var1, int var2);

    public boolean addAllAtIndex(int var1, int ... var2);

    public boolean addAllAtIndex(int var1, IntIterable var2);

    public int removeAtIndex(int var1);

    public int set(int var1, int var2);

    default public void swap(int index1, int index2) {
        int value = this.get(index1);
        this.set(index1, this.get(index2));
        this.set(index2, value);
    }

    @Override
    public MutableIntList select(IntPredicate var1);

    @Override
    public MutableIntList reject(IntPredicate var1);

    @Override
    public MutableIntList with(int var1);

    @Override
    public MutableIntList without(int var1);

    @Override
    public MutableIntList withAll(IntIterable var1);

    @Override
    public MutableIntList withoutAll(IntIterable var1);

    @Override
    default public MutableIntList tap(IntProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public <V> MutableList<V> collect(IntToObjectFunction<? extends V> var1);

    default public <V> MutableList<V> collectWithIndex(IntIntToObjectFunction<? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((int each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.value(each, n);
        });
    }

    public MutableIntList reverseThis();

    @Override
    public MutableIntList toReversed();

    @Override
    public MutableIntList distinct();

    public MutableIntList sortThis();

    default public MutableIntList sortThis(IntComparator comparator) {
        throw new UnsupportedOperationException("sortThis(IntComparator comparator) is not supported on " + this.getClass());
    }

    default public <T> MutableIntList sortThisBy(IntToObjectFunction<T> function) {
        return this.sortThisBy(function, Comparator.naturalOrder());
    }

    default public <T> MutableIntList sortThisBy(IntToObjectFunction<T> function, Comparator<? super T> comparator) {
        return this.sortThis((i1, i2) -> comparator.compare((Object)function.valueOf(i1), (Object)function.valueOf(i2)));
    }

    default public MutableIntList shuffleThis() {
        return this.shuffleThis(new Random());
    }

    default public MutableIntList shuffleThis(Random rnd) {
        for (int j = this.size() - 1; j > 0; --j) {
            int k = rnd.nextInt(j + 1);
            int selected = this.get(j);
            this.set(j, this.get(k));
            this.set(k, selected);
        }
        return this;
    }

    @Override
    public MutableIntList asUnmodifiable();

    @Override
    public MutableIntList asSynchronized();

    @Override
    public ImmutableIntList toImmutable();

    @Override
    public MutableIntList subList(int var1, int var2);

    default public MutableList<IntIntPair> zipInt(IntIterable iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    default public <T> MutableList<IntObjectPair<T>> zip(Iterable<T> list) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    @Override
    default public MutableIntList newEmpty() {
        throw new UnsupportedOperationException("Implement in concrete classes.");
    }
}

