/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.languageserver;

import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.che.api.core.jsonrpc.commons.RequestHandlerConfigurator;
import org.eclipse.che.api.core.jsonrpc.commons.RequestTransmitter;
import org.eclipse.che.api.core.notification.EventService;
import org.eclipse.che.api.core.notification.EventSubscriber;
import org.eclipse.che.api.project.server.notification.ProjectUpdatedEvent;

@Singleton
public class JavaLanguageServerJsonRpcMessenger {
    private static final String EVENT_JDT_PROJECT_UPDATED = "event:jdt:project-updated";
    private static final String EVENT_JDT_SUBSCRIBE = "event:jdt:subscribe";
    private static final String EVENT_JDT_UNSUBSCRIBE = "event:jdt:unsubscribe";
    private final EventService eventService;
    private final RequestTransmitter transmitter;
    private final EventSubscriber<ProjectUpdatedEvent> projectUpdatedEventSubscriber;
    private final Set<String> endpointIds = Sets.newConcurrentHashSet();

    @Inject
    public JavaLanguageServerJsonRpcMessenger(EventService eventService, RequestTransmitter transmitter) {
        this.eventService = eventService;
        this.transmitter = transmitter;
        this.projectUpdatedEventSubscriber = this::onEvent;
    }

    @PostConstruct
    private void subscribe() {
        this.eventService.subscribe(this.projectUpdatedEventSubscriber, ProjectUpdatedEvent.class);
    }

    @PreDestroy
    private void unsubscribe() {
        this.eventService.unsubscribe(this.projectUpdatedEventSubscriber, ProjectUpdatedEvent.class);
    }

    private void onEvent(ProjectUpdatedEvent event) {
        this.endpointIds.forEach(it -> this.transmitter.newRequest().endpointId(it).methodName(EVENT_JDT_PROJECT_UPDATED).paramsAsDto((Object)event.getProjectPath()).sendAndSkipResult());
    }

    @Inject
    private void configureSubscribeHandler(RequestHandlerConfigurator configurator) {
        configurator.newConfiguration().methodName(EVENT_JDT_SUBSCRIBE).noParams().noResult().withConsumer(this.endpointIds::add);
    }

    @Inject
    private void configureUnSubscribeHandler(RequestHandlerConfigurator configurator) {
        configurator.newConfiguration().methodName(EVENT_JDT_UNSUBSCRIBE).noParams().noResult().withConsumer(this.endpointIds::remove);
    }
}

