/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DataStreamReader;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.SerializationUtil;
import org.eclipse.californium.scandium.auth.PrincipalSerializer;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.RecordSizeLimitExtension;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.util.SecretSerializationUtil;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerName;
import org.eclipse.californium.scandium.util.ServerNames;

public final class DTLSSession
implements Destroyable {
    private static final int MAX_FRAGMENT_LENGTH_DEFAULT = 16384;
    private SessionId sessionIdentifier = SessionId.emptySessionId();
    private ProtocolVersion protocolVersion = ProtocolVersion.VERSION_DTLS_1_2;
    private Principal peerIdentity;
    private Integer recordSizeLimit;
    private int maxFragmentLength = 16384;
    private CipherSuite cipherSuite = CipherSuite.TLS_NULL_WITH_NULL_NULL;
    private SignatureAndHashAlgorithm signatureAndHashAlgorithm;
    private XECDHECryptography.SupportedGroup ecGroup;
    private CompressionMethod compressionMethod = CompressionMethod.NULL;
    private boolean extendedMasterSecret;
    private boolean secureRenegotiation;
    private SecretKey masterSecret = null;
    private CertificateType sendCertificateType = CertificateType.X_509;
    private CertificateType receiveCertificateType = CertificateType.X_509;
    private long creationTime;
    private String hostName;
    private ServerNames serverNames;
    private boolean peerSupportsSni;
    private static final int VERSION = 3;
    private static final int VERSION_DEPRECATED = 2;
    private static final SerializationUtil.SupportedVersions VERSIONS = new SerializationUtil.SupportedVersions(3, 2);

    public DTLSSession() {
        this.creationTime = System.currentTimeMillis();
    }

    public DTLSSession(String hostname) {
        this.creationTime = System.currentTimeMillis();
        this.setHostName(hostname);
    }

    public DTLSSession(DTLSSession session) {
        this.set(session);
    }

    public void set(DTLSSession session) {
        this.creationTime = session.getCreationTime();
        this.sessionIdentifier = session.getSessionIdentifier();
        this.protocolVersion = session.getProtocolVersion();
        this.masterSecret = session.getMasterSecret();
        this.peerIdentity = session.getPeerIdentity();
        this.cipherSuite = session.getCipherSuite();
        this.compressionMethod = session.getCompressionMethod();
        this.signatureAndHashAlgorithm = session.getSignatureAndHashAlgorithm();
        this.ecGroup = session.getEcGroup();
        this.extendedMasterSecret = session.useExtendedMasterSecret();
        this.secureRenegotiation = session.useSecureRengotiation();
        this.sendCertificateType = session.sendCertificateType();
        this.receiveCertificateType = session.receiveCertificateType();
        this.recordSizeLimit = session.getRecordSizeLimit();
        this.maxFragmentLength = session.getMaxFragmentLength();
        this.setServerNames(session.getServerNames());
    }

    @Override
    public void destroy() throws DestroyFailedException {
        SecretUtil.destroy(this.masterSecret);
        this.masterSecret = null;
        this.extendedMasterSecret = false;
        this.secureRenegotiation = false;
        this.cipherSuite = CipherSuite.TLS_NULL_WITH_NULL_NULL;
        this.compressionMethod = CompressionMethod.NULL;
        this.signatureAndHashAlgorithm = null;
        this.ecGroup = null;
        this.peerIdentity = null;
        this.sendCertificateType = CertificateType.X_509;
        this.receiveCertificateType = CertificateType.X_509;
    }

    @Override
    public boolean isDestroyed() {
        return SecretUtil.isDestroyed(this.masterSecret);
    }

    public SessionId getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    void setSessionIdentifier(SessionId sessionIdentifier) {
        if (sessionIdentifier == null) {
            throw new NullPointerException("session identifier must not be null!");
        }
        if (sessionIdentifier.equals(this.sessionIdentifier) && !sessionIdentifier.isEmpty()) {
            throw new IllegalArgumentException("no new session identifier?");
        }
        SecretUtil.destroy(this.masterSecret);
        this.masterSecret = null;
        this.sessionIdentifier = sessionIdentifier;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    void setProtocolVersion(ProtocolVersion protocolVersion) {
        if (!ProtocolVersion.VERSION_DTLS_1_2.equals(protocolVersion)) {
            throw new IllegalArgumentException(protocolVersion + " is not supported!");
        }
        this.protocolVersion = ProtocolVersion.VERSION_DTLS_1_2;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostname) {
        this.serverNames = null;
        this.hostName = hostname;
        if (hostname != null) {
            this.serverNames = ServerNames.newInstance(ServerName.from(ServerName.NameType.HOST_NAME, hostname.getBytes(ServerName.CHARSET)));
        }
    }

    public ServerNames getServerNames() {
        return this.serverNames;
    }

    public void setServerNames(ServerNames serverNames) {
        ServerName serverName;
        this.hostName = null;
        this.serverNames = serverNames;
        if (serverNames != null && (serverName = serverNames.getServerName(ServerName.NameType.HOST_NAME)) != null) {
            this.hostName = serverName.getNameAsString();
        }
    }

    public boolean isSniSupported() {
        return this.peerSupportsSni;
    }

    void setSniSupported(boolean flag) {
        this.peerSupportsSni = flag;
    }

    public void addEndpointContext(MapBasedEndpointContext.Attributes attributes) {
        Bytes id = this.sessionIdentifier.isEmpty() ? new Bytes(("TIME:" + Long.toString(this.creationTime)).getBytes()) : this.sessionIdentifier;
        attributes.add(DtlsEndpointContext.KEY_SESSION_ID, id);
        attributes.add(DtlsEndpointContext.KEY_CIPHER, this.cipherSuite.name());
        if (this.extendedMasterSecret) {
            attributes.add(DtlsEndpointContext.KEY_EXTENDED_MASTER_SECRET, Boolean.TRUE);
        }
        if (this.secureRenegotiation) {
            attributes.add(DtlsEndpointContext.KEY_SECURE_RENEGOTIATION, Boolean.TRUE);
        }
    }

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public List<CipherSuite> getCipherSuitesForResumption() {
        if (this.secureRenegotiation) {
            return Arrays.asList(this.cipherSuite, CipherSuite.TLS_EMPTY_RENEGOTIATION_INFO_SCSV);
        }
        return Arrays.asList(this.cipherSuite);
    }

    void setCipherSuite(CipherSuite cipherSuite) {
        if (cipherSuite == null) {
            throw new NullPointerException("Negotiated cipher suite must not be null!");
        }
        if (!cipherSuite.isValidForNegotiation()) {
            throw new IllegalArgumentException("Negotiated cipher suite must be valid for negotiation!");
        }
        this.cipherSuite = cipherSuite;
    }

    public CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    void setCompressionMethod(CompressionMethod compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    final CipherSuite.KeyExchangeAlgorithm getKeyExchange() {
        if (this.cipherSuite == null) {
            throw new IllegalStateException("Cipher suite has not been set (yet)");
        }
        return this.cipherSuite.getKeyExchange();
    }

    public void setExtendedMasterSecret(boolean enable) {
        this.extendedMasterSecret = enable;
    }

    public boolean useExtendedMasterSecret() {
        return this.extendedMasterSecret;
    }

    public void setSecureRengotiation(boolean used) {
        this.secureRenegotiation = used;
    }

    public boolean useSecureRengotiation() {
        return this.secureRenegotiation;
    }

    SecretKey getMasterSecret() {
        return SecretUtil.create(this.masterSecret);
    }

    void setMasterSecret(SecretKey masterSecret) {
        if (this.masterSecret == null) {
            if (!this.sessionIdentifier.isEmpty()) {
                if (masterSecret == null) {
                    throw new NullPointerException("Master secret must not be null");
                }
                byte[] secret = masterSecret.getEncoded();
                Bytes.clear(secret);
                if (secret.length != PseudoRandomFunction.Label.MASTER_SECRET_LABEL.length()) {
                    throw new IllegalArgumentException(String.format("Master secret must consist of of exactly %d bytes but has %d bytes", PseudoRandomFunction.Label.MASTER_SECRET_LABEL.length(), secret.length));
                }
                this.masterSecret = SecretUtil.create(masterSecret);
            }
        } else {
            throw new IllegalStateException("master secret already available!");
        }
        this.creationTime = System.currentTimeMillis();
    }

    byte[] exportKeyMaterial(byte[] label, byte[] seed, int length) {
        return PseudoRandomFunction.doExporterPRF(this.cipherSuite.getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, label, seed, length);
    }

    public int getMaxCiphertextExpansion() {
        if (this.cipherSuite == null) {
            throw new IllegalStateException("Missing cipher suite.");
        }
        return this.cipherSuite.getMaxCiphertextExpansion();
    }

    void setMaxFragmentLength(int length) {
        if (length < 0 || length > 16384) {
            throw new IllegalArgumentException("Max. fragment length must be in range [0...16384]");
        }
        this.maxFragmentLength = length;
    }

    public int getMaxFragmentLength() {
        return this.maxFragmentLength;
    }

    void setRecordSizeLimit(int limit) {
        this.recordSizeLimit = RecordSizeLimitExtension.ensureInRange(limit);
    }

    public Integer getRecordSizeLimit() {
        return this.recordSizeLimit;
    }

    public int getEffectiveFragmentLimit() {
        if (this.recordSizeLimit != null) {
            return this.recordSizeLimit;
        }
        return this.maxFragmentLength;
    }

    CertificateType sendCertificateType() {
        return this.sendCertificateType;
    }

    void setSendCertificateType(CertificateType sendCertificateType) {
        this.sendCertificateType = sendCertificateType;
    }

    CertificateType receiveCertificateType() {
        return this.receiveCertificateType;
    }

    void setReceiveCertificateType(CertificateType receiveCertificateType) {
        this.receiveCertificateType = receiveCertificateType;
    }

    public SignatureAndHashAlgorithm getSignatureAndHashAlgorithm() {
        return this.signatureAndHashAlgorithm;
    }

    void setSignatureAndHashAlgorithm(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
    }

    public XECDHECryptography.SupportedGroup getEcGroup() {
        return this.ecGroup;
    }

    void setEcGroup(XECDHECryptography.SupportedGroup ecGroup) {
        this.ecGroup = ecGroup;
    }

    public Principal getPeerIdentity() {
        return this.peerIdentity;
    }

    void setPeerIdentity(Principal peerIdentity) {
        if (peerIdentity == null) {
            throw new NullPointerException("Peer identity must not be null");
        }
        this.peerIdentity = peerIdentity;
    }

    public int hashCode() {
        return this.sessionIdentifier == null ? (int)this.creationTime : this.sessionIdentifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DTLSSession other = (DTLSSession)obj;
        if (!SecretUtil.equals(this.masterSecret, other.masterSecret)) {
            return false;
        }
        if (!Bytes.equals(this.sessionIdentifier, other.sessionIdentifier)) {
            return false;
        }
        if (this.cipherSuite != other.cipherSuite) {
            return false;
        }
        if (this.compressionMethod != other.compressionMethod) {
            return false;
        }
        if (this.extendedMasterSecret != other.extendedMasterSecret) {
            return false;
        }
        if (this.secureRenegotiation != other.secureRenegotiation) {
            return false;
        }
        if (this.peerSupportsSni != other.peerSupportsSni) {
            return false;
        }
        if (this.sendCertificateType != other.sendCertificateType) {
            return false;
        }
        if (this.receiveCertificateType != other.receiveCertificateType) {
            return false;
        }
        if (this.ecGroup != other.ecGroup) {
            return false;
        }
        if (this.creationTime != other.creationTime) {
            return false;
        }
        if (!Objects.equals(this.signatureAndHashAlgorithm, other.signatureAndHashAlgorithm)) {
            return false;
        }
        if (!Objects.equals(this.serverNames, other.serverNames)) {
            return false;
        }
        if (!Objects.equals(this.recordSizeLimit, other.recordSizeLimit)) {
            return false;
        }
        if (!Objects.equals(this.peerIdentity, other.peerIdentity)) {
            return false;
        }
        return Objects.equals(this.protocolVersion, other.protocolVersion);
    }

    public void writeTo(DatagramWriter writer) {
        int position = SerializationUtil.writeStartItem(writer, 3, 16);
        writer.writeLong(this.creationTime, 64);
        if (this.serverNames == null) {
            writer.write(0, 8);
        } else {
            writer.write(1, 8);
            this.serverNames.encode(writer);
        }
        if (this.recordSizeLimit != null) {
            writer.write(this.recordSizeLimit, 16);
        } else {
            writer.write(65535, 16);
        }
        writer.write(this.maxFragmentLength, 16);
        writer.writeVarBytes(this.sessionIdentifier, 8);
        writer.write(this.cipherSuite.getCode(), 16);
        writer.write(this.compressionMethod.getCode(), 8);
        writer.write(this.sendCertificateType.getCode(), 8);
        writer.write(this.receiveCertificateType.getCode(), 8);
        writer.write(this.secureRenegotiation ? 1 : 0, 8);
        writer.write(this.extendedMasterSecret ? 1 : 0, 8);
        SecretSerializationUtil.write(writer, this.masterSecret);
        if (this.signatureAndHashAlgorithm == null) {
            writer.write(0, 8);
        } else {
            writer.write(1, 8);
            writer.write(this.signatureAndHashAlgorithm.getHash().getCode(), 8);
            writer.write(this.signatureAndHashAlgorithm.getSignature().getCode(), 8);
        }
        if (this.ecGroup == null) {
            writer.write(0, 8);
        } else {
            writer.write(1, 8);
            writer.write(this.ecGroup.getId(), 16);
        }
        if (this.peerIdentity == null) {
            writer.write(0, 8);
        } else {
            writer.write(1, 8);
            PrincipalSerializer.serialize(this.peerIdentity, writer);
        }
        SerializationUtil.writeFinishedItem(writer, position, 16);
    }

    public static DTLSSession fromReader(DatagramReader reader) {
        SerializationUtil.SupportedVersionsMatcher matcher = VERSIONS.matcher();
        int length = SerializationUtil.readStartItem((DataStreamReader)reader, matcher, 16);
        if (0 < length) {
            DatagramReader rangeReader = reader.createRangeReader(length);
            return new DTLSSession(matcher.getReadVersion(), rangeReader);
        }
        return null;
    }

    private DTLSSession(int version, DatagramReader reader) {
        int size;
        this.creationTime = reader.readLong(64);
        if (reader.readNextByte() == 1) {
            this.serverNames = ServerNames.newInstance();
            try {
                this.serverNames.decode(reader);
                ServerName serverName = this.serverNames.getServerName(ServerName.NameType.HOST_NAME);
                if (serverName != null) {
                    this.hostName = serverName.getNameAsString();
                }
            }
            catch (IllegalArgumentException e) {
                this.serverNames = null;
            }
        }
        if ((size = reader.read(16)) < 65535) {
            this.recordSizeLimit = size;
        }
        this.maxFragmentLength = size = reader.read(16);
        byte[] data = reader.readVarBytes(8);
        if (data != null) {
            this.sessionIdentifier = new SessionId(data);
        }
        int code = reader.read(16);
        this.cipherSuite = CipherSuite.getTypeByCode(code);
        if (this.cipherSuite == null) {
            throw new IllegalArgumentException("unknown cipher suite 0x" + Integer.toHexString(code) + "!");
        }
        code = reader.read(8);
        this.compressionMethod = CompressionMethod.getMethodByCode(code);
        if (this.compressionMethod == null) {
            throw new IllegalArgumentException("unknown compression method 0x" + Integer.toHexString(code) + "!");
        }
        code = reader.read(8);
        this.sendCertificateType = CertificateType.getTypeFromCode(code);
        if (this.sendCertificateType == null) {
            throw new IllegalArgumentException("unknown send certificate type 0x" + Integer.toHexString(code) + "!");
        }
        code = reader.read(8);
        this.receiveCertificateType = CertificateType.getTypeFromCode(code);
        if (this.receiveCertificateType == null) {
            throw new IllegalArgumentException("unknown send certificate type 0x" + Integer.toHexString(code) + "!");
        }
        if (version > 2) {
            this.secureRenegotiation = reader.read(8) == 1;
        }
        this.extendedMasterSecret = reader.read(8) == 1;
        this.masterSecret = SecretSerializationUtil.readSecretKey(reader);
        if (reader.readNextByte() == 1) {
            int hashId = reader.read(8);
            int signatureId = reader.read(8);
            this.signatureAndHashAlgorithm = new SignatureAndHashAlgorithm(hashId, signatureId);
        }
        if (reader.readNextByte() == 1) {
            int groupId = reader.read(16);
            this.ecGroup = XECDHECryptography.SupportedGroup.fromId(groupId);
            if (this.ecGroup == null) {
                throw new IllegalArgumentException("unknown ec-group 0x" + Integer.toHexString(groupId) + "!");
            }
        }
        if (reader.readNextByte() == 1) {
            try {
                this.peerIdentity = PrincipalSerializer.deserialize(reader);
            }
            catch (GeneralSecurityException e) {
                throw new IllegalArgumentException("principal failure", e);
            }
        }
        reader.assertFinished("dtls-session");
    }
}

