/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests;

import java.net.InetSocketAddress;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.EndpointObserver;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.util.CounterStatisticManager;
import org.eclipse.californium.elements.util.SimpleCounterStatistic;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.DtlsHealth;
import org.eclipse.californium.unixhealth.NetSocketHealthLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointNetSocketObserver
implements EndpointObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointNetSocketObserver.class);
    private final NetSocketHealthLogger netSocketStatistic;

    public EndpointNetSocketObserver(NetSocketHealthLogger netSocketStatistic) {
        this.netSocketStatistic = netSocketStatistic;
    }

    @Override
    public void stopped(Endpoint endpoint) {
        InetSocketAddress address = this.getAddress(endpoint);
        if (address != null) {
            this.netSocketStatistic.remove(address);
            LOGGER.debug("removed {}", (Object)address);
        }
    }

    @Override
    public void started(Endpoint endpoint) {
        InetSocketAddress address = this.getAddress(endpoint);
        if (address != null) {
            if (this.netSocketStatistic.add(address, this.getExternalStatistic(endpoint))) {
                LOGGER.debug("added {}", (Object)address);
            } else {
                LOGGER.debug("enabled {}", (Object)address);
            }
        }
    }

    @Override
    public void destroyed(Endpoint endpoint) {
        InetSocketAddress address = this.getAddress(endpoint);
        if (address != null) {
            this.netSocketStatistic.remove(address);
            LOGGER.debug("removed {}", (Object)address);
        }
    }

    public NetSocketHealthLogger getNetSocketHealth() {
        return this.netSocketStatistic;
    }

    protected SimpleCounterStatistic getExternalStatistic(Endpoint endpoint) {
        CounterStatisticManager dtlsStatisticManager = EndpointNetSocketObserver.getDtlsStatisticManager(endpoint);
        return dtlsStatisticManager != null ? dtlsStatisticManager.getByKey("dropped udp messages") : null;
    }

    protected InetSocketAddress getAddress(Endpoint endpoint) {
        String scheme = endpoint.getUri().getScheme();
        if (CoAP.isUdpScheme(scheme)) {
            return endpoint.getAddress();
        }
        return null;
    }

    public static CounterStatisticManager getDtlsStatisticManager(Endpoint endpoint) {
        DtlsHealth healthHandler;
        Connector connector;
        if (endpoint instanceof CoapEndpoint && (connector = ((CoapEndpoint)endpoint).getConnector()) instanceof DTLSConnector && (healthHandler = ((DTLSConnector)connector).getHealthHandler()) instanceof CounterStatisticManager) {
            return (CounterStatisticManager)((Object)healthHandler);
        }
        return null;
    }
}

