/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.serialization;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.CoAPMessageFormatException;
import org.eclipse.californium.core.coap.CoAPOptionException;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.MessageFormatException;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionNumberRegistry;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.option.LegacyMapBasedOptionRegistry;
import org.eclipse.californium.core.coap.option.OptionDefinition;
import org.eclipse.californium.core.coap.option.OptionRegistry;
import org.eclipse.californium.core.coap.option.StandardOptionRegistry;
import org.eclipse.californium.core.network.serialization.MessageHeader;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;

public abstract class DataParser {
    protected final OptionRegistry optionRegistry;

    protected DataParser() {
        this.optionRegistry = StandardOptionRegistry.getDefaultOptionRegistry();
    }

    @Deprecated
    protected DataParser(int[] criticalCustomOptions) {
        if (criticalCustomOptions == null) {
            criticalCustomOptions = OptionNumberRegistry.getCriticalCustomOptions();
        }
        this.optionRegistry = new LegacyMapBasedOptionRegistry(true, criticalCustomOptions, StandardOptionRegistry.getDefaultOptionRegistry());
    }

    protected DataParser(OptionRegistry optionRegistry) {
        if (optionRegistry == null) {
            optionRegistry = StandardOptionRegistry.getDefaultOptionRegistry();
        }
        this.optionRegistry = optionRegistry;
    }

    public final Message parseMessage(RawData raw) {
        if (raw == null) {
            throw new NullPointerException("raw-data must not be null!");
        }
        if (raw.getConnectorAddress() == null) {
            throw new NullPointerException("raw-data connector's address must not be null!");
        }
        Message message = this.parseMessage(raw.getBytes());
        message.setSourceContext(raw.getEndpointContext());
        if (message instanceof Request) {
            ((Request)message).setLocalAddress(raw.getConnectorAddress(), raw.isMulticast());
        } else {
            message.setLocalAddress(raw.getConnectorAddress());
        }
        message.setNanoTimestamp(raw.getReceiveNanoTimestamp());
        return message;
    }

    public final Message parseMessage(byte[] msg) {
        String errorMsg = "illegal message code";
        DatagramReader reader = new DatagramReader(msg);
        MessageHeader header = this.parseHeader(reader);
        try {
            Message message = null;
            if (CoAP.isRequest(header.getCode())) {
                message = this.parseMessage(reader, header, new Request(CoAP.Code.valueOf(header.getCode())));
            } else if (CoAP.isResponse(header.getCode())) {
                message = this.parseMessage(reader, header, new Response(CoAP.ResponseCode.valueOf(header.getCode())));
            } else if (CoAP.isEmptyMessage(header.getCode())) {
                message = this.parseMessage(reader, header, new EmptyMessage(header.getType()));
            }
            if (message != null) {
                message.setBytes(msg);
                return message;
            }
        }
        catch (CoAPMessageFormatException e) {
            throw e;
        }
        catch (MessageFormatException e) {
            errorMsg = e.getMessage();
        }
        throw new CoAPMessageFormatException(errorMsg, header.getToken(), header.getMID(), header.getCode(), CoAP.Type.CON == header.getType());
    }

    protected Message parseMessage(DatagramReader reader, MessageHeader header, Message target) {
        target.setMID(header.getMID());
        target.setType(header.getType());
        target.setToken(header.getToken());
        this.parseOptionsAndPayload(reader, target);
        return target;
    }

    protected abstract MessageHeader parseHeader(DatagramReader var1);

    protected void assertValidOptions(OptionSet options) {
    }

    @Deprecated
    protected boolean isCiriticalCustomOption(int optionNumber) {
        return false;
    }

    public void parseOptionsAndPayload(DatagramReader reader, Message message) {
        if (reader == null) {
            throw new NullPointerException("reader must not be null!");
        }
        if (message == null) {
            throw new NullPointerException("message must not be null!");
        }
        int code = message.getRawCode();
        int currentOptionNumber = 0;
        byte nextByte = 0;
        OptionSet optionSet = message.getOptions();
        while (reader.bytesAvailable() && (nextByte = reader.readNextByte()) != -1) {
            try {
                int optionDeltaNibble = (0xF0 & nextByte) >> 4;
                currentOptionNumber += DataParser.determineValueFromNibble(reader, optionDeltaNibble);
                int optionLengthNibble = 0xF & nextByte;
                int optionLength = DataParser.determineValueFromNibble(reader, optionLengthNibble);
                if (reader.bytesAvailable(optionLength)) {
                    byte[] value = reader.readBytes(optionLength);
                    Option option = this.createOption(code, currentOptionNumber, value);
                    if (option == null) continue;
                    optionSet.addOption(option);
                    continue;
                }
                String msg = String.format("Message contains option of length %d with only fewer bytes left in the message", optionLength);
                throw new IllegalArgumentException(msg);
            }
            catch (CoAPOptionException ex) {
                throw new CoAPMessageFormatException(ex.getMessage(), message.getToken(), message.getMID(), message.getRawCode(), message.isConfirmable(), ex.getErrorCode());
            }
            catch (IllegalArgumentException ex) {
                throw new CoAPMessageFormatException(ex.getMessage(), message.getToken(), message.getMID(), message.getRawCode(), message.isConfirmable());
            }
        }
        try {
            this.assertValidOptions(message.getOptions());
        }
        catch (IllegalArgumentException ex) {
            throw new CoAPMessageFormatException(ex.getMessage(), message.getToken(), message.getMID(), message.getRawCode(), message.isConfirmable(), CoAP.ResponseCode.BAD_REQUEST);
        }
        if (nextByte == -1) {
            if (!reader.bytesAvailable()) {
                throw new CoAPMessageFormatException("Found payload marker (0xFF) but message contains no payload", message.getToken(), message.getMID(), message.getRawCode(), message.isConfirmable());
            }
            if (!message.isIntendedPayload()) {
                message.setUnintendedPayload();
            }
            message.setPayload(reader.readBytesLeft());
            message.assertPayloadMatchsBlocksize();
        } else {
            message.setPayload(Bytes.EMPTY);
        }
    }

    public Option createOption(int code, int optionNumber, byte[] value) {
        OptionDefinition definition = this.optionRegistry.getDefinitionByNumber(code, optionNumber);
        if (definition != null) {
            return definition.create(value);
        }
        if (OptionNumberRegistry.isCritical(optionNumber)) {
            throw new IllegalArgumentException("Unknown critical option " + optionNumber + " is not supported!");
        }
        return null;
    }

    private static int determineValueFromNibble(DatagramReader reader, int delta) {
        if (delta <= 12) {
            return delta;
        }
        if (delta == 13) {
            return reader.read(8) + 13;
        }
        if (delta == 14) {
            return reader.read(16) + 269;
        }
        throw new IllegalArgumentException("Message contains illegal option delta/length: " + delta);
    }
}

