/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemResourceMonitors {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemResourceMonitors.class);
    private final List<SystemResourceJob> resources = new ArrayList<SystemResourceJob>();
    private final ScheduledExecutorService scheduler;
    private final AtomicBoolean running = new AtomicBoolean();

    public SystemResourceMonitors(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    public SystemResourceJob addMonitor(String name, long interval, TimeUnit unit, SystemResourceMonitor resource) {
        SystemResourceJob job = new SystemResourceJob(this.scheduler, name, interval, unit, resource);
        this.resources.add(job);
        if (this.running.get()) {
            job.start();
        }
        return job;
    }

    public boolean remove(SystemResourceJob job) {
        if (this.resources.remove(job)) {
            job.stop();
            return true;
        }
        return false;
    }

    public boolean remove(String name) {
        boolean removed = false;
        Iterator<SystemResourceJob> iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            SystemResourceJob job = iterator.next();
            if (name != null && !name.equals(job.name)) continue;
            job.stop();
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            for (SystemResourceJob job : this.resources) {
                job.start();
            }
            LOGGER.info("System resource monitor started!");
        }
    }

    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            for (SystemResourceJob job : this.resources) {
                job.stop();
            }
            LOGGER.info("System resource monitor stopped!");
        }
    }

    public void checkNow(String name) {
        for (SystemResourceJob job : this.resources) {
            if (name != null && !name.equals(job.name)) continue;
            job.checkNow();
        }
        LOGGER.info("System resource monitor checked now!");
    }

    public static abstract class FileMonitor
    implements SystemResourceMonitor {
        private final File file;
        private volatile MonitoredValues values;

        public FileMonitor(String name) {
            this(new File(name));
        }

        public FileMonitor(File file) {
            this.file = file;
            this.values = this.readMonitoredValues();
        }

        private MonitoredValues readMonitoredValues() {
            long length = this.file.length();
            long lastModified = this.file.lastModified();
            return new MonitoredValues(lastModified, length);
        }

        @Override
        public void checkForUpdate(SystemResourceCheckReady ready) {
            MonitoredValues values = this.readMonitoredValues();
            if (this.values.check(values)) {
                LOGGER.info("File {} changed!", (Object)this.file);
                this.update(values, ready);
            } else {
                LOGGER.info("File {} unchanged.", (Object)this.file);
                ready.ready(false);
            }
        }

        protected void ready(MonitoredValues values) {
            if (values != null) {
                this.values = values;
            }
        }

        protected abstract void update(MonitoredValues var1, SystemResourceCheckReady var2);

        public static class MonitoredValues {
            private final long lastModified;
            private final long length;

            private MonitoredValues(long lastModified, long length) {
                this.lastModified = lastModified;
                this.length = length;
            }

            private boolean check(MonitoredValues other) {
                return this.lastModified != other.lastModified || this.length != other.length;
            }
        }
    }

    public static interface SystemResourceMonitor {
        public void checkForUpdate(SystemResourceCheckReady var1);
    }

    public static class SystemResourceJob
    implements Runnable,
    SystemResourceCheckReady {
        private final String name;
        private final long interval;
        private final TimeUnit unit;
        private final SystemResourceMonitor resource;
        private final ScheduledExecutorService scheduler;
        private final AtomicReference<ScheduledFuture<?>> scheduled = new AtomicReference();
        private final AtomicBoolean pending = new AtomicBoolean();

        private SystemResourceJob(ScheduledExecutorService scheduler, String name, long interval, TimeUnit unit, SystemResourceMonitor resource) {
            this.scheduler = scheduler;
            this.name = name;
            this.interval = interval;
            this.unit = unit;
            this.resource = resource;
        }

        private synchronized void stop() {
            ScheduledFuture future = this.scheduled.getAndSet(null);
            if (future != null) {
                future.cancel(false);
            }
        }

        private synchronized void start() {
            ScheduledFuture<?> future = this.scheduled.getAndSet(this.scheduler.schedule(this, this.interval, this.unit));
            if (future != null) {
                future.cancel(false);
            }
            LOGGER.info("{} check scheduled in {} {}.", new Object[]{this.name, this.interval, this.unit});
        }

        private void checkNow() {
            if (this.pending.compareAndSet(false, true)) {
                ScheduledFuture<?> future = this.scheduled.get();
                if (future != null) {
                    future.cancel(false);
                }
                this.resource.checkForUpdate(this);
            }
        }

        private void check() {
            if (this.pending.compareAndSet(false, true)) {
                LOGGER.info("{} check for update!", (Object)this.name);
                this.resource.checkForUpdate(this);
            } else {
                LOGGER.info("{} check for update pending!", (Object)this.name);
            }
        }

        @Override
        public void run() {
            this.check();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ready(boolean stop) {
            this.pending.set(false);
            LOGGER.info("{} check ready!", (Object)this.name);
            SystemResourceJob systemResourceJob = this;
            synchronized (systemResourceJob) {
                ScheduledFuture<?> future = this.scheduled.get();
                if (future != null) {
                    if (stop) {
                        future.cancel(false);
                    } else {
                        this.start();
                    }
                }
            }
        }
    }

    public static interface SystemResourceCheckReady {
        public void ready(boolean var1);
    }
}

