/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.Definition;
import org.eclipse.californium.elements.Definitions;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.util.FilteredLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointContextUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointContextUtil.class);
    private static final FilteredLogger WARN_FILTER = new FilteredLogger(LOGGER, 3L, TimeUnit.SECONDS.toNanos(10L));

    public static boolean match(String name, Definitions<Definition<?>> definitions, EndpointContext context1, EndpointContext context2) {
        boolean warn = LOGGER.isWarnEnabled();
        boolean trace = LOGGER.isTraceEnabled();
        boolean matchAll = true;
        for (Definition<?> key : definitions) {
            Object value2;
            boolean match;
            Object value1 = context1.get(key);
            boolean bl = match = value1 == (value2 = context2.get(key)) || null != value1 && value1.equals(value2);
            if (!match && !warn) {
                return false;
            }
            if (!match) {
                WARN_FILTER.warn("{}, {}: \"{}\" != \"{}\"", name, key, value1, value2);
            } else if (trace) {
                LOGGER.trace("{}, {}: \"{}\" == \"{}\"", name, key, value1, value2);
            }
            matchAll = matchAll && match;
        }
        return matchAll;
    }

    public static EndpointContext getFollowUpEndpointContext(EndpointContext messageContext, EndpointContext connectionContext) {
        String mode = messageContext.getString(DtlsEndpointContext.KEY_HANDSHAKE_MODE);
        EndpointContext followUpEndpointContext = mode != null && mode.equals("none") ? MapBasedEndpointContext.addEntries(connectionContext, DtlsEndpointContext.ATTRIBUTE_HANDSHAKE_MODE_NONE) : connectionContext;
        return followUpEndpointContext;
    }
}

