/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListUtils {
    public static <T> List<T> init(List<T> values) {
        if (values == null) {
            return null;
        }
        if (values.size() > 1) {
            for (int index = 1; index < values.size(); ++index) {
                T item = values.get(index);
                for (int search = 0; search < index; ++search) {
                    T first = values.get(search);
                    if (!first.equals(item)) continue;
                    throw new IllegalArgumentException("Item " + item + "[" + index + "] is already contained at index [" + search + "]!");
                }
            }
        }
        return Collections.unmodifiableList(new ArrayList<T>(values));
    }

    public static <T> List<T> addIfAbsent(List<T> list, T value) {
        if (list == null) {
            throw new NullPointerException("List must not be null!");
        }
        if (value != null && !list.contains(value)) {
            list.add(value);
        }
        return list;
    }

    public static <T> List<T> addIfAbsent(List<T> list, List<T> newValues) {
        if (list == null) {
            throw new NullPointerException("List must not be null!");
        }
        if (newValues != null && !newValues.isEmpty()) {
            for (T value : newValues) {
                if (value == null || list.contains(value)) continue;
                list.add(value);
            }
        }
        return list;
    }
}

