/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.LinkFormat;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.UriQueryParameter;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.util.LeastRecentlyUsedCache;

public class Echo
extends CoapResource {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MMM-HH:mm:ss");
    private static final String RESOURCE_NAME = "echo";
    private static final String URI_QUERY_OPTION_RESPONSE_LENGTH = "rlen";
    private static final String URI_QUERY_OPTION_ACK = "ack";
    private static final String URI_QUERY_OPTION_DELAY = "delay";
    private static final String URI_QUERY_OPTION_KEEP = "keep";
    private static final List<String> SUPPORTED = Arrays.asList("ack", "delay", "rlen", "keep");
    private static final int MAX_PENDING_RESPONSES = 1000;
    private final int maxResourceSize;
    private final ScheduledExecutorService executor;
    private final AtomicInteger pendingResponses = new AtomicInteger();
    private final LeastRecentlyUsedCache<String, Resource> keptPosts = new LeastRecentlyUsedCache(100, 500, 6L, TimeUnit.HOURS);

    public Echo(int maxResourceSize, ScheduledExecutorService executor) {
        super(RESOURCE_NAME);
        this.executor = executor;
        this.maxResourceSize = maxResourceSize;
        this.getAttributes().setTitle("Resource, which echo's a POST. POSTs with URI-query 'keep' can later be read by GET");
        this.getAttributes().addContentType(0);
        this.getAttributes().addContentType(42);
        this.getAttributes().addContentType(40);
        this.keptPosts.setEvictingOnReadAccess(false);
        this.keptPosts.setUpdatingOnReadAccess(false);
    }

    @Override
    public void add(Resource child) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean delete(Resource child) {
        throw new UnsupportedOperationException("Not supported!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getChild(String name) {
        LeastRecentlyUsedCache<String, Resource> leastRecentlyUsedCache = this.keptPosts;
        synchronized (leastRecentlyUsedCache) {
            return this.keptPosts.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Resource> getChildren() {
        LeastRecentlyUsedCache<String, Resource> leastRecentlyUsedCache = this.keptPosts;
        synchronized (leastRecentlyUsedCache) {
            return this.keptPosts.values();
        }
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        Request request = exchange.advanced().getRequest();
        int accept = request.getOptions().getAccept();
        if (accept != -1 && accept != 40) {
            exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
        } else {
            exchange.respond(CoAP.ResponseCode.CONTENT, LinkFormat.serializeTree(this), 40);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePOST(final CoapExchange exchange) {
        String principal;
        byte[] responsePayload;
        Request request = exchange.advanced().getRequest();
        int format = request.getOptions().getContentFormat();
        if (format != -1 && format != 0 && format != 42) {
            exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
            return;
        }
        int accept = request.getOptions().getAccept();
        if (accept == -1) {
            accept = format == -1 ? 42 : format;
        } else if (format == -1) {
            if (accept != 0 && accept != 42) {
                exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
                return;
            }
        } else if (accept != format) {
            exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
            return;
        }
        boolean ack = false;
        boolean keep = false;
        int length = 0;
        int delay = 0;
        try {
            List<String> uriQuery = request.getOptions().getUriQuery();
            UriQueryParameter helper = new UriQueryParameter(uriQuery, SUPPORTED);
            ack = helper.hasParameter(URI_QUERY_OPTION_ACK);
            length = helper.getArgumentAsInteger(URI_QUERY_OPTION_RESPONSE_LENGTH, 0, 0, this.maxResourceSize);
            delay = helper.getArgumentAsInteger(URI_QUERY_OPTION_DELAY, 0, 0, (int)TimeUnit.SECONDS.toMillis(3600L));
            keep = helper.hasParameter(URI_QUERY_OPTION_KEEP);
        }
        catch (IllegalArgumentException ex) {
            Response response = Response.createResponse(request, CoAP.ResponseCode.BAD_OPTION);
            response.setPayload(ex.getMessage());
            exchange.respond(response);
            return;
        }
        if (ack) {
            exchange.accept();
        }
        byte[] payload = request.getPayload();
        byte[] byArray = responsePayload = length == 0 ? payload : Arrays.copyOf(payload, length);
        if (length > payload.length) {
            Arrays.fill(responsePayload, payload.length, length, (byte)42);
        }
        if (keep && (principal = Echo.getPrincipalName(request)) != null) {
            request.setProtectFromOffload();
            Keep child = new Keep(principal, request);
            child.setParent(this);
            LeastRecentlyUsedCache<String, Resource> leastRecentlyUsedCache = this.keptPosts;
            synchronized (leastRecentlyUsedCache) {
                this.keptPosts.put(principal, child);
            }
        }
        final int responseFormat = accept;
        if (delay > 0 && this.executor != null) {
            boolean schedule = false;
            if (this.pendingResponses.get() < 999) {
                if (this.pendingResponses.incrementAndGet() < 1000) {
                    schedule = true;
                } else {
                    this.pendingResponses.decrementAndGet();
                }
            }
            if (schedule) {
                Runnable response = new Runnable(){

                    @Override
                    public void run() {
                        exchange.respond(CoAP.ResponseCode.CHANGED, responsePayload, responseFormat);
                        Echo.this.pendingResponses.decrementAndGet();
                    }
                };
                this.executor.schedule(response, (long)delay, TimeUnit.MILLISECONDS);
            } else {
                exchange.respond(CoAP.ResponseCode.SERVICE_UNAVAILABLE, "Too many delayed responses pending!");
            }
        } else {
            exchange.respond(CoAP.ResponseCode.CHANGED, responsePayload, responseFormat);
        }
    }

    private static String getPrincipalName(Request request) {
        Principal principal = request.getSourceContext().getPeerIdentity();
        if (principal != null) {
            return principal.getName();
        }
        return null;
    }

    private static class Keep
    extends CoapResource {
        private final Request post;

        private Keep(String principal, Request post) {
            super(principal);
            this.post = post;
            if (post.getOptions().hasContentFormat()) {
                this.getAttributes().addContentType(post.getOptions().getContentFormat());
            } else {
                this.getAttributes().clearContentType();
            }
            this.getAttributes().addAttribute("time", DATE_FORMAT.format(new Date()));
        }

        @Override
        public void handleGET(CoapExchange exchange) {
            Request request = exchange.advanced().getRequest();
            int format = this.post.getOptions().getContentFormat();
            int accept = request.getOptions().getAccept();
            if (accept == -1) {
                accept = format == -1 ? 42 : format;
            } else if (format == -1) {
                if (accept != 0 && accept != 42) {
                    exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
                    return;
                }
            } else if (accept != format) {
                exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
                return;
            }
            exchange.respond(CoAP.ResponseCode.CHANGED, this.post.getPayload(), accept);
        }
    }
}

