/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORDataUtilities;
import com.upokecenter.cbor.CBORDataUtilitiesTextString;
import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.JSONOptions;
import com.upokecenter.cbor.PropertyMap;
import java.util.ArrayList;
import java.util.TreeMap;

final class CBORJson3 {
    private final String jstring;
    private final JSONOptions options;
    private StringBuilder sb = null;
    private int index;
    private int endPos;

    private int SkipWhitespaceJSON() {
        while (this.index < this.endPos) {
            char c;
            if ((c = this.jstring.charAt(this.index++)) == ' ' || c == '\n' || c == '\r' || c == '\t') continue;
            return c;
        }
        return -1;
    }

    void RaiseError(String str) {
        throw new CBORException(str + " (approx. offset: " + Math.max(0, this.index - 1) + ")");
    }

    private String NextJSONString() {
        int c;
        int startIndex = this.index;
        int endIndex = -1;
        int ep = this.endPos;
        String js = this.jstring;
        int idx = this.index;
        while (true) {
            int n = c = idx < ep ? js.charAt(idx++) & 0xFFFF : -1;
            if (c == -1 || c < 32) {
                this.index = idx;
                this.RaiseError("Unterminated String");
                continue;
            }
            if (c == 34) {
                int iend = idx - 1;
                this.index = idx;
                return js.substring(startIndex, startIndex + (iend - startIndex));
            }
            if (c == 92 || (c & 0xF800) == 55296) break;
        }
        endIndex = this.index = idx - 1;
        this.sb = this.sb == null ? new StringBuilder() : this.sb;
        this.sb.delete(0, this.sb.length());
        this.sb.append(js, startIndex, startIndex + (endIndex - startIndex));
        block14: while (true) {
            int n = c = this.index < ep ? js.charAt(this.index++) & 0xFFFF : -1;
            if (c == -1 || c < 32) {
                this.RaiseError("Unterminated String");
            }
            switch (c) {
                case 92: {
                    endIndex = this.index - 1;
                    c = this.index < ep ? js.charAt(this.index++) & 0xFFFF : -1;
                    switch (c) {
                        case 34: 
                        case 47: 
                        case 92: {
                            this.sb.append((char)c);
                            continue block14;
                        }
                        case 98: {
                            this.sb.append('\b');
                            continue block14;
                        }
                        case 102: {
                            this.sb.append('\f');
                            continue block14;
                        }
                        case 110: {
                            this.sb.append('\n');
                            continue block14;
                        }
                        case 114: {
                            this.sb.append('\r');
                            continue block14;
                        }
                        case 116: {
                            this.sb.append('\t');
                            continue block14;
                        }
                        case 117: {
                            c = 0;
                            for (int i = 0; i < 4; ++i) {
                                int ch;
                                int n2 = ch = this.index < ep ? (int)js.charAt(this.index++) : -1;
                                if (ch >= 48 && ch <= 57) {
                                    c <<= 4;
                                    c |= ch - 48;
                                    continue;
                                }
                                if (ch >= 65 && ch <= 70) {
                                    c <<= 4;
                                    c |= ch + 10 - 65;
                                    continue;
                                }
                                if (ch >= 97 && ch <= 102) {
                                    c <<= 4;
                                    c |= ch + 10 - 97;
                                    continue;
                                }
                                this.RaiseError("Invalid Unicode escaped character");
                            }
                            if ((c & 0xF800) != 55296) {
                                this.sb.append((char)c);
                                continue block14;
                            }
                            if ((c & 0xFC00) == 55296) {
                                int ch;
                                int n3 = ch = this.index < ep ? (int)js.charAt(this.index++) : -1;
                                if (ch != 92 || (this.index < ep ? (int)js.charAt(this.index++) : -1) != 117) {
                                    this.RaiseError("Invalid escaped character");
                                }
                                int c2 = 0;
                                for (int i = 0; i < 4; ++i) {
                                    int n4 = ch = this.index < ep ? (int)js.charAt(this.index++) : -1;
                                    if (ch >= 48 && ch <= 57) {
                                        c2 <<= 4;
                                        c2 |= ch - 48;
                                        continue;
                                    }
                                    if (ch >= 65 && ch <= 70) {
                                        c2 <<= 4;
                                        c2 |= ch + 10 - 65;
                                        continue;
                                    }
                                    if (ch >= 97 && ch <= 102) {
                                        c2 <<= 4;
                                        c2 |= ch + 10 - 97;
                                        continue;
                                    }
                                    this.RaiseError("Invalid Unicode escaped character");
                                }
                                if ((c2 & 0xFC00) != 56320) {
                                    this.RaiseError("Unpaired surrogate code point");
                                    continue block14;
                                }
                                this.sb.append((char)c);
                                this.sb.append((char)c2);
                                continue block14;
                            }
                            this.RaiseError("Unpaired surrogate code point");
                            continue block14;
                        }
                    }
                    this.RaiseError("Invalid escaped character");
                    continue block14;
                }
                case 34: {
                    return this.sb.toString();
                }
            }
            if ((c & 0xF800) != 55296) {
                this.sb.append((char)c);
                continue;
            }
            if ((c & 0xFC00) == 55296 && this.index < ep && (js.charAt(this.index) & 0xFC00) == 56320) {
                this.sb.append((char)c);
                this.sb.append(js.charAt(this.index));
                ++this.index;
                continue;
            }
            this.RaiseError("Unpaired surrogate code point");
        }
    }

    private CBORObject NextJSONNegativeNumber(int[] nextChar) {
        int c;
        int numberStartIndex = this.index - 1;
        int n = c = this.index < this.endPos ? this.jstring.charAt(this.index++) & 0xFFFF : -1;
        if (c < 48 || c > 57) {
            this.RaiseError("JSON number can't be parsed.");
        }
        if (this.index < this.endPos && c != 48) {
            int c2 = this.jstring.charAt(this.index) & 0xFFFF;
            if (c2 == 44 || c2 == 93 || c2 == 125) {
                ++this.index;
                CBORObject obj = CBORDataUtilities.ParseSmallNumberAsNegative(c - 48, this.options);
                nextChar[0] = c2;
                return obj;
            }
            if (c2 == 32 || c2 == 10 || c2 == 13 || c2 == 9) {
                ++this.index;
                CBORObject obj = CBORDataUtilities.ParseSmallNumberAsNegative(c - 48, this.options);
                nextChar[0] = this.SkipWhitespaceJSON();
                return obj;
            }
        }
        int[] endIndex = new int[]{numberStartIndex};
        CBORObject obj = CBORDataUtilitiesTextString.ParseJSONNumber(this.jstring, numberStartIndex, this.endPos - numberStartIndex, this.options, endIndex);
        int numberEndIndex = endIndex[0];
        int n2 = this.index = numberEndIndex >= this.endPos ? this.endPos : numberEndIndex + 1;
        if (obj == null) {
            int strlen = numberEndIndex - numberStartIndex;
            String errstr = this.jstring.substring(numberStartIndex, numberStartIndex + Math.min(100, strlen));
            if (strlen > 100) {
                errstr = errstr + "...";
            }
            this.RaiseError("JSON number can't be parsed. " + errstr);
        }
        int n3 = c = numberEndIndex >= this.endPos ? -1 : (int)this.jstring.charAt(numberEndIndex);
        if (c != 44 && c != 93 && c != 125 && c != -1 && c != 32 && c != 10 && c != 13 && c != 9) {
            this.RaiseError("Invalid character after JSON number");
        }
        nextChar[0] = c == -1 || c != 32 && c != 10 && c != 13 && c != 9 ? c : this.SkipWhitespaceJSON();
        return obj;
    }

    private CBORObject NextJSONNonnegativeNumber(int c, int[] nextChar) {
        CBORObject obj = null;
        int cval = c - 48;
        int cstart = c;
        int startIndex = this.index - 1;
        boolean needObj = true;
        int numberStartIndex = this.index - 1;
        int n = c = this.index < this.endPos ? this.jstring.charAt(this.index++) & 0xFFFF : -1;
        if (c != 45 && c != 43 && c != 46 && (c < 48 || c > 57) && c != 101 && c != 69) {
            obj = CBORDataUtilities.ParseSmallNumber(cval, this.options);
            needObj = false;
        } else if (c >= 48 && c <= 57) {
            int csecond = c;
            if (cstart == 48) {
                this.RaiseError("JSON number can't be parsed.");
            }
            cval = cval * 10 + (c - 48);
            int n2 = c = this.index < this.endPos ? (int)this.jstring.charAt(this.index++) : -1;
            if (c >= 48 && c <= 57) {
                for (int digits = 2; digits < 9 && c >= 48 && c <= 57; ++digits) {
                    cval = cval * 10 + (c - 48);
                    c = this.index < this.endPos ? (int)this.jstring.charAt(this.index++) : -1;
                }
                if (c != 101 && c != 69 && c != 46 && (c < 48 || c > 57)) {
                    obj = CBORDataUtilities.ParseSmallNumber(cval, this.options);
                    needObj = false;
                }
            } else if (c != 45 && c != 43 && c != 46 && c != 101 && c != 69) {
                obj = CBORDataUtilities.ParseSmallNumber(cval, this.options);
                needObj = false;
            }
        }
        if (needObj) {
            int[] endIndex = new int[]{numberStartIndex};
            obj = CBORDataUtilitiesTextString.ParseJSONNumber(this.jstring, numberStartIndex, this.endPos - numberStartIndex, this.options, endIndex);
            int numberEndIndex = endIndex[0];
            int n3 = this.index = numberEndIndex >= this.endPos ? this.endPos : numberEndIndex + 1;
            if (obj == null) {
                int strlen = numberEndIndex - numberStartIndex;
                String errstr = this.jstring.substring(numberStartIndex, numberStartIndex + Math.min(100, strlen));
                if (strlen > 100) {
                    errstr = errstr + "...";
                }
                this.RaiseError("JSON number can't be parsed. " + errstr);
            }
            int n4 = c = numberEndIndex >= this.endPos ? -1 : (int)this.jstring.charAt(numberEndIndex);
            if (c != 44 && c != 93 && c != 125 && c != -1 && c != 32 && c != 10 && c != 13 && c != 9) {
                this.RaiseError("Invalid character after JSON number");
            }
        } else if (c != 44 && c != 93 && c != 125 && c != -1 && c != 32 && c != 10 && c != 13 && c != 9) {
            this.RaiseError("Invalid character after JSON number");
        }
        nextChar[0] = c == -1 || c != 32 && c != 10 && c != 13 && c != 9 ? c : this.SkipWhitespaceJSON();
        return obj;
    }

    private CBORObject NextJSONValue(int firstChar, int[] nextChar, int depth) {
        int c = firstChar;
        CBORObject obj = null;
        if (c < 0) {
            this.RaiseError("Unexpected end of data");
        }
        switch (c) {
            case 34: {
                obj = CBORObject.FromRaw(this.NextJSONString());
                nextChar[0] = this.SkipWhitespaceJSON();
                return obj;
            }
            case 123: {
                obj = this.ParseJSONObject(depth + 1);
                nextChar[0] = this.SkipWhitespaceJSON();
                return obj;
            }
            case 91: {
                obj = this.ParseJSONArray(depth + 1);
                nextChar[0] = this.SkipWhitespaceJSON();
                return obj;
            }
            case 116: {
                if (this.endPos - this.index <= 2 || (this.jstring.charAt(this.index) & 0xFF) != 114 || (this.jstring.charAt(this.index + 1) & 0xFF) != 117 || (this.jstring.charAt(this.index + 2) & 0xFF) != 101) {
                    this.RaiseError("Value can't be parsed.");
                }
                this.index += 3;
                nextChar[0] = this.SkipWhitespaceJSON();
                return CBORObject.True;
            }
            case 102: {
                if (this.endPos - this.index <= 3 || (this.jstring.charAt(this.index) & 0xFF) != 97 || (this.jstring.charAt(this.index + 1) & 0xFF) != 108 || (this.jstring.charAt(this.index + 2) & 0xFF) != 115 || (this.jstring.charAt(this.index + 3) & 0xFF) != 101) {
                    this.RaiseError("Value can't be parsed.");
                }
                this.index += 4;
                nextChar[0] = this.SkipWhitespaceJSON();
                return CBORObject.False;
            }
            case 110: {
                if (this.endPos - this.index <= 2 || (this.jstring.charAt(this.index) & 0xFF) != 117 || (this.jstring.charAt(this.index + 1) & 0xFF) != 108 || (this.jstring.charAt(this.index + 2) & 0xFF) != 108) {
                    this.RaiseError("Value can't be parsed.");
                }
                this.index += 3;
                nextChar[0] = this.SkipWhitespaceJSON();
                return CBORObject.Null;
            }
            case 45: {
                return this.NextJSONNegativeNumber(nextChar);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.NextJSONNonnegativeNumber(c, nextChar);
            }
        }
        this.RaiseError("Value can't be parsed.");
        return null;
    }

    public CBORJson3(String jstring, int index, int endPos, JSONOptions options) {
        this.jstring = jstring;
        this.index = index;
        this.endPos = endPos;
        this.options = options;
    }

    public CBORObject ParseJSON(int[] nextchar) {
        int c = this.SkipWhitespaceJSON();
        if (c == 91) {
            CBORObject ret = this.ParseJSONArray(0);
            nextchar[0] = this.SkipWhitespaceJSON();
            return ret;
        }
        if (c == 123) {
            CBORObject ret = this.ParseJSONObject(0);
            nextchar[0] = this.SkipWhitespaceJSON();
            return ret;
        }
        return this.NextJSONValue(c, nextchar, 0);
    }

    static CBORObject ParseJSONValue(String jstring, int index, int endPos, JSONOptions options) {
        int[] nextchar = new int[1];
        CBORJson3 cj = new CBORJson3(jstring, index, endPos, options);
        CBORObject obj = cj.ParseJSON(nextchar);
        if (nextchar[0] != -1) {
            cj.RaiseError("End of String not reached");
        }
        return obj;
    }

    static CBORObject ParseJSONValue(String jstring, int index, int endPos, JSONOptions options, int[] nextchar) {
        CBORJson3 cj = new CBORJson3(jstring, index, endPos, options);
        return cj.ParseJSON(nextchar);
    }

    private CBORObject ParseJSONObject(int depth) {
        if (depth > 1000) {
            this.RaiseError("Too deeply nested");
        }
        CBORObject key = null;
        int[] nextchar = new int[1];
        boolean seenComma = false;
        TreeMap<CBORObject, CBORObject> myHashMap = this.options.getKeepKeyOrder() ? PropertyMap.NewOrderedDict() : new TreeMap<CBORObject, CBORObject>();
        block8: while (true) {
            int c = this.SkipWhitespaceJSON();
            switch (c) {
                case -1: {
                    this.RaiseError("A JSON Object must end with '}'");
                    break;
                }
                case 125: {
                    if (seenComma) {
                        this.RaiseError("Trailing comma");
                        return null;
                    }
                    return CBORObject.FromRaw(myHashMap);
                }
                default: {
                    CBORObject obj;
                    if (c < 0) {
                        this.RaiseError("Unexpected end of data");
                        return null;
                    }
                    if (c != 34) {
                        this.RaiseError("Expected a String as a key");
                        return null;
                    }
                    key = obj = CBORObject.FromRaw(this.NextJSONString());
                }
            }
            if (this.SkipWhitespaceJSON() != 58) {
                this.RaiseError("Expected a ':' after a key");
            }
            int oldCount = myHashMap.size();
            myHashMap.put(key, this.NextJSONValue(this.SkipWhitespaceJSON(), nextchar, depth));
            int newCount = myHashMap.size();
            if (!this.options.getAllowDuplicateKeys() && oldCount == newCount) {
                this.RaiseError("Duplicate key already exists");
                return null;
            }
            switch (nextchar[0]) {
                case 44: {
                    seenComma = true;
                    continue block8;
                }
                case 125: {
                    return CBORObject.FromRaw(myHashMap);
                }
            }
            this.RaiseError("Expected a ',' or '}'");
        }
    }

    CBORObject ParseJSONArray(int depth) {
        if (depth > 1000) {
            this.RaiseError("Too deeply nested");
        }
        ArrayList<CBORObject> myArrayList = new ArrayList<CBORObject>();
        boolean seenComma = false;
        int[] nextchar = new int[1];
        block4: while (true) {
            int c;
            if ((c = this.SkipWhitespaceJSON()) == 93) {
                if (seenComma) {
                    this.RaiseError("Trailing comma");
                }
                return CBORObject.FromRaw(myArrayList);
            }
            if (c == 44) {
                this.RaiseError("Empty array element");
            }
            myArrayList.add(this.NextJSONValue(c, nextchar, depth));
            c = nextchar[0];
            switch (c) {
                case 44: {
                    seenComma = true;
                    continue block4;
                }
                case 93: {
                    return CBORObject.FromRaw(myArrayList);
                }
            }
            this.RaiseError("Expected a ',' or ']'");
        }
    }
}

