/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.DataStreamReader;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.SerialExecutor;
import org.eclipse.californium.elements.util.SerializationUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.ConnectionListener;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.DTLSContext;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    private static final Logger LOGGER_OWNER = LoggerFactory.getLogger(LOGGER.getName() + ".owner");
    private final AtomicReference<Handshaker> ongoingHandshake = new AtomicReference();
    private final SessionListener sessionListener = new ConnectionSessionListener();
    private volatile ConnectionListener connectionListener;
    private volatile ClientHelloIdentifier startingHelloClient;
    private volatile DTLSContext establishedDtlsContext;
    private volatile boolean resumptionRequired;
    private volatile boolean doublePrincipal;
    private long lastMessageNanos;
    private long lastPeerAddressNanos;
    private volatile SerialExecutor serialExecutor;
    private InetSocketAddress peerAddress;
    private InetSocketAddress router;
    private ConnectionId cid;
    private Object filterData;
    private AlertMessage rootCause;
    private static final int VERSION = 1;

    public Connection(InetSocketAddress peerAddress) {
        if (peerAddress == null) {
            throw new NullPointerException("Peer address must not be null");
        }
        long now = ClockUtil.nanoRealtime();
        this.peerAddress = peerAddress;
        this.lastPeerAddressNanos = now;
        this.lastMessageNanos = now;
    }

    public void updateConnectionState() {
        ConnectionListener listener = this.connectionListener;
        if (listener != null) {
            listener.updateExecution(this);
        }
    }

    public Connection setConnectorContext(Executor executor, ConnectionListener listener) {
        if (this.isExecuting()) {
            throw new IllegalStateException("Executor already available!");
        }
        this.serialExecutor = new SerialExecutor(executor);
        this.connectionListener = listener;
        if (listener == null) {
            this.serialExecutor.setExecutionListener(null);
        } else {
            this.serialExecutor.setExecutionListener(new SerialExecutor.ExecutionListener(){

                @Override
                public void beforeExecution() {
                    Connection.this.connectionListener.beforeExecution(Connection.this);
                }

                @Override
                public void afterExecution() {
                    Connection.this.connectionListener.afterExecution(Connection.this);
                }
            });
        }
        return this;
    }

    public SerialExecutor getExecutor() {
        return this.serialExecutor;
    }

    public boolean isExecuting() {
        return this.serialExecutor != null && !this.serialExecutor.isShutdown();
    }

    public int shutdown() {
        SerialExecutor executor = this.getExecutor();
        if (executor != null) {
            List<Runnable> pendings = executor.shutdownNow();
            ExecutorsUtil.runAll(pendings);
            return pendings.size();
        }
        return 0;
    }

    public final SessionListener getSessionListener() {
        return this.sessionListener;
    }

    public boolean isActive() {
        return this.establishedDtlsContext != null;
    }

    public boolean expectCid() {
        DTLSContext context = this.getDtlsContext();
        return context != null && ConnectionId.useConnectionId(context.getReadConnectionId());
    }

    public ConnectionId getConnectionId() {
        return this.cid;
    }

    public void setConnectionId(ConnectionId cid) {
        this.cid = cid;
        this.updateConnectionState();
    }

    public void setFilterData(Object filterData) {
        this.filterData = filterData;
    }

    public Object getFilterData() {
        return this.filterData;
    }

    public long getLastPeerAddressNanos() {
        return this.lastPeerAddressNanos;
    }

    public InetSocketAddress getPeerAddress() {
        return this.peerAddress;
    }

    public void updatePeerAddress(InetSocketAddress peerAddress) {
        if (!this.equalsPeerAddress(peerAddress)) {
            if (this.establishedDtlsContext == null && peerAddress != null) {
                throw new IllegalArgumentException("Address change without established dtls context is not supported!");
            }
            this.lastPeerAddressNanos = ClockUtil.nanoRealtime();
            InetSocketAddress previous = this.peerAddress;
            this.peerAddress = peerAddress;
            if (peerAddress == null) {
                Handshaker pendingHandshaker = this.getOngoingHandshake();
                if (pendingHandshaker != null && (this.establishedDtlsContext == null || pendingHandshaker.getDtlsContext() != this.establishedDtlsContext)) {
                    pendingHandshaker.handshakeFailed(new IOException(StringUtil.toDisplayString(previous) + " address reused during handshake!"));
                }
            } else {
                this.updateConnectionState();
            }
        }
    }

    public boolean equalsPeerAddress(InetSocketAddress peerAddress) {
        if (this.peerAddress == peerAddress) {
            return true;
        }
        if (this.peerAddress == null) {
            return false;
        }
        return this.peerAddress.equals(peerAddress);
    }

    public InetSocketAddress getRouter() {
        return this.router;
    }

    public void setRouter(InetSocketAddress router) {
        if (!(this.router == router || this.router != null && this.router.equals(router))) {
            this.router = router;
            this.updateConnectionState();
        }
    }

    public DtlsEndpointContext getWriteContext(MapBasedEndpointContext.Attributes attributes) {
        if (this.establishedDtlsContext == null) {
            throw new IllegalStateException("DTLS context must be established!");
        }
        this.establishedDtlsContext.addWriteEndpointContext(attributes);
        if (this.router != null) {
            attributes.add(DtlsEndpointContext.KEY_VIA_ROUTER, "dtls-cid-router");
        }
        DTLSSession session = this.establishedDtlsContext.getSession();
        return new DtlsEndpointContext(this.peerAddress, session.getHostName(), session.getPeerIdentity(), attributes);
    }

    public DtlsEndpointContext getReadContext(MapBasedEndpointContext.Attributes attributes, InetSocketAddress recordsPeer) {
        if (this.establishedDtlsContext == null) {
            throw new IllegalStateException("DTLS context must be established!");
        }
        this.establishedDtlsContext.addReadEndpointContext(attributes);
        if (this.router != null) {
            attributes.add(DtlsEndpointContext.KEY_VIA_ROUTER, "dtls-cid-router");
        }
        if (this.peerAddress != null) {
            recordsPeer = this.peerAddress;
        }
        DTLSSession session = this.establishedDtlsContext.getSession();
        return new DtlsEndpointContext(recordsPeer, session.getHostName(), session.getPeerIdentity(), attributes);
    }

    public DTLSSession getSession() {
        DTLSContext dtlsContext = this.getDtlsContext();
        if (dtlsContext != null) {
            return dtlsContext.getSession();
        }
        return null;
    }

    public Principal getEstablishedPeerIdentity() {
        DTLSContext context = this.getEstablishedDtlsContext();
        return context == null ? null : context.getSession().getPeerIdentity();
    }

    public SessionId getEstablishedSessionIdentifier() {
        DTLSContext context = this.getEstablishedDtlsContext();
        return context == null ? null : context.getSession().getSessionIdentifier();
    }

    public DTLSSession getEstablishedSession() {
        DTLSContext context = this.getEstablishedDtlsContext();
        return context == null ? null : context.getSession();
    }

    public boolean hasEstablishedDtlsContext() {
        return this.establishedDtlsContext != null;
    }

    public DTLSContext getEstablishedDtlsContext() {
        return this.establishedDtlsContext;
    }

    public Handshaker getOngoingHandshake() {
        return this.ongoingHandshake.get();
    }

    public boolean hasOngoingHandshake() {
        return this.ongoingHandshake.get() != null;
    }

    public boolean isDouble() {
        return this.doublePrincipal;
    }

    public void setDouble() {
        this.doublePrincipal = true;
    }

    public Long getStartNanos() {
        ClientHelloIdentifier start = this.startingHelloClient;
        if (start != null) {
            return start.nanos;
        }
        return null;
    }

    public boolean isStartedByClientHello(ClientHello clientHello) {
        if (clientHello == null) {
            throw new NullPointerException("client hello must not be null!");
        }
        ClientHelloIdentifier start = this.startingHelloClient;
        if (start != null) {
            return start.isStartedByClientHello(clientHello);
        }
        return false;
    }

    public void startByClientHello(ClientHello clientHello) {
        this.startingHelloClient = clientHello == null ? null : new ClientHelloIdentifier(clientHello);
    }

    public DTLSContext getDtlsContext(int readEpoch) {
        DTLSContext context = this.establishedDtlsContext;
        if (context != null && context.getReadEpoch() == readEpoch) {
            return context;
        }
        Handshaker handshaker = this.ongoingHandshake.get();
        if (handshaker != null && (context = handshaker.getDtlsContext()) != null && context.getReadEpoch() == readEpoch) {
            return context;
        }
        return null;
    }

    public DTLSContext getDtlsContext() {
        Handshaker handshaker;
        DTLSContext context = this.establishedDtlsContext;
        if (context == null && (handshaker = this.ongoingHandshake.get()) != null) {
            context = handshaker.getDtlsContext();
        }
        return context;
    }

    public void resetContext() {
        if (this.establishedDtlsContext == null) {
            throw new IllegalStateException("No established context to resume available!");
        }
        SecretUtil.destroy(this.establishedDtlsContext);
        this.establishedDtlsContext = null;
        this.resumptionRequired = false;
        this.startByClientHello(null);
        this.updateConnectionState();
    }

    public boolean isClosed() {
        DTLSContext context = this.establishedDtlsContext;
        return context != null && context.isMarkedAsClosed();
    }

    public void close(Record record) {
        DTLSContext context = this.establishedDtlsContext;
        if (context != null) {
            context.markCloseNotify(record.getEpoch(), record.getSequenceNumber());
        }
    }

    public boolean markRecordAsRead(Record record) {
        boolean newest = false;
        DTLSContext context = this.establishedDtlsContext;
        if (context != null) {
            newest = context.markRecordAsRead(record.getEpoch(), record.getSequenceNumber());
        }
        return newest;
    }

    public AlertMessage getRootCauseAlert() {
        return this.rootCause;
    }

    public boolean setRootCause(AlertMessage rootCause) {
        if (this.rootCause == null) {
            this.rootCause = rootCause;
            return true;
        }
        return false;
    }

    public boolean isResumptionRequired() {
        return this.resumptionRequired;
    }

    public boolean isAutoResumptionRequired(Long autoResumptionTimeoutMillis) {
        long expires;
        long now;
        if (!this.resumptionRequired && autoResumptionTimeoutMillis != null && this.establishedDtlsContext != null && (now = ClockUtil.nanoRealtime()) - (expires = this.lastMessageNanos + TimeUnit.MILLISECONDS.toNanos(autoResumptionTimeoutMillis)) > 0L) {
            this.setResumptionRequired(true);
        }
        return this.resumptionRequired;
    }

    public void refreshAutoResumptionTime() {
        this.lastMessageNanos = ClockUtil.nanoRealtime();
    }

    public long getLastMessageNanos() {
        return this.lastMessageNanos;
    }

    public void setResumptionRequired(boolean resumptionRequired) {
        this.resumptionRequired = resumptionRequired;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cid == null ? 0 : this.cid.hashCode());
        result = 31 * result + (this.establishedDtlsContext == null ? 0 : this.establishedDtlsContext.hashCode());
        result = 31 * result + (int)(this.lastMessageNanos ^ this.lastMessageNanos >>> 32);
        result = 31 * result + (this.peerAddress == null ? 0 : this.peerAddress.hashCode());
        result = 31 * result + (this.resumptionRequired ? 1231 : 1237);
        result = 31 * result + (this.router == null ? 0 : this.router.hashCode());
        result = 31 * result + (this.rootCause == null ? 0 : this.rootCause.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Connection other = (Connection)obj;
        if (!Bytes.equals(this.cid, other.cid)) {
            return false;
        }
        if (this.resumptionRequired != other.resumptionRequired) {
            return false;
        }
        if (this.lastMessageNanos != other.lastMessageNanos) {
            return false;
        }
        if (!Objects.equals(this.establishedDtlsContext, other.establishedDtlsContext)) {
            return false;
        }
        if (!Objects.equals(this.peerAddress, other.peerAddress)) {
            return false;
        }
        if (!Objects.equals(this.router, other.router)) {
            return false;
        }
        return Objects.equals(this.rootCause, other.rootCause);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("dtls-con: ");
        if (this.cid != null) {
            builder.append(this.cid);
        }
        if (this.peerAddress != null) {
            SessionId id;
            builder.append(", ").append(StringUtil.toDisplayString(this.peerAddress));
            Handshaker handshaker = this.getOngoingHandshake();
            if (handshaker != null) {
                builder.append(", ongoing handshake ");
                id = handshaker.getDtlsContext().getSession().getSessionIdentifier();
                if (id != null && !id.isEmpty()) {
                    builder.append(StringUtil.byteArray2HexString(id.getBytes(), '\u0000', 6));
                }
            }
            if (this.isResumptionRequired()) {
                builder.append(", resumption required");
            } else if (this.hasEstablishedDtlsContext()) {
                builder.append(", session established ");
                id = this.getEstablishedSession().getSessionIdentifier();
                if (id != null && !id.isEmpty()) {
                    builder.append(StringUtil.byteArray2HexString(id.getBytes(), '\u0000', 6));
                }
            }
        }
        if (this.isExecuting()) {
            builder.append(", is alive");
        }
        return builder.toString();
    }

    public boolean writeTo(DatagramWriter writer) {
        if (this.establishedDtlsContext == null || this.establishedDtlsContext.isMarkedAsClosed() || this.rootCause != null) {
            return false;
        }
        int position = SerializationUtil.writeStartItem(writer, 1, 16);
        writer.writeByte(this.resumptionRequired ? (byte)1 : 0);
        writer.writeLong(this.lastMessageNanos, 64);
        writer.writeVarBytes(this.cid, 8);
        SerializationUtil.write(writer, this.peerAddress);
        ClientHelloIdentifier start = this.startingHelloClient;
        if (start == null) {
            writer.writeByte((byte)0);
        } else {
            writer.writeByte((byte)1);
            start.write(writer);
        }
        this.establishedDtlsContext.writeTo(writer);
        writer.writeByte(this.cid != null && this.cid.equals(this.establishedDtlsContext.getReadConnectionId()) ? (byte)1 : 0);
        writer.writeByte(this.doublePrincipal ? (byte)1 : 0);
        SerializationUtil.writeFinishedItem(writer, position, 16);
        return true;
    }

    public static Connection fromReader(DataStreamReader reader, long nanoShift) {
        int length = SerializationUtil.readStartItem(reader, 1, 16);
        if (0 < length) {
            DatagramReader rangeReader = reader.createRangeReader(length);
            return new Connection(rangeReader, nanoShift);
        }
        return null;
    }

    private Connection(DatagramReader reader, long nanoShift) {
        this.resumptionRequired = reader.readNextByte() == 1;
        this.lastMessageNanos = reader.readLong(64) + nanoShift;
        byte[] data = reader.readVarBytes(8);
        if (data == null) {
            throw new IllegalArgumentException("CID must not be null!");
        }
        this.cid = new ConnectionId(data);
        this.peerAddress = SerializationUtil.readAddress(reader);
        if (reader.readNextByte() == 1) {
            this.startingHelloClient = new ClientHelloIdentifier(reader, nanoShift);
        }
        this.establishedDtlsContext = DTLSContext.fromReader(reader);
        if (this.establishedDtlsContext == null) {
            throw new IllegalArgumentException("DTLS Context must not be null!");
        }
        if (reader.readNextByte() == 1) {
            this.establishedDtlsContext.setReadConnectionId(this.cid);
        }
        if (reader.bytesAvailable() && reader.readNextByte() == 1) {
            this.doublePrincipal = true;
        }
        reader.assertFinished("connection");
    }

    private class ConnectionSessionListener
    implements SessionListener {
        private ConnectionSessionListener() {
        }

        @Override
        public void handshakeStarted(Handshaker handshaker) throws HandshakeException {
            Connection.this.ongoingHandshake.set(handshaker);
            LOGGER.debug("Handshake with [{}] has been started", StringUtil.toLog(Connection.this.peerAddress));
        }

        @Override
        public void contextEstablished(Handshaker handshaker, DTLSContext context) throws HandshakeException {
            Connection.this.establishedDtlsContext = context;
            LOGGER.debug("Session context with [{}] has been established", StringUtil.toLog(Connection.this.peerAddress));
        }

        @Override
        public void handshakeCompleted(Handshaker handshaker) {
            block4: {
                SerialExecutor executor = Connection.this.serialExecutor;
                if (executor != null && !executor.isShutdown() && LOGGER_OWNER.isErrorEnabled()) {
                    try {
                        executor.assertOwner();
                    }
                    catch (ConcurrentModificationException ex) {
                        LOGGER_OWNER.error("on handshake completed: connection {}", (Object)ex.getMessage(), (Object)ex);
                        if (!LOGGER_OWNER.isDebugEnabled()) break block4;
                        throw ex;
                    }
                }
            }
            if (Connection.this.ongoingHandshake.compareAndSet(handshaker, null)) {
                LOGGER.debug("Handshake with [{}] has been completed", StringUtil.toLog(Connection.this.peerAddress));
            }
        }

        @Override
        public void handshakeFailed(Handshaker handshaker, Throwable error) {
            block4: {
                SerialExecutor executor = Connection.this.serialExecutor;
                if (executor != null && !executor.isShutdown() && LOGGER_OWNER.isErrorEnabled()) {
                    try {
                        executor.assertOwner();
                    }
                    catch (ConcurrentModificationException ex) {
                        LOGGER_OWNER.error("on handshake failed: connection {}", (Object)ex.getMessage(), (Object)ex);
                        if (!LOGGER_OWNER.isDebugEnabled()) break block4;
                        throw ex;
                    }
                }
            }
            if (Connection.this.ongoingHandshake.compareAndSet(handshaker, null)) {
                Connection.this.startingHelloClient = null;
                LOGGER.debug("Handshake with [{}] has failed", StringUtil.toLog(Connection.this.peerAddress));
            }
        }

        @Override
        public void handshakeFlightRetransmitted(Handshaker handshaker, int flight) {
        }
    }

    private static class ClientHelloIdentifier {
        private final Random clientHelloRandom;
        private final long nanos;
        private final int clientHelloMessageSeq;

        private ClientHelloIdentifier(ClientHello clientHello) {
            this.clientHelloMessageSeq = clientHello.getMessageSeq();
            this.clientHelloRandom = clientHello.getRandom();
            this.nanos = ClockUtil.nanoRealtime();
        }

        private ClientHelloIdentifier(DatagramReader reader, long nanoShift) {
            this.clientHelloMessageSeq = reader.read(16);
            byte[] data = reader.readVarBytes(8);
            this.clientHelloRandom = data != null ? new Random(data) : null;
            this.nanos = reader.readLong(64) + nanoShift;
        }

        private boolean isStartedByClientHello(ClientHello clientHello) {
            return this.clientHelloRandom.equals(clientHello.getRandom()) && this.clientHelloMessageSeq >= clientHello.getMessageSeq();
        }

        private void write(DatagramWriter writer) {
            writer.write(this.clientHelloMessageSeq, 16);
            writer.writeVarBytes(this.clientHelloRandom, 8);
            writer.writeLong(this.nanos, 64);
        }
    }
}

