/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.LinkFormat;
import org.eclipse.californium.core.server.resources.CoapExchange;

public class LargePost
extends CoapResource {
    public LargePost() {
        this("large-post");
    }

    public LargePost(String resourceIdentifier) {
        super(resourceIdentifier);
        this.getAttributes().setTitle("Handle POST with two-way blockwise transfer");
        this.getAttributes().addResourceType("block");
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        exchange.respond(CoAP.ResponseCode.CONTENT, LinkFormat.serializeTree(this), 40);
    }

    @Override
    public void handlePOST(CoapExchange exchange) {
        if (exchange.getRequestOptions().hasContentFormat()) {
            exchange.respond(CoAP.ResponseCode.CHANGED, exchange.getRequestText().toUpperCase(), 0);
        } else {
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST, "Content-Format not set");
        }
    }
}

