/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;

@NoPublicAPI
public final class EcdhPskServerKeyExchange
extends ECDHServerKeyExchange {
    private static final int IDENTITY_HINT_LENGTH_BITS = 16;
    private final PskPublicInformation hint;

    public EcdhPskServerKeyExchange(PskPublicInformation pskHint, XECDHECryptography ecdhe) {
        super(ecdhe.getSupportedGroup(), ecdhe.getEncodedPoint());
        if (pskHint == null) {
            throw new NullPointerException("PSK hint must not be null");
        }
        this.hint = pskHint;
    }

    private EcdhPskServerKeyExchange(byte[] hintEncoded, XECDHECryptography.SupportedGroup supportedGroup, byte[] encodedPoint) throws HandshakeException {
        super(supportedGroup, encodedPoint);
        this.hint = PskPublicInformation.fromByteArray(hintEncoded);
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.writeVarBytes(this.hint, 16);
        this.writeNamedCurve(writer);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromReader(DatagramReader reader) throws HandshakeException {
        byte[] hintEncoded = reader.readVarBytes(16);
        ECDHServerKeyExchange.EcdhData ecdhData = EcdhPskServerKeyExchange.readNamedCurve(reader);
        return new EcdhPskServerKeyExchange(hintEncoded, ecdhData.supportedGroup, ecdhData.encodedPoint);
    }

    @Override
    public int getMessageLength() {
        return 2 + this.hint.length() + this.getNamedCurveLength();
    }

    public PskPublicInformation getHint() {
        return this.hint;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.hint.isEmpty()) {
            sb.append("\t\tPSK Identity Hint: ").append("psk hint not present");
        } else {
            sb.append("\t\tPSK Identity Hint: ").append(this.hint);
        }
        sb.append(StringUtil.lineSeparator());
        sb.append(super.toString());
        return sb.toString();
    }
}

