/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

public class Statistic {
    private final long slotWidth;
    private final AtomicLong[] statistic;
    private final AtomicLong maximum = new AtomicLong();

    public Statistic(long range, long slot) {
        int size = (int)(range / slot) + 1;
        this.statistic = new AtomicLong[size];
        for (int index = 0; index < size; ++index) {
            this.statistic[index] = new AtomicLong();
        }
        this.slotWidth = slot;
    }

    public void add(long value) {
        if (value >= 0L) {
            int index = (int)(value / this.slotWidth);
            if (index < this.statistic.length) {
                this.statistic[index].incrementAndGet();
            } else {
                this.statistic[this.statistic.length - 1].incrementAndGet();
            }
            long maximumValue = this.maximum.get();
            while (value > maximumValue && !this.maximum.compareAndSet(maximumValue, value)) {
                maximumValue = this.maximum.get();
            }
        }
    }

    private long getUpperLimit(int index) {
        if (this.slotWidth > 1L) {
            return (long)(index + 1) * this.slotWidth - 1L;
        }
        return index;
    }

    public boolean available() {
        for (int index = 0; index < this.statistic.length; ++index) {
            if (this.statistic[index].get() <= 0L) continue;
            return true;
        }
        return false;
    }

    public String getSummaryAsText() {
        return this.getSummary(950, 990, 999).toString();
    }

    public Summary getSummary(int ... percentiles) {
        long sum = 0L;
        long count = 0L;
        for (int index = 0; index < this.statistic.length; ++index) {
            long hits = this.statistic[index].get();
            if (hits <= 0L) continue;
            count += hits;
            if ((sum += hits * this.getUpperLimit(index)) >= 0L) continue;
            throw new IllegalStateException();
        }
        if (count > 0L) {
            long max = this.maximum.get();
            long[] values = null;
            if (percentiles != null) {
                values = new long[percentiles.length];
                if (percentiles.length > 0) {
                    Arrays.sort(percentiles);
                    int linesIndex = percentiles.length - 1;
                    if (percentiles[linesIndex] < 0 || percentiles[linesIndex] > 999) {
                        throw new IllegalArgumentException("line " + percentiles[linesIndex] + " is not in [0...999]%%");
                    }
                    long line = count * (long)(1000 - percentiles[linesIndex]) / 1000L;
                    long downCount = 0L;
                    for (int index = this.statistic.length - 1; index >= 0; --index) {
                        long hits = this.statistic[index].get();
                        if (hits <= 0L) continue;
                        long next = downCount + hits;
                        while (downCount <= line && next > line) {
                            long value = this.getUpperLimit(index);
                            if (value > max) {
                                value = max;
                            }
                            values[linesIndex] = value;
                            if (--linesIndex < 0) break;
                            if (percentiles[linesIndex] < 0 || percentiles[linesIndex] > 999) {
                                throw new IllegalArgumentException("line " + percentiles[linesIndex] + " is not in [0...999]%%");
                            }
                            line = count * (long)(1000 - percentiles[linesIndex]) / 1000L;
                        }
                        if (linesIndex < 0) break;
                        downCount = next;
                    }
                }
            }
            return new Summary((int)count, sum / count, max, percentiles, values);
        }
        return new Summary();
    }

    public static interface Scale {
        public long scale(long var1);
    }

    public static class Summary {
        final int count;
        final long average;
        final long maximum;
        final int[] percentiles;
        final long[] values;

        public Summary() {
            this.count = 0;
            this.average = 0L;
            this.maximum = 0L;
            this.percentiles = null;
            this.values = null;
        }

        public Summary(int count, long average, long maximum, int[] percentiles, long[] values) {
            if (percentiles != null) {
                if (values == null) {
                    throw new NullPointerException("values must not be null, if percentiles are provided!");
                }
                if (percentiles.length != values.length) {
                    throw new IllegalArgumentException("Number of values must match percentiles! " + percentiles.length + " != " + values.length);
                }
            }
            this.count = count;
            this.average = average;
            this.maximum = maximum;
            this.percentiles = percentiles;
            this.values = values;
        }

        public Summary(Summary raw, Scale scale) {
            this.count = raw.count;
            this.average = scale.scale(raw.average);
            this.maximum = scale.scale(raw.maximum);
            this.percentiles = raw.percentiles;
            if (raw.values != null) {
                int numOfValues = raw.values.length;
                this.values = new long[numOfValues];
                for (int index = 0; index < numOfValues; ++index) {
                    this.values[index] = scale.scale(raw.values[index]);
                }
            } else {
                this.values = null;
            }
        }

        public int getCount() {
            return this.count;
        }

        public long getAverage() {
            return this.average;
        }

        public long getMaximum() {
            return this.maximum;
        }

        public int getPercentileCount() {
            return this.percentiles != null ? this.percentiles.length : 0;
        }

        public long getPercentilePerMill(int index) {
            return this.percentiles != null ? (long)this.percentiles[index] : -1L;
        }

        public long getPercentileValue(int index) {
            return this.values != null ? this.values[index] : -1L;
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String unit) {
            if (this.count > 0) {
                StringBuilder summary = new StringBuilder();
                summary.append(String.format("all: %d, avg.: %d%s", this.count, this.average, unit));
                if (this.percentiles != null) {
                    for (int index = 0; index < this.percentiles.length; ++index) {
                        int p = this.percentiles[index] / 10;
                        int pm = this.percentiles[index] % 10;
                        if (pm > 0) {
                            summary.append(String.format(", %d.%d%%: %d%s", p, pm, this.values[index], unit));
                            continue;
                        }
                        summary.append(String.format(", %d%%: %d%s", p, this.values[index], unit));
                    }
                }
                summary.append(String.format(", max.: %d%s", this.maximum, unit));
                return summary.toString();
            }
            return "no values available!";
        }
    }
}

