/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.tcp.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.channel.pool.AbstractChannelPoolMap;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;
import org.eclipse.californium.elements.exception.EndpointMismatchException;
import org.eclipse.californium.elements.exception.MulticastNotSupportedException;
import org.eclipse.californium.elements.tcp.netty.CloseOnErrorHandler;
import org.eclipse.californium.elements.tcp.netty.CloseOnIdleHandler;
import org.eclipse.californium.elements.tcp.netty.DatagramFramer;
import org.eclipse.californium.elements.tcp.netty.DispatchHandler;
import org.eclipse.californium.elements.tcp.netty.TcpContextUtil;
import org.eclipse.californium.elements.util.DaemonThreadFactory;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpClientConnector
implements Connector {
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger();
    private static final ThreadGroup TCP_THREAD_GROUP = new ThreadGroup("Californium/TCP-Client");
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final int numberOfThreads;
    private final int connectionIdleTimeoutSeconds;
    private final int connectTimeoutMillis;
    private final InetSocketAddress localSocketAddress = new InetSocketAddress(0);
    private volatile EndpointContextMatcher endpointContextMatcher;
    private EventLoopGroup workerGroup;
    private RawDataChannel rawDataChannel;
    private AbstractChannelPoolMap<SocketAddress, ChannelPool> poolMap;
    protected final TcpContextUtil contextUtil;

    public TcpClientConnector(int numberOfThreads, int connectTimeoutMillis, int idleTimeout) {
        this(numberOfThreads, connectTimeoutMillis, idleTimeout, new TcpContextUtil());
    }

    protected TcpClientConnector(int numberOfThreads, int connectTimeoutMillis, int idleTimeout, TcpContextUtil contextUtil) {
        this.numberOfThreads = numberOfThreads;
        this.connectionIdleTimeoutSeconds = idleTimeout;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.contextUtil = contextUtil;
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.rawDataChannel == null) {
            throw new IllegalStateException("Cannot start without message handler.");
        }
        if (this.workerGroup != null) {
            throw new IllegalStateException("Connector already started");
        }
        this.workerGroup = new NioEventLoopGroup(this.numberOfThreads, new DaemonThreadFactory("TCP-Client-" + THREAD_COUNTER.incrementAndGet() + "#", TCP_THREAD_GROUP));
        this.poolMap = new AbstractChannelPoolMap<SocketAddress, ChannelPool>(){

            @Override
            protected ChannelPool newPool(SocketAddress key) {
                Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(TcpClientConnector.this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.AUTO_READ, true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, TcpClientConnector.this.connectTimeoutMillis)).remoteAddress(key);
                return new FixedChannelPool(bootstrap, (ChannelPoolHandler)new MyChannelPoolHandler(key), 1);
            }
        };
    }

    @Override
    public synchronized void stop() {
        if (this.poolMap != null) {
            this.poolMap.close();
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully(50L, 500L, TimeUnit.MILLISECONDS).syncUninterruptibly();
            this.workerGroup = null;
        }
    }

    @Override
    public void destroy() {
        this.stop();
    }

    @Override
    public void send(final RawData msg) {
        if (msg == null) {
            throw new NullPointerException("Message must not be null");
        }
        if (msg.isMulticast()) {
            this.LOGGER.warn("TcpConnector drops {} bytes to multicast {}:{}", msg.getSize(), msg.getAddress(), msg.getPort());
            msg.onError(new MulticastNotSupportedException("TCP doesn't support multicast!"));
            return;
        }
        if (this.workerGroup == null) {
            msg.onError(new IllegalStateException("TCP client connector not running!"));
            return;
        }
        InetSocketAddress addressKey = msg.getInetSocketAddress();
        boolean connected = this.poolMap.contains(addressKey);
        final EndpointContextMatcher endpointMatcher = this.getEndpointContextMatcher();
        if (endpointMatcher != null && !connected && !endpointMatcher.isToBeSent(msg.getEndpointContext(), null)) {
            this.LOGGER.warn("TcpConnector drops {} bytes to new {}:{}", msg.getSize(), msg.getAddress(), msg.getPort());
            msg.onError(new EndpointMismatchException("no connection"));
            return;
        }
        if (!connected) {
            msg.onConnecting();
        }
        final ChannelPool channelPool = this.poolMap.get(addressKey);
        Future<Channel> acquire = channelPool.acquire();
        acquire.addListener(new GenericFutureListener<Future<Channel>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(Future<Channel> future) throws Exception {
                Throwable cause = null;
                if (future.isSuccess()) {
                    Channel channel = future.getNow();
                    try {
                        TcpClientConnector.this.send(channel, endpointMatcher, msg);
                    }
                    catch (Throwable t) {
                        cause = t;
                    }
                    finally {
                        try {
                            channelPool.release(channel);
                        }
                        catch (RejectedExecutionException e) {
                            TcpClientConnector.this.LOGGER.debug("{}", (Object)e.getMessage());
                        }
                    }
                } else {
                    cause = future.isCancelled() ? new CancellationException() : future.cause();
                }
                if (cause != null) {
                    if (cause instanceof ConnectTimeoutException) {
                        TcpClientConnector.this.LOGGER.debug("{}", (Object)cause.getMessage());
                    } else if (cause instanceof CancellationException) {
                        TcpClientConnector.this.LOGGER.debug("{}", (Object)cause.getMessage());
                    } else {
                        TcpClientConnector.this.LOGGER.warn("Unable to open connection to {}", (Object)msg.getAddress(), (Object)future.cause());
                    }
                    msg.onError(future.cause());
                }
            }
        });
    }

    protected void send(Channel channel, EndpointContextMatcher endpointMatcher, final RawData msg) {
        EndpointContext context = this.contextUtil.buildEndpointContext(channel);
        if (endpointMatcher != null && !endpointMatcher.isToBeSent(msg.getEndpointContext(), context)) {
            this.LOGGER.warn("TcpConnector drops {} bytes to {}:{}", msg.getSize(), msg.getAddress(), msg.getPort());
            msg.onError(new EndpointMismatchException());
            return;
        }
        msg.onContextEstablished(context);
        ChannelFuture channelFuture = channel.writeAndFlush(Unpooled.wrappedBuffer(msg.getBytes()));
        channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<ChannelFuture>(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    msg.onSent();
                } else if (future.isCancelled()) {
                    msg.onError(new CancellationException());
                } else {
                    TcpClientConnector.this.LOGGER.warn("TcpConnector drops {} bytes to {}:{} caused by", msg.getSize(), msg.getAddress(), msg.getPort(), future.cause());
                    msg.onError(future.cause());
                }
            }
        });
    }

    @Override
    public void setRawDataReceiver(RawDataChannel messageHandler) {
        if (this.rawDataChannel != null) {
            throw new IllegalStateException("Raw data channel already set.");
        }
        this.rawDataChannel = messageHandler;
    }

    @Override
    public void setEndpointContextMatcher(EndpointContextMatcher matcher) {
        this.endpointContextMatcher = matcher;
    }

    private EndpointContextMatcher getEndpointContextMatcher() {
        return this.endpointContextMatcher;
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.localSocketAddress;
    }

    protected void onNewChannelCreated(SocketAddress remote, Channel ch) {
    }

    @Override
    public String getProtocol() {
        return "TCP";
    }

    public String toString() {
        return this.getProtocol() + "-" + StringUtil.toString(this.getAddress());
    }

    static {
        TCP_THREAD_GROUP.setDaemon(false);
    }

    private class RemoveEmptyPoolHandler
    extends ChannelDuplexHandler {
        private final AbstractChannelPoolMap<SocketAddress, ChannelPool> poolMap;
        private final SocketAddress key;

        RemoveEmptyPoolHandler(AbstractChannelPoolMap<SocketAddress, ChannelPool> poolMap, SocketAddress key) {
            this.poolMap = poolMap;
            this.key = key;
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (this.poolMap.remove(this.key)) {
                TcpClientConnector.this.LOGGER.trace("removed channel pool for {}", (Object)this.key);
            }
        }
    }

    private class MyChannelPoolHandler
    extends AbstractChannelPoolHandler {
        private final SocketAddress key;

        MyChannelPoolHandler(SocketAddress key) {
            this.key = key;
        }

        @Override
        public void channelCreated(Channel ch) throws Exception {
            TcpClientConnector.this.LOGGER.debug("new channel to {}", (Object)this.key);
            TcpClientConnector.this.onNewChannelCreated(this.key, ch);
            ch.pipeline().addLast(new IdleStateHandler(0, 0, TcpClientConnector.this.connectionIdleTimeoutSeconds));
            ch.pipeline().addLast(new CloseOnIdleHandler());
            ch.pipeline().addLast(new RemoveEmptyPoolHandler(TcpClientConnector.this.poolMap, this.key));
            ch.pipeline().addLast(new DatagramFramer(TcpClientConnector.this.contextUtil));
            ch.pipeline().addLast(new DispatchHandler(TcpClientConnector.this.rawDataChannel));
            ch.pipeline().addLast(new CloseOnErrorHandler());
        }
    }
}

