/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateRequest;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateVerify;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdExtension;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhEcdsaServerKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskClientKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskServerKeyExchange;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeState;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.HelloVerifyRequest;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.PSKClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.RecordSizeLimitExtension;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.ServerHelloDone;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;

@NoPublicAPI
public class ClientHandshaker
extends Handshaker {
    protected static HandshakeState[] SEVER_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.HELLO_VERIFY_REQUEST, true), new HandshakeState(HandshakeType.SERVER_HELLO), new HandshakeState(HandshakeType.CERTIFICATE), new HandshakeState(HandshakeType.SERVER_KEY_EXCHANGE), new HandshakeState(HandshakeType.CERTIFICATE_REQUEST, true), new HandshakeState(HandshakeType.SERVER_HELLO_DONE), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private static HandshakeState[] NO_SEVER_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.HELLO_VERIFY_REQUEST, true), new HandshakeState(HandshakeType.SERVER_HELLO), new HandshakeState(HandshakeType.SERVER_KEY_EXCHANGE, true), new HandshakeState(HandshakeType.SERVER_HELLO_DONE), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private ProtocolVersion maxProtocolVersion = ProtocolVersion.VERSION_DTLS_1_2;
    private boolean probe;
    private PublicKey serverPublicKey;
    protected ECDHServerKeyExchange serverKeyExchange;
    protected ClientKeyExchange clientKeyExchange;
    protected ClientHello clientHello = null;
    private final List<CipherSuite> supportedCipherSuites;
    protected final List<XECDHECryptography.SupportedGroup> supportedGroups;
    protected final Integer maxFragmentLengthCode;
    protected final boolean truncateCertificatePath;
    protected final List<CertificateType> supportedClientCertificateTypes;
    protected final List<SignatureAndHashAlgorithm> supportedSignatureAlgorithms;
    protected final List<CertificateType> supportedServerCertificateTypes;
    protected CertificateRequest certificateRequest = null;
    protected byte[] handshakeHash = null;
    protected ServerNames indicatedServerNames;
    protected SignatureAndHashAlgorithm negotiatedSignatureAndHashAlgorithm;

    public ClientHandshaker(DTLSSession session, RecordLayer recordLayer, ScheduledExecutorService timer, Connection connection, DtlsConnectorConfig config, boolean probe) {
        super(true, 0, session, recordLayer, timer, connection, config);
        this.supportedCipherSuites = config.getSupportedCipherSuites();
        this.supportedGroups = config.getSupportedGroups();
        this.maxFragmentLengthCode = config.getMaxFragmentLengthCode();
        this.truncateCertificatePath = config.useTruncatedCertificatePathForClientsCertificateMessage();
        this.supportedServerCertificateTypes = config.getTrustCertificateTypes();
        this.supportedClientCertificateTypes = config.getIdentityCertificateTypes();
        this.supportedSignatureAlgorithms = config.getSupportedSignatureAlgorithms();
        this.probe = probe;
    }

    @Override
    protected void doProcessMessage(HandshakeMessage message) throws HandshakeException, GeneralSecurityException {
        block0 : switch (message.getMessageType()) {
            case HELLO_VERIFY_REQUEST: {
                this.receivedHelloVerifyRequest((HelloVerifyRequest)message);
                break;
            }
            case SERVER_HELLO: {
                this.receivedServerHello((ServerHello)message);
                break;
            }
            case CERTIFICATE: {
                this.receivedServerCertificate((CertificateMessage)message);
                break;
            }
            case SERVER_KEY_EXCHANGE: {
                switch (this.session.getKeyExchange()) {
                    case EC_DIFFIE_HELLMAN: {
                        this.receivedServerKeyExchange((EcdhEcdsaServerKeyExchange)message);
                        break block0;
                    }
                    case PSK: {
                        break block0;
                    }
                    case ECDHE_PSK: {
                        this.serverKeyExchange = (EcdhPskServerKeyExchange)message;
                        break block0;
                    }
                    case NULL: {
                        this.LOGGER.info("Received unexpected ServerKeyExchange message in NULL key exchange mode.");
                        break block0;
                    }
                }
                throw new HandshakeException(String.format("Unsupported key exchange algorithm %s", this.session.getKeyExchange().name()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, message.getPeer()));
            }
            case CERTIFICATE_REQUEST: {
                this.certificateRequest = (CertificateRequest)message;
                break;
            }
            case SERVER_HELLO_DONE: {
                this.receivedServerHelloDone((ServerHelloDone)message);
                break;
            }
            case FINISHED: {
                this.receivedServerFinished((Finished)message);
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected handshake message [%s] from peer %s", new Object[]{message.getMessageType(), message.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, message.getPeer()));
            }
        }
    }

    private void receivedServerFinished(Finished message) throws HandshakeException, GeneralSecurityException {
        message.verifyData(this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, false, this.handshakeHash);
        this.sessionEstablished();
        this.handshakeCompleted();
    }

    protected void receivedHelloVerifyRequest(HelloVerifyRequest message) throws HandshakeException {
        this.handshakeMessages.clear();
        this.clientHello.setCookie(message.getCookie());
        this.flightNumber = 3;
        DTLSFlight flight = this.createFlight();
        this.wrapMessage(flight, this.clientHello);
        this.sendFlight(flight);
        --this.statesIndex;
    }

    protected void receivedServerHello(ServerHello message) throws HandshakeException {
        ConnectionIdExtension extension;
        this.usedProtocol = message.getServerVersion();
        this.serverRandom = message.getRandom();
        this.session.setSessionIdentifier(message.getSessionId());
        CipherSuite cipherSuite = message.getCipherSuite();
        if (!this.supportedCipherSuites.contains((Object)cipherSuite)) {
            throw new HandshakeException("Server wants to use not supported cipher suite " + (Object)((Object)cipherSuite), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, message.getPeer()));
        }
        this.session.setCipherSuite(cipherSuite);
        CompressionMethod compressionMethod = message.getCompressionMethod();
        if (compressionMethod != CompressionMethod.NULL) {
            throw new HandshakeException("Server wants to use not supported compression method " + (Object)((Object)compressionMethod), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, message.getPeer()));
        }
        this.session.setCompressionMethod(message.getCompressionMethod());
        this.verifyServerHelloExtensions(message);
        if (this.connectionIdGenerator != null && (extension = message.getConnectionIdExtension()) != null) {
            ConnectionId connectionId = extension.getConnectionId();
            this.session.setWriteConnectionId(connectionId);
            this.session.setReadConnectionId(this.getReadConnectionId());
        }
        this.session.setSendCertificateType(message.getClientCertificateType());
        this.session.setSniSupported(message.hasServerNameExtension());
        this.session.setParameterAvailable();
        if (!cipherSuite.requiresServerCertificateMessage()) {
            this.states = NO_SEVER_CERTIFICATE;
        }
    }

    protected void verifyServerHelloExtensions(ServerHello message) throws HandshakeException {
        CertificateType serverCertificateType;
        MaxFragmentLengthExtension maxFragmentLengthExtension;
        SupportedPointFormatsExtension pointFormatsExtension;
        HelloExtensions serverExtensions = message.getExtensions();
        if (serverExtensions != null && !serverExtensions.isEmpty()) {
            HelloExtensions clientExtensions = this.clientHello.getExtensions();
            if (clientExtensions == null || clientExtensions.isEmpty()) {
                throw new HandshakeException("Server wants extensions, but client not!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_EXTENSION, message.getPeer()));
            }
            for (HelloExtension serverExtension : serverExtensions.getExtensions()) {
                if (clientExtensions.getExtension(serverExtension.getType()) != null) continue;
                throw new HandshakeException("Server wants " + (Object)((Object)serverExtension.getType()) + ", but client not!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_EXTENSION, message.getPeer()));
            }
        }
        if ((pointFormatsExtension = message.getSupportedPointFormatsExtension()) != null && !pointFormatsExtension.contains(SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED)) {
            throw new HandshakeException("Server wants to use only not supported EC point formats!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, message.getPeer()));
        }
        RecordSizeLimitExtension recordSizeLimitExt = message.getRecordSizeLimit();
        if (recordSizeLimitExt != null) {
            this.session.setRecordSizeLimit(recordSizeLimitExt.getRecordSizeLimit());
        }
        if ((maxFragmentLengthExtension = message.getMaxFragmentLength()) != null) {
            if (recordSizeLimitExt != null) {
                throw new HandshakeException("Server wants to use record size limit and max. fragment size", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, message.getPeer()));
            }
            MaxFragmentLengthExtension.Length maxFragmentLength = maxFragmentLengthExtension.getFragmentLength();
            if (maxFragmentLength.code() == this.maxFragmentLengthCode.intValue()) {
                this.session.setMaxFragmentLength(maxFragmentLength.length());
            } else {
                throw new HandshakeException("Server wants to use other max. fragment size than proposed", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, message.getPeer()));
            }
        }
        if (!ClientHandshaker.isSupportedCertificateType(serverCertificateType = message.getServerCertificateType(), this.supportedServerCertificateTypes)) {
            throw new HandshakeException("Server wants to use not supported server certificate type " + (Object)((Object)serverCertificateType), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, message.getPeer()));
        }
        this.session.setReceiveCertificateType(serverCertificateType);
    }

    private void receivedServerCertificate(CertificateMessage message) throws HandshakeException {
        if (message.isEmpty()) {
            this.LOGGER.debug("Certificate validation failed: empty server certificate!");
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, this.session.getPeer());
            throw new HandshakeException("Empty server certificate!", alert);
        }
        this.verifyCertificate(message);
        this.serverPublicKey = message.getPublicKey();
    }

    private void receivedServerKeyExchange(EcdhEcdsaServerKeyExchange message) throws HandshakeException {
        message.verifySignature(this.serverPublicKey, this.clientRandom, this.serverRandom);
        if (this.peerCertPath != null) {
            this.session.setPeerIdentity(new X509CertPath(this.peerCertPath));
        } else {
            this.session.setPeerIdentity(new RawPublicKeyIdentity(this.serverPublicKey));
        }
        this.serverKeyExchange = message;
    }

    private void receivedServerHelloDone(ServerHelloDone message) throws HandshakeException, GeneralSecurityException {
        this.flightNumber += 2;
        XECDHECryptography ecdhe = this.serverKeyExchange == null ? null : new XECDHECryptography(this.serverKeyExchange.getSupportedGroup());
        switch (this.session.getKeyExchange()) {
            case EC_DIFFIE_HELLMAN: {
                this.clientKeyExchange = new ECDHClientKeyExchange(ecdhe.getEncodedPoint(), this.session.getPeer());
                SecretKey premasterSecret = ecdhe.generateSecret(this.serverKeyExchange.getEncodedPoint());
                SecretKey masterSecret = PseudoRandomFunction.generateMasterSecret(this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), premasterSecret, this.generateRandomSeed());
                SecretUtil.destroy(premasterSecret);
                this.processMasterSecret(masterSecret);
                break;
            }
            case PSK: {
                PskPublicInformation clientIdentity = this.getPskClientIdentity();
                this.LOGGER.trace("Using PSK identity: {}", (Object)clientIdentity);
                this.clientKeyExchange = new PSKClientKeyExchange(clientIdentity, this.session.getPeer());
                PskSecretResult masterSecretResult = this.requestPskSecretResult(clientIdentity, null);
                if (masterSecretResult == null) break;
                this.processPskSecretResult(masterSecretResult);
                break;
            }
            case ECDHE_PSK: {
                PskPublicInformation clientIdentity = this.getPskClientIdentity();
                this.LOGGER.trace("Using ECDHE PSK identity: {}", (Object)clientIdentity);
                this.clientKeyExchange = new EcdhPskClientKeyExchange(clientIdentity, ecdhe.getEncodedPoint(), this.session.getPeer());
                SecretKey otherSecret = ecdhe.generateSecret(this.serverKeyExchange.getEncodedPoint());
                PskSecretResult masterSecretResult = this.requestPskSecretResult(clientIdentity, otherSecret);
                SecretUtil.destroy(otherSecret);
                if (masterSecretResult == null) break;
                this.processPskSecretResult(masterSecretResult);
                break;
            }
            default: {
                throw new HandshakeException("Unknown key exchange algorithm: " + (Object)((Object)this.session.getKeyExchange()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer()));
            }
        }
        SecretUtil.destroy(ecdhe);
    }

    @Override
    protected void processMasterSecret(SecretKey masterSecret) throws HandshakeException {
        this.applyMasterSecret(masterSecret);
        SecretUtil.destroy(masterSecret);
        if (this.states != SEVER_CERTIFICATE || this.certificateVerfied) {
            this.processServerHelloDone();
        }
    }

    @Override
    protected void processCertificateVerified() throws HandshakeException {
        if (this.masterSecret != null) {
            this.processServerHelloDone();
        }
    }

    private void processServerHelloDone() throws HandshakeException {
        MessageDigest mdWithClientFinished;
        DTLSFlight flight = this.createFlight();
        this.createCertificateMessage(flight);
        this.wrapMessage(flight, this.clientKeyExchange);
        if (this.certificateRequest != null && this.negotiatedSignatureAndHashAlgorithm != null) {
            CertificateType clientCertificateType = this.session.sendCertificateType();
            if (!ClientHandshaker.isSupportedCertificateType(clientCertificateType, this.supportedClientCertificateTypes)) {
                throw new HandshakeException("Server wants to use not supported client certificate type " + (Object)((Object)clientCertificateType), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, this.session.getPeer()));
            }
            CertificateVerify certificateVerify = new CertificateVerify(this.negotiatedSignatureAndHashAlgorithm, this.privateKey, this.handshakeMessages, this.session.getPeer());
            this.wrapMessage(flight, certificateVerify);
        }
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage(this.session.getPeer());
        this.wrapMessage(flight, changeCipherSpecMessage);
        this.setCurrentWriteState();
        MessageDigest md = this.getHandshakeMessageDigest();
        try {
            mdWithClientFinished = (MessageDigest)md.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HandshakeException("Cannot create FINISHED message", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.session.getPeer()));
        }
        Finished finished = new Finished(this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, this.isClient, md.digest(), this.session.getPeer());
        this.wrapMessage(flight, finished);
        mdWithClientFinished.update(finished.toByteArray());
        this.handshakeHash = mdWithClientFinished.digest();
        this.sendFlight(flight);
        this.expectChangeCipherSpecMessage();
    }

    protected void createCertificateMessage(DTLSFlight flight) throws HandshakeException {
        if (this.certificateRequest != null) {
            CertificateMessage clientCertificate;
            List<SignatureAndHashAlgorithm> supported = this.supportedSignatureAlgorithms;
            if (supported.isEmpty()) {
                supported = SignatureAndHashAlgorithm.DEFAULT;
            }
            this.certificateRequest.selectSignatureAlgorithms(supported);
            if (CertificateType.RAW_PUBLIC_KEY == this.session.sendCertificateType()) {
                PublicKey publicKey = this.publicKey;
                if (publicKey != null) {
                    this.negotiatedSignatureAndHashAlgorithm = this.certificateRequest.getSignatureAndHashAlgorithm(publicKey);
                    if (this.negotiatedSignatureAndHashAlgorithm == null) {
                        publicKey = null;
                    }
                }
                if (this.LOGGER.isDebugEnabled()) {
                    byte[] raw = publicKey == null ? Bytes.EMPTY : publicKey.getEncoded();
                    this.LOGGER.debug("sending CERTIFICATE message with client RawPublicKey [{}] to server", (Object)StringUtil.byteArray2HexString(raw));
                }
                clientCertificate = new CertificateMessage(publicKey, this.session.getPeer());
            } else if (CertificateType.X_509 == this.session.sendCertificateType()) {
                List clientChain = Collections.emptyList();
                if (this.certificateChain != null) {
                    this.negotiatedSignatureAndHashAlgorithm = this.certificateRequest.getSignatureAndHashAlgorithm(this.certificateChain);
                    if (this.negotiatedSignatureAndHashAlgorithm != null) {
                        clientChain = this.certificateChain;
                    }
                }
                List<X500Principal> authorities = this.truncateCertificatePath ? this.certificateRequest.getCertificateAuthorities() : null;
                clientCertificate = new CertificateMessage(clientChain, authorities, this.session.getPeer());
            } else {
                throw new IllegalArgumentException("Certificate type " + (Object)((Object)this.session.sendCertificateType()) + " not supported!");
            }
            this.wrapMessage(flight, clientCertificate);
        }
    }

    protected static boolean isSupportedCertificateType(CertificateType certType, List<CertificateType> supportedCertificateTypes) {
        if (supportedCertificateTypes != null) {
            return supportedCertificateTypes.contains((Object)certType);
        }
        return certType == CertificateType.X_509;
    }

    @Override
    public void startHandshake() throws HandshakeException {
        this.handshakeStarted();
        ClientHello startMessage = new ClientHello(this.maxProtocolVersion, this.supportedCipherSuites, this.supportedSignatureAlgorithms, this.supportedClientCertificateTypes, this.supportedServerCertificateTypes, this.supportedGroups, this.session.getPeer());
        this.clientRandom = startMessage.getRandom();
        startMessage.addCompressionMethod(CompressionMethod.NULL);
        this.addConnectionId(startMessage);
        this.addRecordSizeLimit(startMessage);
        this.addMaxFragmentLength(startMessage);
        this.addServerNameIndication(startMessage);
        this.flightNumber = 1;
        this.clientHello = startMessage;
        DTLSFlight flight = this.createFlight();
        this.wrapMessage(flight, startMessage);
        this.sendFlight(flight);
        this.states = SEVER_CERTIFICATE;
        this.statesIndex = 0;
    }

    protected void addRecordSizeLimit(ClientHello helloMessage) {
        if (this.recordSizeLimit != null) {
            RecordSizeLimitExtension ext = new RecordSizeLimitExtension(this.recordSizeLimit);
            helloMessage.addExtension(ext);
            this.LOGGER.debug("Indicating record size limit [{}] to server [{}]", (Object)this.recordSizeLimit, (Object)this.getPeerAddress());
        }
    }

    protected void addMaxFragmentLength(ClientHello helloMessage) {
        if (this.maxFragmentLengthCode != null) {
            MaxFragmentLengthExtension ext = new MaxFragmentLengthExtension(this.maxFragmentLengthCode);
            helloMessage.addExtension(ext);
            this.LOGGER.debug("Indicating max. fragment length [{}] to server [{}]", (Object)this.maxFragmentLengthCode, (Object)this.getPeerAddress());
        }
    }

    protected void addConnectionId(ClientHello helloMessage) {
        if (this.connectionIdGenerator != null) {
            ConnectionId connectionId = this.connectionIdGenerator.useConnectionId() ? this.getConnection().getConnectionId() : ConnectionId.EMPTY;
            ConnectionIdExtension extension = ConnectionIdExtension.fromConnectionId(connectionId);
            helloMessage.addExtension(extension);
        }
    }

    protected void addServerNameIndication(ClientHello helloMessage) {
        if (this.sniEnabled && this.session.getServerNames() != null) {
            this.LOGGER.debug("adding SNI extension to CLIENT_HELLO message [{}]", (Object)this.session.getHostName());
            helloMessage.addExtension(ServerNameExtension.forServerNames(this.session.getServerNames()));
        }
    }

    protected PskPublicInformation getPskClientIdentity() throws HandshakeException {
        PskPublicInformation pskIdentity;
        ServerNames serverName;
        ServerNames serverNames = serverName = this.sniEnabled ? this.session.getServerNames() : null;
        if (serverName != null && !this.session.isSniSupported()) {
            this.LOGGER.warn("client is configured to use SNI but server does not support it, PSK authentication is likely to fail");
        }
        if ((pskIdentity = this.advancedPskStore.getIdentity(this.session.getPeer(), serverName)) == null) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
            if (serverName != null) {
                throw new HandshakeException(String.format("No Identity found for peer [address: %s, virtual host: %s]", this.session.getPeer(), this.session.getHostName()), alert);
            }
            throw new HandshakeException(String.format("No Identity found for peer [address: %s]", this.session.getPeer()), alert);
        }
        return pskIdentity;
    }

    @Override
    public boolean isProbing() {
        return this.probe;
    }

    @Override
    public void resetProbing() {
        this.probe = false;
    }

    @Override
    public boolean isRemovingConnection() {
        return !this.probe && super.isRemovingConnection();
    }
}

