/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkInterfacesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkInterfacesUtil.class);
    public static final int MAX_MTU = 65535;
    private static int anyMtu;
    private static boolean anyIpv4;
    private static boolean anyIpv6;
    private static Inet4Address broadcastIpv4;
    private static Inet4Address multicastInterfaceIpv4;
    private static Inet6Address multicastInterfaceIpv6;
    private static NetworkInterface multicastInterface;
    private static final Set<InetAddress> broadcastAddresses;

    private static synchronized void initialize() {
        if (anyMtu == 0) {
            broadcastAddresses.clear();
            broadcastIpv4 = null;
            multicastInterfaceIpv4 = null;
            multicastInterfaceIpv6 = null;
            multicastInterface = null;
            Inet4Address link4 = null;
            Inet4Address site4 = null;
            Inet6Address link6 = null;
            Inet6Address site6 = null;
            int mtu = 65535;
            Pattern filter = null;
            String regex = StringUtil.getConfiguration("COAP_NETWORK_INTERFACES");
            if (regex != null && !regex.isEmpty()) {
                filter = Pattern.compile(regex);
            }
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface iface = interfaces.nextElement();
                    if (!iface.isUp() || iface.isLoopback() || filter != null && !filter.matcher(iface.getName()).matches()) continue;
                    int ifaceMtu = iface.getMTU();
                    if (ifaceMtu > 0 && ifaceMtu < mtu) {
                        mtu = ifaceMtu;
                    }
                    if (multicastInterface == null && iface.supportsMulticast()) {
                        multicastInterface = iface;
                    }
                    Enumeration<InetAddress> inetAddresses = iface.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        InetAddress address = inetAddresses.nextElement();
                        if (address instanceof Inet4Address) {
                            anyIpv4 = true;
                            if (site4 != null || !iface.supportsMulticast()) continue;
                            if (address.isSiteLocalAddress()) {
                                site4 = (Inet4Address)address;
                                continue;
                            }
                            if (link4 != null || !address.isLinkLocalAddress()) continue;
                            link4 = (Inet4Address)address;
                            continue;
                        }
                        if (!(address instanceof Inet6Address)) continue;
                        anyIpv6 = true;
                        if (site6 != null || !iface.supportsMulticast()) continue;
                        if (address.isSiteLocalAddress()) {
                            site6 = (Inet6Address)address;
                            continue;
                        }
                        if (link4 != null || !address.isLinkLocalAddress()) continue;
                        link6 = (Inet6Address)address;
                    }
                    for (InterfaceAddress interfaceAddress : iface.getInterfaceAddresses()) {
                        InetAddress broadcast = interfaceAddress.getBroadcast();
                        if (broadcast == null || broadcast.isAnyLocalAddress()) continue;
                        broadcastAddresses.add(broadcast);
                        LOGGER.debug("Found broadcast address {} - {}.", (Object)broadcast, (Object)iface.getName());
                        if (broadcastIpv4 != null) continue;
                        broadcastIpv4 = (Inet4Address)broadcast;
                    }
                }
            }
            catch (SocketException ex) {
                LOGGER.warn("discover the <any> interface failed!", ex);
                anyIpv4 = true;
                anyIpv6 = true;
            }
            if (broadcastAddresses.isEmpty()) {
                LOGGER.info("no broadcast address found!");
            }
            multicastInterfaceIpv4 = site4 == null ? link4 : site4;
            multicastInterfaceIpv6 = site6 == null ? link6 : site6;
            anyMtu = mtu;
        }
    }

    public static int getAnyMtu() {
        NetworkInterfacesUtil.initialize();
        return anyMtu;
    }

    public static boolean isAnyIpv4() {
        NetworkInterfacesUtil.initialize();
        return anyIpv4;
    }

    public static boolean isAnyIpv6() {
        NetworkInterfacesUtil.initialize();
        return anyIpv6;
    }

    public static Inet4Address getBroadcastIpv4() {
        NetworkInterfacesUtil.initialize();
        return broadcastIpv4;
    }

    public static Inet4Address getMulticastInterfaceIpv4() {
        NetworkInterfacesUtil.initialize();
        return multicastInterfaceIpv4;
    }

    public static Inet6Address getMulticastInterfaceIpv6() {
        NetworkInterfacesUtil.initialize();
        return multicastInterfaceIpv6;
    }

    public static NetworkInterface getMulticastInterface() {
        NetworkInterfacesUtil.initialize();
        return multicastInterface;
    }

    public static Collection<InetAddress> getNetworkInterfaces() {
        LinkedList<InetAddress> interfaces = new LinkedList<InetAddress>();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            while (nets.hasMoreElements()) {
                NetworkInterface networkInterface = nets.nextElement();
                if (!networkInterface.isUp()) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    interfaces.add(inetAddresses.nextElement());
                }
            }
        }
        catch (SocketException e) {
            LOGGER.error("could not fetch all interface addresses", e);
        }
        return interfaces;
    }

    public static boolean isBroadcastAddress(InetAddress address) {
        NetworkInterfacesUtil.initialize();
        return broadcastAddresses.contains(address);
    }

    public static boolean isMultiAddress(InetAddress address) {
        NetworkInterfacesUtil.initialize();
        return address != null && (address.isMulticastAddress() || broadcastAddresses.contains(address));
    }

    static {
        broadcastAddresses = new HashSet<InetAddress>();
    }
}

