/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

public final class SignatureAndHashAlgorithm {
    private final HashAlgorithm hash;
    private final SignatureAlgorithm signature;
    private final int hashAlgorithmCode;
    private final int signatureAlgorithmCode;

    public SignatureAndHashAlgorithm(HashAlgorithm hashAlgorithm, SignatureAlgorithm signatureAlgorithm) {
        if (hashAlgorithm == null) {
            throw new NullPointerException("Hash Algorithm must not be null!");
        }
        if (signatureAlgorithm == null) {
            throw new NullPointerException("Signature Algorithm must not be null!");
        }
        this.hash = hashAlgorithm;
        this.signature = signatureAlgorithm;
        this.hashAlgorithmCode = hashAlgorithm.getCode();
        this.signatureAlgorithmCode = signatureAlgorithm.getCode();
    }

    public SignatureAndHashAlgorithm(int hashAlgorithmCode, int signatureAlgorithmCode) {
        this.hashAlgorithmCode = hashAlgorithmCode;
        this.signatureAlgorithmCode = signatureAlgorithmCode;
        this.signature = SignatureAlgorithm.getAlgorithmByCode(signatureAlgorithmCode);
        this.hash = HashAlgorithm.getAlgorithmByCode(hashAlgorithmCode);
    }

    public SignatureAlgorithm getSignature() {
        return this.signature;
    }

    public HashAlgorithm getHash() {
        return this.hash;
    }

    public String jcaName() {
        StringBuilder name = new StringBuilder();
        if (this.hash != null) {
            name.append((Object)this.hash);
        } else {
            name.append(String.format("0x%02x", this.hashAlgorithmCode));
        }
        name.append("with");
        if (this.signature != null) {
            name.append((Object)this.signature);
        } else {
            name.append(String.format("0x%02x", this.signatureAlgorithmCode));
        }
        return name.toString();
    }

    public static enum SignatureAlgorithm {
        ANONYMOUS(0),
        RSA(1),
        DSA(2),
        ECDSA(3);

        private int code;

        private SignatureAlgorithm(int code) {
            this.code = code;
        }

        public static SignatureAlgorithm getAlgorithmByCode(int code) {
            switch (code) {
                case 0: {
                    return ANONYMOUS;
                }
                case 1: {
                    return RSA;
                }
                case 2: {
                    return DSA;
                }
                case 3: {
                    return ECDSA;
                }
            }
            return null;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum HashAlgorithm {
        NONE(0),
        MD5(1),
        SHA1(2),
        SHA224(3),
        SHA256(4),
        SHA384(5),
        SHA512(6);

        private int code;

        private HashAlgorithm(int code) {
            this.code = code;
        }

        public static HashAlgorithm getAlgorithmByCode(int code) {
            for (HashAlgorithm algorithm : HashAlgorithm.values()) {
                if (algorithm.code != code) continue;
                return algorithm;
            }
            return null;
        }

        public int getCode() {
            return this.code;
        }
    }
}

