/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.GeneralSecurityException;

public class ThreadLocalCrypto<CryptoFunction> {
    private final Factory<CryptoFunction> factory;
    private final GeneralSecurityException exception;
    private final ThreadLocal<CryptoFunction> threadLocalFunction;

    public ThreadLocalCrypto(Factory<CryptoFunction> factory) {
        GeneralSecurityException exception = null;
        Factory<CryptoFunction> supportedfactory = null;
        ThreadLocal<CryptoFunction> threadLocalCipher = null;
        try {
            CryptoFunction function = factory.getInstance();
            if (function != null) {
                supportedfactory = factory;
                threadLocalCipher = new ThreadLocal<CryptoFunction>();
                threadLocalCipher.set(function);
            }
        }
        catch (GeneralSecurityException e) {
            exception = e;
        }
        this.threadLocalFunction = threadLocalCipher;
        this.factory = supportedfactory;
        this.exception = exception;
    }

    public CryptoFunction current() {
        if (!this.isSupported()) {
            return null;
        }
        CryptoFunction function = this.threadLocalFunction.get();
        if (function == null) {
            try {
                function = this.factory.getInstance();
                this.threadLocalFunction.set(function);
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
        }
        return function;
    }

    public final boolean isSupported() {
        return this.factory != null;
    }

    public final GeneralSecurityException getCause() {
        return this.exception;
    }

    public static interface Factory<CryptoFunction> {
        public CryptoFunction getInstance() throws GeneralSecurityException;
    }
}

