/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.elements.util.StringUtil;

public final class Utils {
    private Utils() {
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        return "[" + StringUtil.byteArray2Hex(bytes) + "]";
    }

    public static String toHexText(byte[] bytes, int length) {
        if (bytes == null) {
            return "null";
        }
        if (length > bytes.length) {
            length = bytes.length;
        }
        StringBuilder sb = new StringBuilder();
        if (16 < length) {
            sb.append(StringUtil.lineSeparator());
        }
        for (int index = 0; index < length; ++index) {
            sb.append(String.format("%02x", bytes[index] & 0xFF));
            if (31 == (0x1F & index)) {
                sb.append(StringUtil.lineSeparator());
                continue;
            }
            sb.append(' ');
        }
        if (length < bytes.length) {
            sb.append(" .. ").append(bytes.length).append(" bytes");
        }
        return sb.toString();
    }

    public static String prettyPrint(Request r) {
        StringBuilder sb = new StringBuilder();
        sb.append("==[ CoAP Request ]=============================================").append(StringUtil.lineSeparator());
        sb.append(String.format("MID    : %d", r.getMID())).append(StringUtil.lineSeparator());
        sb.append(String.format("Token  : %s", r.getTokenString())).append(StringUtil.lineSeparator());
        sb.append(String.format("Type   : %s", r.getType().toString())).append(StringUtil.lineSeparator());
        sb.append(String.format("Method : %s", r.getCode().toString())).append(StringUtil.lineSeparator());
        sb.append(String.format("Options: %s", r.getOptions().toString())).append(StringUtil.lineSeparator());
        sb.append(String.format("Payload: %d Bytes", r.getPayloadSize())).append(StringUtil.lineSeparator());
        if (r.getPayloadSize() > 0 && MediaTypeRegistry.isPrintable(r.getOptions().getContentFormat())) {
            sb.append("---------------------------------------------------------------").append(StringUtil.lineSeparator());
            sb.append(r.getPayloadString());
            sb.append(StringUtil.lineSeparator());
        }
        sb.append("===============================================================");
        return sb.toString();
    }

    public static String prettyPrint(CoapResponse r) {
        return Utils.prettyPrint(r.advanced());
    }

    public static String prettyPrint(Response r) {
        StringBuilder sb = new StringBuilder();
        sb.append("==[ CoAP Response ]============================================").append(StringUtil.lineSeparator());
        sb.append(String.format("MID    : %d", r.getMID())).append(StringUtil.lineSeparator());
        sb.append(String.format("Token  : %s", r.getTokenString())).append(StringUtil.lineSeparator());
        sb.append(String.format("Type   : %s", r.getType().toString())).append(StringUtil.lineSeparator());
        sb.append(String.format("Status : %s - %s", r.getCode().toString(), r.getCode().name())).append(StringUtil.lineSeparator());
        sb.append(String.format("Options: %s", r.getOptions().toString())).append(StringUtil.lineSeparator());
        if (r.getRTT() != null) {
            sb.append(String.format("RTT    : %d ms", r.getRTT())).append(StringUtil.lineSeparator());
        }
        sb.append(String.format("Payload: %d Bytes", r.getPayloadSize())).append(StringUtil.lineSeparator());
        if (r.getPayloadSize() > 0 && MediaTypeRegistry.isPrintable(r.getOptions().getContentFormat())) {
            sb.append("---------------------------------------------------------------").append(StringUtil.lineSeparator());
            sb.append(r.getPayloadString());
            sb.append(StringUtil.lineSeparator());
        }
        sb.append("===============================================================");
        return sb.toString();
    }
}

