/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.util.Arrays;
import java.util.List;
import javax.crypto.SecretKey;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateRequest;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CertificateVerify;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdExtension;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskClientKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskServerKeyExchange;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeState;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.PSKClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskUtil;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.ServerHelloDone;
import org.eclipse.californium.scandium.dtls.ServerKeyExchange;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedEllipticCurvesExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.ECDHECryptography;
import org.eclipse.californium.scandium.util.SecretUtil;

public class ServerHandshaker
extends Handshaker {
    private static HandshakeState[] CLIENT_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.CERTIFICATE), new HandshakeState(HandshakeType.CLIENT_KEY_EXCHANGE), new HandshakeState(HandshakeType.CERTIFICATE_VERIFY), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private static HandshakeState[] EMPTY_CLIENT_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.CERTIFICATE), new HandshakeState(HandshakeType.CLIENT_KEY_EXCHANGE), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    protected static HandshakeState[] NO_CLIENT_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.CLIENT_KEY_EXCHANGE), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private boolean useNoSessionId = false;
    private boolean clientAuthenticationWanted = false;
    private boolean clientAuthenticationRequired = false;
    private PublicKey clientPublicKey;
    private List<CipherSuite> supportedCipherSuites;
    private final List<CertificateType> supportedClientCertificateTypes;
    private final List<CertificateType> supportedServerCertificateTypes;
    private CertificateType negotiatedClientCertificateType;
    private CertificateType negotiatedServerCertificateType;
    private ECDHECryptography.SupportedGroup negotiatedSupportedGroup;
    private SignatureAndHashAlgorithm signatureAndHashAlgorithm;
    private CertificateMessage clientCertificate = null;
    private CertificateVerify certificateVerify = null;
    private PskPublicInformation preSharedKeyIdentity;

    public ServerHandshaker(int initialMessageSequenceNo, DTLSSession session, RecordLayer recordLayer, Connection connection, DtlsConnectorConfig config, int maxTransmissionUnit) {
        super(false, initialMessageSequenceNo, session, recordLayer, connection, config, maxTransmissionUnit);
        this.supportedCipherSuites = config.getSupportedCipherSuites();
        this.clientAuthenticationWanted = config.isClientAuthenticationWanted();
        this.clientAuthenticationRequired = config.isClientAuthenticationRequired();
        this.useNoSessionId = config.useNoServerSessionId();
        this.supportedClientCertificateTypes = config.getTrustCertificateTypes();
        this.supportedServerCertificateTypes = config.getIdentityCertificateTypes();
    }

    public PskPublicInformation getPreSharedKeyIdentity() {
        return this.preSharedKeyIdentity;
    }

    @Override
    protected void doProcessMessage(HandshakeMessage message) throws HandshakeException, GeneralSecurityException {
        switch (message.getMessageType()) {
            case CLIENT_HELLO: {
                this.receivedClientHello((ClientHello)message);
                break;
            }
            case CERTIFICATE: {
                this.receivedClientCertificate((CertificateMessage)message);
                break;
            }
            case CLIENT_KEY_EXCHANGE: {
                SecretKey premasterSecret;
                switch (this.getKeyExchangeAlgorithm()) {
                    case PSK: {
                        premasterSecret = this.receivedClientKeyExchange((PSKClientKeyExchange)message);
                        break;
                    }
                    case ECDHE_PSK: {
                        premasterSecret = this.receivedClientKeyExchange((EcdhPskClientKeyExchange)message);
                        break;
                    }
                    case EC_DIFFIE_HELLMAN: {
                        premasterSecret = this.receivedClientKeyExchange((ECDHClientKeyExchange)message);
                        break;
                    }
                    default: {
                        throw new HandshakeException(String.format("Unsupported key exchange algorithm %s", this.getKeyExchangeAlgorithm().name()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, message.getPeer()));
                    }
                }
                if (premasterSecret != null) {
                    this.generateKeys(premasterSecret);
                    SecretUtil.destroy(premasterSecret);
                }
                if (this.clientAuthenticationRequired && this.getKeyExchangeAlgorithm() == CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN) break;
                this.expectChangeCipherSpecMessage();
                break;
            }
            case CERTIFICATE_VERIFY: {
                this.receivedCertificateVerify((CertificateVerify)message);
                this.expectChangeCipherSpecMessage();
                break;
            }
            case FINISHED: {
                this.receivedClientFinished((Finished)message);
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected %s message from peer %s", new Object[]{message.getMessageType(), message.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, message.getPeer()));
            }
        }
    }

    private void receivedClientCertificate(CertificateMessage message) throws HandshakeException {
        this.clientCertificate = message;
        this.clientPublicKey = message.getPublicKey();
        if (this.clientAuthenticationRequired && message.getCertificateChain() != null && this.clientPublicKey == null) {
            this.LOGGER.debug("Client authentication failed: missing certificate!");
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
            throw new HandshakeException("Client Certificate required!", alert);
        }
        this.verifyCertificate(message);
        if (this.clientPublicKey == null) {
            this.states = EMPTY_CLIENT_CERTIFICATE;
        }
    }

    private void receivedCertificateVerify(CertificateVerify message) throws HandshakeException {
        this.certificateVerify = message;
        this.handshakeMessages.remove(this.handshakeMessages.size() - 1);
        message.verifySignature(this.clientPublicKey, this.handshakeMessages);
        this.handshakeMessages.add(message);
        CertPath peerCertPath = this.clientCertificate.getCertificateChain();
        if (peerCertPath != null) {
            this.session.setPeerIdentity(new X509CertPath(peerCertPath));
        } else {
            this.session.setPeerIdentity(new RawPublicKeyIdentity(this.clientPublicKey));
        }
    }

    private void receivedClientFinished(Finished message) throws HandshakeException {
        MessageDigest mdWithClientFinished;
        if (CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN.equals((Object)this.getKeyExchangeAlgorithm()) && this.clientAuthenticationRequired && (this.clientCertificate == null || this.certificateVerify == null)) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
            throw new HandshakeException("Client did not send required authentication messages.", alert);
        }
        this.flightNumber += 2;
        DTLSFlight flight = new DTLSFlight(this.getSession(), this.flightNumber);
        MessageDigest md = this.getHandshakeMessageDigest();
        try {
            mdWithClientFinished = (MessageDigest)md.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HandshakeException("Cannot create FINISHED message hash", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, message.getPeer()));
        }
        message.verifyData(this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, true, md.digest());
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage(this.session.getPeer());
        this.wrapMessage(flight, changeCipherSpecMessage);
        this.setCurrentWriteState();
        mdWithClientFinished.update(message.toByteArray());
        Finished finished = new Finished(this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, this.isClient, mdWithClientFinished.digest(), this.session.getPeer());
        this.wrapMessage(flight, finished);
        this.sendLastFlight(flight);
        this.sessionEstablished();
    }

    private void receivedClientHello(ClientHello clientHello) throws HandshakeException {
        this.handshakeStarted();
        byte[] cookie = clientHello.getCookie();
        this.flightNumber = cookie != null && cookie.length > 0 ? 4 : 2;
        DTLSFlight flight = new DTLSFlight(this.getSession(), this.flightNumber);
        this.createServerHello(clientHello, flight);
        this.createCertificateMessage(clientHello, flight);
        this.createServerKeyExchange(clientHello, flight);
        boolean clientCertificate = this.createCertificateRequest(clientHello, flight);
        this.states = clientCertificate ? CLIENT_CERTIFICATE : NO_CLIENT_CERTIFICATE;
        this.statesIndex = -1;
        ServerHelloDone serverHelloDone = new ServerHelloDone(this.session.getPeer());
        this.wrapMessage(flight, serverHelloDone);
        this.sendFlight(flight);
    }

    private void createServerHello(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        ProtocolVersion serverVersion = this.negotiateProtocolVersion(clientHello.getClientVersion());
        this.clientRandom = clientHello.getRandom();
        this.serverRandom = new Random();
        SessionId sessionId = this.useNoSessionId ? SessionId.emptySessionId() : new SessionId();
        this.session.setSessionIdentifier(sessionId);
        if (!clientHello.getCompressionMethods().contains((Object)CompressionMethod.NULL)) {
            throw new HandshakeException("Client does not support NULL compression method", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, clientHello.getPeer()));
        }
        this.session.setCompressionMethod(CompressionMethod.NULL);
        HelloExtensions serverHelloExtensions = new HelloExtensions();
        this.negotiateCipherSuite(clientHello, serverHelloExtensions);
        this.processHelloExtensions(clientHello, serverHelloExtensions);
        ServerHello serverHello = new ServerHello(serverVersion, this.serverRandom, sessionId, this.session.getCipherSuite(), this.session.getCompressionMethod(), serverHelloExtensions, this.session.getPeer());
        this.wrapMessage(flight, serverHello);
    }

    private void createCertificateMessage(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        CertificateMessage certificateMessage = null;
        if (this.session.getCipherSuite().requiresServerCertificateMessage()) {
            if (CertificateType.RAW_PUBLIC_KEY == this.session.sendCertificateType()) {
                certificateMessage = new CertificateMessage(this.publicKey.getEncoded(), this.session.getPeer());
            } else if (CertificateType.X_509 == this.session.sendCertificateType()) {
                certificateMessage = new CertificateMessage(this.certificateChain, this.session.getPeer());
            } else {
                throw new IllegalArgumentException("Certificate type " + (Object)((Object)this.session.sendCertificateType()) + " not supported!");
            }
            this.wrapMessage(flight, certificateMessage);
        }
    }

    private void createServerKeyExchange(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        ServerKeyExchange serverKeyExchange = null;
        switch (this.getKeyExchangeAlgorithm()) {
            case EC_DIFFIE_HELLMAN: {
                this.signatureAndHashAlgorithm = new SignatureAndHashAlgorithm(SignatureAndHashAlgorithm.HashAlgorithm.SHA256, SignatureAndHashAlgorithm.SignatureAlgorithm.ECDSA);
                try {
                    this.ecdhe = new ECDHECryptography(this.negotiatedSupportedGroup.getEcParams());
                    serverKeyExchange = new ECDHServerKeyExchange(this.signatureAndHashAlgorithm, this.ecdhe, this.privateKey, this.clientRandom, this.serverRandom, this.negotiatedSupportedGroup.getId(), this.session.getPeer());
                    break;
                }
                catch (GeneralSecurityException e) {
                    throw new HandshakeException(String.format("Error performing EC Diffie Hellman key exchange: %s", e.getMessage()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.getPeerAddress()));
                }
            }
            case PSK: {
                break;
            }
            case ECDHE_PSK: {
                try {
                    this.ecdhe = new ECDHECryptography(this.negotiatedSupportedGroup.getEcParams());
                    serverKeyExchange = new EcdhPskServerKeyExchange(PskPublicInformation.EMPTY, this.ecdhe, this.clientRandom, this.serverRandom, this.negotiatedSupportedGroup.getId(), this.session.getPeer());
                    break;
                }
                catch (GeneralSecurityException e) {
                    throw new HandshakeException(String.format("Error performing EC Diffie Hellman key exchange: %s", e.getMessage()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.getPeerAddress()));
                }
            }
        }
        if (serverKeyExchange != null) {
            this.wrapMessage(flight, serverKeyExchange);
        }
    }

    private boolean createCertificateRequest(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        if ((this.clientAuthenticationWanted || this.clientAuthenticationRequired) && this.signatureAndHashAlgorithm != null) {
            CertificateRequest certificateRequest = new CertificateRequest(this.session.getPeer());
            certificateRequest.addCertificateType(CertificateRequest.ClientCertificateType.ECDSA_SIGN);
            certificateRequest.addSignatureAlgorithm(this.signatureAndHashAlgorithm);
            if (this.certificateVerifier != null) {
                certificateRequest.addCertificateAuthorities(this.certificateVerifier.getAcceptedIssuers());
            }
            this.wrapMessage(flight, certificateRequest);
            return true;
        }
        return false;
    }

    private SecretKey receivedClientKeyExchange(ECDHClientKeyExchange message) {
        return this.ecdhe.generateSecret(message.getEncodedPoint());
    }

    private SecretKey receivedClientKeyExchange(PSKClientKeyExchange message) throws HandshakeException {
        this.preSharedKeyIdentity = message.getIdentity();
        PskUtil pskUtil = new PskUtil(this.sniEnabled, this.session, this.pskStore, this.preSharedKeyIdentity);
        SecretKey premaster = pskUtil.generatePremasterSecretFromPSK(null);
        SecretUtil.destroy(pskUtil);
        return premaster;
    }

    private SecretKey receivedClientKeyExchange(EcdhPskClientKeyExchange message) throws HandshakeException {
        this.preSharedKeyIdentity = message.getIdentity();
        PskUtil pskUtil = new PskUtil(this.sniEnabled, this.session, this.pskStore, this.preSharedKeyIdentity);
        SecretKey eck = this.ecdhe.generateSecret(message.getEncodedPoint());
        SecretKey premaster = pskUtil.generatePremasterSecretFromPSK(eck);
        SecretUtil.destroy(pskUtil);
        SecretUtil.destroy(eck);
        return premaster;
    }

    protected void processHelloExtensions(ClientHello clientHello, HelloExtensions serverHelloExtensions) {
        ConnectionIdExtension connectionIdExtension;
        ServerNameExtension serverNameExt;
        MaxFragmentLengthExtension maxFragmentLengthExt = clientHello.getMaxFragmentLengthExtension();
        if (maxFragmentLengthExt != null) {
            this.session.setMaxFragmentLength(maxFragmentLengthExt.getFragmentLength().length());
            serverHelloExtensions.addExtension(maxFragmentLengthExt);
            this.LOGGER.debug("Negotiated max. fragment length [{} bytes] with peer [{}]", (Object)maxFragmentLengthExt.getFragmentLength().length(), (Object)clientHello.getPeer());
        }
        if ((serverNameExt = clientHello.getServerNameExtension()) != null) {
            if (this.sniEnabled) {
                this.session.setServerNames(serverNameExt.getServerNames());
                serverHelloExtensions.addExtension(ServerNameExtension.emptyServerNameIndication());
                this.session.setSniSupported(true);
                this.LOGGER.debug("using server name indication received from peer [{}]", (Object)clientHello.getPeer());
            } else {
                this.LOGGER.debug("client [{}] included SNI in HELLO but SNI support is disabled", (Object)clientHello.getPeer());
            }
        }
        if (this.connectionIdGenerator != null && (connectionIdExtension = clientHello.getConnectionIdExtension()) != null) {
            this.session.setWriteConnectionId(connectionIdExtension.getConnectionId());
            ConnectionId connectionId = this.connectionIdGenerator.useConnectionId() ? this.getConnection().getConnectionId() : ConnectionId.EMPTY;
            ConnectionIdExtension extension = ConnectionIdExtension.fromConnectionId(connectionId);
            serverHelloExtensions.addExtension(extension);
        }
    }

    @Override
    public void startHandshake() throws HandshakeException {
        throw new HandshakeException("starting an handshake is not supported for server handshaker!", null);
    }

    private ProtocolVersion negotiateProtocolVersion(ProtocolVersion clientVersion) throws HandshakeException {
        ProtocolVersion version = new ProtocolVersion();
        if (clientVersion.compareTo(version) >= 0) {
            return new ProtocolVersion();
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.PROTOCOL_VERSION, this.session.getPeer());
        throw new HandshakeException("The server only supports DTLS v1.2", alert);
    }

    private void negotiateCipherSuite(ClientHello clientHello, HelloExtensions serverHelloExtensions) throws HandshakeException {
        CertificateType supportedServerCertType = this.getSupportedServerCertificateType(clientHello);
        CertificateType supportedClientCertType = this.getSupportedClientCertificateType(clientHello);
        ECDHECryptography.SupportedGroup group = ServerHandshaker.negotiateNamedCurve(clientHello);
        for (CipherSuite cipherSuite : clientHello.getCipherSuites()) {
            if (cipherSuite == CipherSuite.TLS_NULL_WITH_NULL_NULL || !this.supportedCipherSuites.contains((Object)cipherSuite) || !this.isEligible(cipherSuite, supportedServerCertType, supportedClientCertType, group)) continue;
            this.negotiatedServerCertificateType = supportedServerCertType;
            this.negotiatedClientCertificateType = supportedClientCertType;
            this.negotiatedSupportedGroup = group;
            this.session.setCipherSuite(cipherSuite);
            this.addServerHelloExtensions(cipherSuite, clientHello, serverHelloExtensions);
            this.session.setParameterAvailable();
            this.LOGGER.debug("Negotiated cipher suite [{}] with peer [{}]", (Object)cipherSuite.name(), (Object)this.getPeerAddress());
            return;
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
        throw new HandshakeException("Client proposed unsupported cipher suites only", alert);
    }

    private boolean isEligible(CipherSuite cipher, CertificateType supportedServerCertType, CertificateType supportedClientCertType, ECDHECryptography.SupportedGroup group) {
        boolean result = true;
        if (cipher.isEccBased()) {
            result &= group != null;
        }
        if (cipher.requiresServerCertificateMessage()) {
            result &= supportedServerCertType != null;
            if (this.clientAuthenticationRequired || this.clientAuthenticationWanted) {
                result &= supportedClientCertType != null;
            }
        }
        return result;
    }

    private void addServerHelloExtensions(CipherSuite negotiatedCipherSuite, ClientHello clientHello, HelloExtensions extensions) {
        CertificateTypeExtension ext;
        if (this.negotiatedClientCertificateType != null) {
            this.session.setReceiveCertificateType(this.negotiatedClientCertificateType);
            if (clientHello.getClientCertificateTypeExtension() != null) {
                ext = new ClientCertificateTypeExtension(this.negotiatedClientCertificateType);
                extensions.addExtension(ext);
            }
        }
        if (this.negotiatedServerCertificateType != null) {
            this.session.setSendCertificateType(this.negotiatedServerCertificateType);
            if (clientHello.getServerCertificateTypeExtension() != null) {
                ext = new ServerCertificateTypeExtension(this.negotiatedServerCertificateType);
                extensions.addExtension(ext);
            }
        }
        if (negotiatedCipherSuite.isEccBased() && clientHello.getSupportedPointFormatsExtension() != null) {
            List<SupportedPointFormatsExtension.ECPointFormat> formats = Arrays.asList(SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED);
            extensions.addExtension(new SupportedPointFormatsExtension(formats));
        }
    }

    private static ECDHECryptography.SupportedGroup negotiateNamedCurve(ClientHello clientHello) {
        ECDHECryptography.SupportedGroup result;
        block2: {
            SupportedEllipticCurvesExtension extension;
            List<ECDHECryptography.SupportedGroup> preferredGroups;
            block1: {
                result = null;
                preferredGroups = ECDHECryptography.SupportedGroup.getPreferredGroups();
                extension = clientHello.getSupportedEllipticCurvesExtension();
                if (extension != null) break block1;
                if (preferredGroups.isEmpty()) break block2;
                result = preferredGroups.get(0);
                break block2;
            }
            for (Integer preferredGroupId : extension.getSupportedGroupIds()) {
                ECDHECryptography.SupportedGroup group = ECDHECryptography.SupportedGroup.fromId(preferredGroupId);
                if (group == null || !group.isUsable() || !preferredGroups.contains((Object)group)) continue;
                result = group;
                break;
            }
        }
        return result;
    }

    private CertificateType getSupportedClientCertificateType(ClientHello clientHello) {
        return ServerHandshaker.getSupportedCertificateType(clientHello.getClientCertificateTypeExtension(), this.supportedClientCertificateTypes);
    }

    private CertificateType getSupportedServerCertificateType(ClientHello clientHello) {
        return ServerHandshaker.getSupportedCertificateType(clientHello.getServerCertificateTypeExtension(), this.supportedServerCertificateTypes);
    }

    private static CertificateType getSupportedCertificateType(CertificateTypeExtension certTypeExt, List<CertificateType> supportedCertificateTypes) {
        if (supportedCertificateTypes != null) {
            if (certTypeExt != null) {
                for (CertificateType certType : certTypeExt.getCertificateTypes()) {
                    if (!supportedCertificateTypes.contains((Object)certType)) continue;
                    return certType;
                }
            } else if (supportedCertificateTypes.contains((Object)CertificateType.X_509)) {
                return CertificateType.X_509;
            }
        }
        return null;
    }

    final CertificateType getNegotiatedClientCertificateType() {
        return this.negotiatedClientCertificateType;
    }

    final CertificateType getNegotiatedServerCertificateType() {
        return this.negotiatedServerCertificateType;
    }

    final ECDHECryptography.SupportedGroup getNegotiatedSupportedGroup() {
        return this.negotiatedSupportedGroup;
    }
}

