/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.JSONPointer;

final class JSONPatch {
    private JSONPatch() {
    }

    private static CBORObject AddOperation(CBORObject o, String valueOpStr, String path, CBORObject value) {
        if (path == null) {
            throw new CBORException("Patch " + valueOpStr);
        }
        if (path.length() == 0) {
            o = value;
        } else {
            JSONPointer pointer = JSONPointer.FromPointer(o, path);
            CBORObject parent = pointer.GetParent();
            if (pointer.GetParent().getType() == CBORType.Array) {
                int index = pointer.GetIndex();
                if (index < 0) {
                    throw new CBORException("Patch " + valueOpStr + " path");
                }
                parent.Insert(index, value);
            } else if (pointer.GetParent().getType() == CBORType.Map) {
                String key = pointer.GetKey();
                parent.Set(key, value);
            } else {
                throw new CBORException("Patch " + valueOpStr + " path");
            }
        }
        return o;
    }

    private static CBORObject CloneCbor(CBORObject o) {
        switch (o.getType()) {
            case ByteString: 
            case Map: 
            case Array: {
                return CBORObject.DecodeFromBytes(o.EncodeToBytes());
            }
        }
        return o;
    }

    private static String GetString(CBORObject o, String str) {
        CBORObject co = o.GetOrDefault(str, null);
        if (co == null) {
            throw new CBORException(str + " not found");
        }
        if (co.getType() != CBORType.TextString) {
            throw new CBORException("Not a text String type");
        }
        return co.AsString();
    }

    public static CBORObject Patch(CBORObject o, CBORObject ptch) {
        if (o == null) {
            throw new CBORException("Object is null");
        }
        if (ptch == null) {
            throw new CBORException("patch is null");
        }
        if (ptch.getType() != CBORType.Array) {
            throw new CBORException("patch is not an array");
        }
        o = JSONPatch.CloneCbor(o);
        for (int i = 0; i < ptch.size(); ++i) {
            JSONPointer pointer;
            String fromPath;
            String path;
            CBORObject value;
            CBORObject patchOp = ptch.get(i);
            String valueOpStr = JSONPatch.GetString(patchOp, "op");
            if ("add".equals(valueOpStr)) {
                value = patchOp.GetOrDefault("value", null);
                if (value == null) {
                    throw new CBORException("Patch " + valueOpStr + " value");
                }
                value = patchOp.get("value");
                o = JSONPatch.AddOperation(o, valueOpStr, JSONPatch.GetString(patchOp, "path"), value);
                continue;
            }
            if ("replace".equals(valueOpStr)) {
                value = patchOp.GetOrDefault("value", null);
                if (value == null) {
                    throw new CBORException("Patch " + valueOpStr + " value");
                }
                o = JSONPatch.ReplaceOperation(o, valueOpStr, JSONPatch.GetString(patchOp, "path"), JSONPatch.CloneCbor(value));
                continue;
            }
            if ("remove".equals(valueOpStr)) {
                path = JSONPatch.GetString(patchOp, "path");
                if (path == null) {
                    throw new CBORException("Patch " + valueOpStr + " path");
                }
                if (path.length() == 0) {
                    o = null;
                    continue;
                }
                JSONPatch.RemoveOperation(o, valueOpStr, JSONPatch.GetString(patchOp, "path"));
                continue;
            }
            if ("move".equals(valueOpStr)) {
                path = JSONPatch.GetString(patchOp, "path");
                if (path == null) {
                    throw new CBORException("Patch " + valueOpStr + " path");
                }
                fromPath = JSONPatch.GetString(patchOp, "from");
                if (fromPath == null) {
                    throw new CBORException("Patch " + valueOpStr + " from");
                }
                if (path.equals(fromPath) && (pointer = JSONPointer.FromPointer(o, path)).Exists()) {
                    return o;
                }
                CBORObject movedObj = JSONPatch.RemoveOperation(o, valueOpStr, fromPath);
                o = JSONPatch.AddOperation(o, valueOpStr, path, JSONPatch.CloneCbor(movedObj));
                continue;
            }
            if ("copy".equals(valueOpStr)) {
                path = JSONPatch.GetString(patchOp, "path");
                fromPath = JSONPatch.GetString(patchOp, "from");
                if (path == null) {
                    throw new CBORException("Patch " + valueOpStr + " path");
                }
                if (fromPath == null) {
                    throw new CBORException("Patch " + valueOpStr + " from");
                }
                pointer = JSONPointer.FromPointer(o, fromPath);
                if (!pointer.Exists()) {
                    throw new CBORException("Patch " + valueOpStr + " " + fromPath);
                }
                CBORObject copiedObj = pointer.GetValue();
                o = JSONPatch.AddOperation(o, valueOpStr, path, JSONPatch.CloneCbor(copiedObj));
                continue;
            }
            if ("test".equals(valueOpStr)) {
                path = JSONPatch.GetString(patchOp, "path");
                if (path == null) {
                    throw new CBORException("Patch " + valueOpStr + " path");
                }
                CBORObject value2 = null;
                if (!patchOp.ContainsKey("value")) {
                    throw new CBORException("Patch " + valueOpStr + " value");
                }
                value2 = patchOp.get("value");
                pointer = JSONPointer.FromPointer(o, path);
                if (!pointer.Exists()) {
                    throw new CBORException("Patch " + valueOpStr + " " + path);
                }
                CBORObject testedObj = pointer.GetValue();
                if (!(testedObj == null ? value2 != null : !((Object)testedObj).equals(value2))) continue;
                throw new CBORException("Patch " + valueOpStr);
            }
            throw new CBORException("Unrecognized op");
        }
        return o == null ? CBORObject.Null : o;
    }

    private static CBORObject RemoveOperation(CBORObject o, String valueOpStr, String path) {
        if (path == null) {
            throw new CBORException("Patch " + valueOpStr);
        }
        if (path.length() == 0) {
            return o;
        }
        JSONPointer pointer = JSONPointer.FromPointer(o, path);
        if (!pointer.Exists()) {
            throw new CBORException("Patch " + valueOpStr + " " + path);
        }
        o = pointer.GetValue();
        if (pointer.GetParent().getType() == CBORType.Array) {
            pointer.GetParent().RemoveAt(pointer.GetIndex());
        } else if (pointer.GetParent().getType() == CBORType.Map) {
            pointer.GetParent().Remove(CBORObject.FromObject(pointer.GetKey()));
        }
        return o;
    }

    private static CBORObject ReplaceOperation(CBORObject o, String valueOpStr, String path, CBORObject value) {
        if (path == null) {
            throw new CBORException("Patch " + valueOpStr);
        }
        if (path.length() == 0) {
            o = value;
        } else {
            JSONPointer pointer = JSONPointer.FromPointer(o, path);
            if (!pointer.Exists()) {
                throw new CBORException("Patch " + valueOpStr + " " + path);
            }
            if (pointer.GetParent().getType() == CBORType.Array) {
                int index = pointer.GetIndex();
                if (index < 0) {
                    throw new CBORException("Patch " + valueOpStr + " path");
                }
                pointer.GetParent().Set(index, value);
            } else if (pointer.GetParent().getType() == CBORType.Map) {
                String key = pointer.GetKey();
                pointer.GetParent().Set(key, value);
            } else {
                throw new CBORException("Patch " + valueOpStr + " path");
            }
        }
        return o;
    }
}

