/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.eclipse.californium.cli.ClientBaseConfig;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.elements.util.StringUtil;
import picocli.CommandLine;

public class ClientConfig
extends ClientBaseConfig {
    @CommandLine.ArgGroup(exclusive=true)
    public ContentType contentType;
    @CommandLine.ArgGroup(exclusive=true)
    public Payload payload;
    public byte[] payloadBytes;
    @CommandLine.Option(names={"--payload-format"}, description={"apply format to payload."})
    public boolean payloadFormat;
    @CommandLine.ArgGroup(exclusive=true)
    public MessageType messageType;
    @CommandLine.Option(names={"-m", "--method"}, description={"use method. GET|PUT|POST|DELETE|FETCH|PATCH|IPATCH."})
    public CoAP.Code method;
    protected static CommandLine.INegatableOptionTransformer messageTypeTransformer = new CommandLine.INegatableOptionTransformer(){
        private CommandLine.INegatableOptionTransformer delegate = CommandLine.RegexTransformer.createDefault();

        public String makeNegative(String optionName, CommandLine.Model.CommandSpec cmd) {
            if ("--con".equals(optionName)) {
                return "--non";
            }
            return this.delegate.makeNegative(optionName, cmd);
        }

        public String makeSynopsis(String optionName, CommandLine.Model.CommandSpec cmd) {
            if ("--con".equals(optionName)) {
                return "(--con|--non)";
            }
            return this.delegate.makeSynopsis(optionName, cmd);
        }
    };

    @Override
    public void register(CommandLine cmd) {
        super.register(cmd);
        cmd.setNegatableOptionTransformer(messageTypeTransformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void defaults() {
        super.defaults();
        if (this.contentType != null) {
            this.contentType.defaults();
        }
        if (this.payload == null || this.payloadBytes != null) return;
        if (this.payload.text != null) {
            this.payloadBytes = this.payload.text.getBytes();
            return;
        }
        if (this.payload.hex != null) {
            this.payloadBytes = StringUtil.hex2ByteArray((String)this.payload.hex);
            return;
        }
        if (this.payload.base64 != null) {
            this.payloadBytes = StringUtil.base64ToByteArray((String)this.payload.base64);
            return;
        }
        if (this.payload.file == null) return;
        int max = this.networkConfig.getInt("MAX_RESOURCE_BODY_SIZE");
        File file = new File(this.payload.file);
        if (file.canRead()) {
            long length = file.length();
            if (length <= (long)max) {
                this.payloadBytes = new byte[(int)length];
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    int len = ((InputStream)in).read(this.payloadBytes);
                    if ((long)len == length) return;
                    LOGGER.error("file {} with {} bytes, read {} bytes!", new Object[]{this.payload.file, length, len});
                    return;
                }
                catch (FileNotFoundException e) {
                    LOGGER.error("Missing file {}", (Object)this.payload.file, (Object)e);
                    return;
                }
                catch (IOException e) {
                    LOGGER.error("Error reading file {}", (Object)this.payload.file, (Object)e);
                    return;
                }
                finally {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e) {
                            LOGGER.error("Error closing file {}", (Object)this.payload.file, (Object)e);
                        }
                    }
                }
            }
            LOGGER.error("file {} with {} bytes is too large! (Maximum {} bytes.)", new Object[]{this.payload.file, length, max});
            return;
        }
        LOGGER.error("Can not read file {} ({})", (Object)this.payload.file, (Object)file.getAbsolutePath());
    }

    @Override
    public ClientConfig create(String id, byte[] secret) {
        return (ClientConfig)super.create(id, secret);
    }

    @Override
    public ClientConfig create(PrivateKey privateKey, PublicKey publicKey) {
        return (ClientConfig)super.create(privateKey, publicKey);
    }

    public static class MessageType {
        @CommandLine.Option(names={"--con"}, description={"send request confirmed."})
        public boolean con;
        @CommandLine.Option(names={"--non"}, description={"send request non-confirmed."})
        public boolean non;
    }

    public static class Payload {
        @CommandLine.Option(names={"--payload"}, description={"payload, utf8"})
        public String text;
        @CommandLine.Option(names={"--payloadhex"}, description={"payload, hexadecimal"})
        public String hex;
        @CommandLine.Option(names={"--payload64"}, description={"payload, base64"})
        public String base64;
        @CommandLine.Option(names={"--payload-file"}, description={"payload from file"})
        public String file;
    }

    public static class ContentType {
        @CommandLine.Option(names={"--json"}, description={"use json payload."})
        public boolean json;
        @CommandLine.Option(names={"--cbor"}, description={"use cbor payload."})
        public boolean cbor;
        @CommandLine.Option(names={"--xml"}, description={"use xml payload."})
        public boolean xml;
        @CommandLine.Option(names={"--text"}, description={"use plain-text payload."})
        public boolean text;
        @CommandLine.Option(names={"--octets"}, description={"use octet stream payload."})
        public boolean octets;
        @CommandLine.Option(names={"--ctype"}, paramLabel="TYPE", description={"use content type for payload."})
        public String type;
        public int contentType;

        void defaults() {
            if (this.type != null) {
                this.contentType = MediaTypeRegistry.parse((String)this.type);
            } else if (this.text) {
                this.contentType = 0;
            } else if (this.json) {
                this.contentType = 50;
            } else if (this.cbor) {
                this.contentType = 60;
            } else if (this.xml) {
                this.contentType = 41;
            } else if (this.octets) {
                this.contentType = 42;
            }
        }
    }
}

